/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.connect.mirror.GroupFilter;
import org.apache.kafka.connect.mirror.MirrorUtils;

public class DefaultGroupFilter
implements GroupFilter {
    public static final String GROUPS_INCLUDE_CONFIG = "groups";
    private static final String GROUPS_INCLUDE_DOC = "List of consumer group names and/or regexes to replicate.";
    public static final String GROUPS_INCLUDE_DEFAULT = ".*";
    public static final String GROUPS_EXCLUDE_CONFIG = "groups.exclude";
    public static final String GROUPS_EXCLUDE_CONFIG_ALIAS = "groups.blacklist";
    private static final String GROUPS_EXCLUDE_DOC = "List of consumer group names and/or regexes that should not be replicated.";
    public static final String GROUPS_EXCLUDE_DEFAULT = "console-consumer-.*, connect-.*, __.*";
    private Pattern includePattern;
    private Pattern excludePattern;

    @Override
    public void configure(Map<String, ?> props) {
        GroupFilterConfig config = new GroupFilterConfig(props);
        this.includePattern = config.includePattern();
        this.excludePattern = config.excludePattern();
    }

    @Override
    public void close() {
    }

    private boolean included(String group) {
        return this.includePattern != null && this.includePattern.matcher(group).matches();
    }

    private boolean excluded(String group) {
        return this.excludePattern != null && this.excludePattern.matcher(group).matches();
    }

    @Override
    public boolean shouldReplicateGroup(String group) {
        return this.included(group) && !this.excluded(group);
    }

    static class GroupFilterConfig
    extends AbstractConfig {
        static final ConfigDef DEF = new ConfigDef().define("groups", ConfigDef.Type.LIST, (Object)".*", ConfigDef.Importance.HIGH, "List of consumer group names and/or regexes to replicate.").define("groups.exclude", ConfigDef.Type.LIST, (Object)"console-consumer-.*, connect-.*, __.*", ConfigDef.Importance.HIGH, "List of consumer group names and/or regexes that should not be replicated.").define("groups.blacklist", ConfigDef.Type.LIST, null, ConfigDef.Importance.HIGH, "Deprecated. Use groups.exclude instead.");

        GroupFilterConfig(Map<String, ?> props) {
            super(DEF, ConfigUtils.translateDeprecatedConfigs(props, (String[][])new String[][]{{DefaultGroupFilter.GROUPS_EXCLUDE_CONFIG, DefaultGroupFilter.GROUPS_EXCLUDE_CONFIG_ALIAS}}), false);
        }

        Pattern includePattern() {
            return MirrorUtils.compilePatternList(this.getList(DefaultGroupFilter.GROUPS_INCLUDE_CONFIG));
        }

        Pattern excludePattern() {
            return MirrorUtils.compilePatternList(this.getList(DefaultGroupFilter.GROUPS_EXCLUDE_CONFIG));
        }
    }
}

