/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorPluginInfo;
import org.apache.kafka.connect.tools.MockConnector;
import org.apache.kafka.connect.tools.MockSinkConnector;
import org.apache.kafka.connect.tools.MockSourceConnector;
import org.apache.kafka.connect.tools.SchemaSourceConnector;
import org.apache.kafka.connect.tools.VerifiableSinkConnector;
import org.apache.kafka.connect.tools.VerifiableSourceConnector;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.util.ReflectionsUtil;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class PluginDiscovery {
    private static final List<Class<? extends Connector>> CONNECTOR_EXCLUDES = Arrays.asList(VerifiableSourceConnector.class, VerifiableSinkConnector.class, MockConnector.class, MockSourceConnector.class, MockSinkConnector.class, SchemaSourceConnector.class);
    private static final List<Class<? extends Transformation>> TRANSFORMATION_EXCLUDES = Arrays.asList(new Object[0]);
    private static boolean scanned = false;
    private static List<ConnectorPluginInfo> validConnectorPlugins;
    private static List<Class<? extends Transformation>> validTransformationPlugins;

    public static synchronized List<ConnectorPluginInfo> connectorPlugins() {
        PluginDiscovery.scanClasspathForPlugins();
        return validConnectorPlugins;
    }

    public static synchronized List<Class<? extends Transformation>> transformationPlugins() {
        PluginDiscovery.scanClasspathForPlugins();
        return validTransformationPlugins;
    }

    public static synchronized void scanClasspathForPlugins() {
        if (scanned) {
            return;
        }
        ReflectionsUtil.registerUrlTypes();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forJavaClassPath()));
        validConnectorPlugins = Collections.unmodifiableList(PluginDiscovery.connectorPlugins(reflections));
        validTransformationPlugins = Collections.unmodifiableList(PluginDiscovery.transformationPlugins(reflections));
        scanned = true;
    }

    private static List<ConnectorPluginInfo> connectorPlugins(Reflections reflections) {
        Set connectorClasses = reflections.getSubTypesOf(Connector.class);
        connectorClasses.removeAll(CONNECTOR_EXCLUDES);
        ArrayList<ConnectorPluginInfo> connectorPlugins = new ArrayList<ConnectorPluginInfo>(connectorClasses.size());
        for (Class connectorClass : connectorClasses) {
            if (!PluginDiscovery.isConcrete(connectorClass)) continue;
            connectorPlugins.add(new ConnectorPluginInfo(connectorClass.getCanonicalName()));
        }
        Collections.sort(connectorPlugins, new Comparator<ConnectorPluginInfo>(){

            @Override
            public int compare(ConnectorPluginInfo a, ConnectorPluginInfo b) {
                return a.clazz().compareTo(b.clazz());
            }
        });
        return connectorPlugins;
    }

    private static List<Class<? extends Transformation>> transformationPlugins(Reflections reflections) {
        Set transformationClasses = reflections.getSubTypesOf(Transformation.class);
        transformationClasses.removeAll(TRANSFORMATION_EXCLUDES);
        ArrayList<Class<? extends Transformation>> transformationPlugins = new ArrayList<Class<? extends Transformation>>(transformationClasses.size());
        for (Class transformationClass : transformationClasses) {
            if (!PluginDiscovery.isConcrete(transformationClass)) continue;
            transformationPlugins.add(transformationClass);
        }
        Collections.sort(transformationPlugins, new Comparator<Class<? extends Transformation>>(){

            @Override
            public int compare(Class<? extends Transformation> a, Class<? extends Transformation> b) {
                return a.getCanonicalName().compareTo(b.getCanonicalName());
            }
        });
        return transformationPlugins;
    }

    private static boolean isConcrete(Class<?> cls) {
        int mod = cls.getModifiers();
        return !Modifier.isAbstract(mod) && !Modifier.isInterface(mod);
    }

    public static void main(String ... args) {
        System.out.println(PluginDiscovery.connectorPlugins());
        System.out.println(PluginDiscovery.transformationPlugins());
    }
}

