/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Table<R, C, V> {
    private Map<R, Map<C, V>> table = new HashMap<R, Map<C, V>>();

    public V put(R row, C column, V value) {
        Map<C, V> columns = this.table.get(row);
        if (columns == null) {
            columns = new HashMap<C, V>();
            this.table.put(row, columns);
        }
        return columns.put(column, value);
    }

    public V get(R row, C column) {
        Map<C, V> columns = this.table.get(row);
        if (columns == null) {
            return null;
        }
        return columns.get(column);
    }

    public Map<C, V> remove(R row) {
        return this.table.remove(row);
    }

    public V remove(R row, C column) {
        Map<C, V> columns = this.table.get(row);
        if (columns == null) {
            return null;
        }
        V value = columns.remove(column);
        if (columns.isEmpty()) {
            this.table.remove(row);
        }
        return value;
    }

    public Map<C, V> row(R row) {
        Map<C, V> columns = this.table.get(row);
        if (columns == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(columns);
    }
}

