/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.errors.ToleranceType;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.transforms.Transformation;

public class ConnectorConfig
extends AbstractConfig {
    protected static final String COMMON_GROUP = "Common";
    protected static final String TRANSFORMS_GROUP = "Transforms";
    protected static final String ERROR_GROUP = "Error Handling";
    public static final String NAME_CONFIG = "name";
    private static final String NAME_DOC = "Globally unique name to use for this connector.";
    private static final String NAME_DISPLAY = "Connector name";
    public static final String CONNECTOR_CLASS_CONFIG = "connector.class";
    private static final String CONNECTOR_CLASS_DOC = "Name or alias of the class for this connector. Must be a subclass of org.apache.kafka.connect.connector.Connector. If the connector is org.apache.kafka.connect.file.FileStreamSinkConnector, you can either specify this full name,  or use \"FileStreamSink\" or \"FileStreamSinkConnector\" to make the configuration a bit shorter";
    private static final String CONNECTOR_CLASS_DISPLAY = "Connector class";
    public static final String KEY_CONVERTER_CLASS_CONFIG = "key.converter";
    public static final String KEY_CONVERTER_CLASS_DOC = "Converter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the keys in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro.";
    public static final String KEY_CONVERTER_CLASS_DISPLAY = "Key converter class";
    public static final String VALUE_CONVERTER_CLASS_CONFIG = "value.converter";
    public static final String VALUE_CONVERTER_CLASS_DOC = "Converter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the values in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro.";
    public static final String VALUE_CONVERTER_CLASS_DISPLAY = "Value converter class";
    public static final String HEADER_CONVERTER_CLASS_CONFIG = "header.converter";
    public static final String HEADER_CONVERTER_CLASS_DOC = "HeaderConverter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the header values in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro. By default, the SimpleHeaderConverter is used to serialize header values to strings and deserialize them by inferring the schemas.";
    public static final String HEADER_CONVERTER_CLASS_DISPLAY = "Header converter class";
    public static final String HEADER_CONVERTER_CLASS_DEFAULT = null;
    public static final String TASKS_MAX_CONFIG = "tasks.max";
    private static final String TASKS_MAX_DOC = "Maximum number of tasks to use for this connector.";
    public static final int TASKS_MAX_DEFAULT = 1;
    private static final int TASKS_MIN_CONFIG = 1;
    private static final String TASK_MAX_DISPLAY = "Tasks max";
    public static final String TRANSFORMS_CONFIG = "transforms";
    private static final String TRANSFORMS_DOC = "Aliases for the transformations to be applied to records.";
    private static final String TRANSFORMS_DISPLAY = "Transforms";
    public static final String CONFIG_RELOAD_ACTION_CONFIG = "config.action.reload";
    private static final String CONFIG_RELOAD_ACTION_DOC = "The action that Connect should take on the connector when changes in external configuration providers result in a change in the connector's configuration properties. A value of 'none' indicates that Connect will do nothing. A value of 'restart' indicates that Connect should restart/reload the connector with the updated configuration properties.The restart may actually be scheduled in the future if the external configuration provider indicates that a configuration value will expire in the future.";
    private static final String CONFIG_RELOAD_ACTION_DISPLAY = "Reload Action";
    public static final String CONFIG_RELOAD_ACTION_NONE = Herder.ConfigReloadAction.NONE.name().toLowerCase(Locale.ROOT);
    public static final String CONFIG_RELOAD_ACTION_RESTART = Herder.ConfigReloadAction.RESTART.name().toLowerCase(Locale.ROOT);
    public static final String ERRORS_RETRY_TIMEOUT_CONFIG = "errors.retry.timeout";
    public static final String ERRORS_RETRY_TIMEOUT_DISPLAY = "Retry Timeout for Errors";
    public static final int ERRORS_RETRY_TIMEOUT_DEFAULT = 0;
    public static final String ERRORS_RETRY_TIMEOUT_DOC = "The maximum duration in milliseconds that a failed operation will be reattempted. The default is 0, which means no retries will be attempted. Use -1 for infinite retries.";
    public static final String ERRORS_RETRY_MAX_DELAY_CONFIG = "errors.retry.delay.max.ms";
    public static final String ERRORS_RETRY_MAX_DELAY_DISPLAY = "Maximum Delay Between Retries for Errors";
    public static final int ERRORS_RETRY_MAX_DELAY_DEFAULT = 60000;
    public static final String ERRORS_RETRY_MAX_DELAY_DOC = "The maximum duration in milliseconds between consecutive retry attempts. Jitter will be added to the delay once this limit is reached to prevent thundering herd issues.";
    public static final String ERRORS_TOLERANCE_CONFIG = "errors.tolerance";
    public static final String ERRORS_TOLERANCE_DISPLAY = "Error Tolerance";
    public static final ToleranceType ERRORS_TOLERANCE_DEFAULT = ToleranceType.NONE;
    public static final String ERRORS_TOLERANCE_DOC = "Behavior for tolerating errors during connector operation. 'none' is the default value and signals that any error will result in an immediate connector task failure; 'all' changes the behavior to skip over problematic records.";
    public static final String ERRORS_LOG_ENABLE_CONFIG = "errors.log.enable";
    public static final String ERRORS_LOG_ENABLE_DISPLAY = "Log Errors";
    public static final boolean ERRORS_LOG_ENABLE_DEFAULT = false;
    public static final String ERRORS_LOG_ENABLE_DOC = "If true, write each error and the details of the failed operation and problematic record to the Connect application log. This is 'false' by default, so that only errors that are not tolerated are reported.";
    public static final String ERRORS_LOG_INCLUDE_MESSAGES_CONFIG = "errors.log.include.messages";
    public static final String ERRORS_LOG_INCLUDE_MESSAGES_DISPLAY = "Log Error Details";
    public static final boolean ERRORS_LOG_INCLUDE_MESSAGES_DEFAULT = false;
    public static final String ERRORS_LOG_INCLUDE_MESSAGES_DOC = "Whether to the include in the log the Connect record that resulted in a failure. This is 'false' by default, which will prevent record keys, values, and headers from being written to log files, although some information such as topic and partition number will still be logged.";
    public static final String CONNECTOR_CLIENT_PRODUCER_OVERRIDES_PREFIX = "producer.override.";
    public static final String CONNECTOR_CLIENT_CONSUMER_OVERRIDES_PREFIX = "consumer.override.";
    public static final String CONNECTOR_CLIENT_ADMIN_OVERRIDES_PREFIX = "admin.override.";
    private final EnrichedConnectorConfig enrichedConfig;

    public static ConfigDef configDef() {
        int orderInGroup = 0;
        int orderInErrorGroup = 0;
        return new ConfigDef().define(NAME_CONFIG, ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)ConfigDef.NonEmptyStringWithoutControlChars.nonEmptyStringWithoutControlChars(), ConfigDef.Importance.HIGH, NAME_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.MEDIUM, NAME_DISPLAY).define(CONNECTOR_CLASS_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, CONNECTOR_CLASS_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.LONG, CONNECTOR_CLASS_DISPLAY).define(TASKS_MAX_CONFIG, ConfigDef.Type.INT, (Object)1, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, TASKS_MAX_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, TASK_MAX_DISPLAY).define(KEY_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, null, ConfigDef.Importance.LOW, KEY_CONVERTER_CLASS_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, KEY_CONVERTER_CLASS_DISPLAY).define(VALUE_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, null, ConfigDef.Importance.LOW, VALUE_CONVERTER_CLASS_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, VALUE_CONVERTER_CLASS_DISPLAY).define(HEADER_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, (Object)HEADER_CONVERTER_CLASS_DEFAULT, ConfigDef.Importance.LOW, HEADER_CONVERTER_CLASS_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, HEADER_CONVERTER_CLASS_DISPLAY).define(TRANSFORMS_CONFIG, ConfigDef.Type.LIST, Collections.emptyList(), (ConfigDef.Validator)ConfigDef.CompositeValidator.of((ConfigDef.Validator[])new ConfigDef.Validator[]{new ConfigDef.NonNullValidator(), new ConfigDef.Validator(){

            public void ensureValid(String name, Object value) {
                List transformAliases = (List)value;
                if (transformAliases.size() > new HashSet(transformAliases).size()) {
                    throw new ConfigException(name, value, "Duplicate alias provided.");
                }
            }

            public String toString() {
                return "unique transformation aliases";
            }
        }}), ConfigDef.Importance.LOW, TRANSFORMS_DOC, "Transforms", ++orderInGroup, ConfigDef.Width.LONG, "Transforms").define(CONFIG_RELOAD_ACTION_CONFIG, ConfigDef.Type.STRING, (Object)CONFIG_RELOAD_ACTION_RESTART, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{CONFIG_RELOAD_ACTION_NONE, CONFIG_RELOAD_ACTION_RESTART}), ConfigDef.Importance.LOW, CONFIG_RELOAD_ACTION_DOC, COMMON_GROUP, ++orderInGroup, ConfigDef.Width.MEDIUM, CONFIG_RELOAD_ACTION_DISPLAY).define(ERRORS_RETRY_TIMEOUT_CONFIG, ConfigDef.Type.LONG, (Object)0, ConfigDef.Importance.MEDIUM, ERRORS_RETRY_TIMEOUT_DOC, ERROR_GROUP, ++orderInErrorGroup, ConfigDef.Width.MEDIUM, ERRORS_RETRY_TIMEOUT_DISPLAY).define(ERRORS_RETRY_MAX_DELAY_CONFIG, ConfigDef.Type.LONG, (Object)60000, ConfigDef.Importance.MEDIUM, ERRORS_RETRY_MAX_DELAY_DOC, ERROR_GROUP, ++orderInErrorGroup, ConfigDef.Width.MEDIUM, ERRORS_RETRY_MAX_DELAY_DISPLAY).define(ERRORS_TOLERANCE_CONFIG, ConfigDef.Type.STRING, (Object)ERRORS_TOLERANCE_DEFAULT.value(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{ToleranceType.NONE.value(), ToleranceType.ALL.value()}), ConfigDef.Importance.MEDIUM, ERRORS_TOLERANCE_DOC, ERROR_GROUP, ++orderInErrorGroup, ConfigDef.Width.SHORT, ERRORS_TOLERANCE_DISPLAY).define(ERRORS_LOG_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, ERRORS_LOG_ENABLE_DOC, ERROR_GROUP, ++orderInErrorGroup, ConfigDef.Width.SHORT, ERRORS_LOG_ENABLE_DISPLAY).define(ERRORS_LOG_INCLUDE_MESSAGES_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, ERRORS_LOG_INCLUDE_MESSAGES_DOC, ERROR_GROUP, ++orderInErrorGroup, ConfigDef.Width.SHORT, ERRORS_LOG_INCLUDE_MESSAGES_DISPLAY);
    }

    public ConnectorConfig(Plugins plugins) {
        this(plugins, new HashMap<String, String>());
    }

    public ConnectorConfig(Plugins plugins, Map<String, String> props) {
        this(plugins, ConnectorConfig.configDef(), props);
    }

    public ConnectorConfig(Plugins plugins, ConfigDef configDef, Map<String, String> props) {
        super(configDef, props);
        this.enrichedConfig = new EnrichedConnectorConfig(ConnectorConfig.enrich(plugins, configDef, props, true), props);
    }

    public Object get(String key) {
        return this.enrichedConfig.get(key);
    }

    public long errorRetryTimeout() {
        return this.getLong(ERRORS_RETRY_TIMEOUT_CONFIG);
    }

    public long errorMaxDelayInMillis() {
        return this.getLong(ERRORS_RETRY_MAX_DELAY_CONFIG);
    }

    public ToleranceType errorToleranceType() {
        String tolerance = this.getString(ERRORS_TOLERANCE_CONFIG);
        for (ToleranceType type : ToleranceType.values()) {
            if (!type.name().equalsIgnoreCase(tolerance)) continue;
            return type;
        }
        return ERRORS_TOLERANCE_DEFAULT;
    }

    public boolean enableErrorLog() {
        return this.getBoolean(ERRORS_LOG_ENABLE_CONFIG);
    }

    public boolean includeRecordDetailsInErrorLog() {
        return this.getBoolean(ERRORS_LOG_INCLUDE_MESSAGES_CONFIG);
    }

    public <R extends ConnectRecord<R>> List<Transformation<R>> transformations() {
        List transformAliases = this.getList(TRANSFORMS_CONFIG);
        ArrayList<Transformation<R>> transformations = new ArrayList<Transformation<R>>(transformAliases.size());
        for (String alias : transformAliases) {
            String prefix = "transforms." + alias + ".";
            try {
                Transformation transformation = this.getClass(prefix + "type").asSubclass(Transformation.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                transformation.configure(this.originalsWithPrefix(prefix));
                transformations.add(transformation);
            }
            catch (Exception e) {
                throw new ConnectException((Throwable)e);
            }
        }
        return transformations;
    }

    public static ConfigDef enrich(Plugins plugins, ConfigDef baseConfigDef, Map<String, String> props, boolean requireFullConfig) {
        Object transformAliases = ConfigDef.parseType((String)TRANSFORMS_CONFIG, (Object)props.get(TRANSFORMS_CONFIG), (ConfigDef.Type)ConfigDef.Type.LIST);
        if (!(transformAliases instanceof List)) {
            return baseConfigDef;
        }
        ConfigDef newDef = new ConfigDef(baseConfigDef);
        LinkedHashSet uniqueTransformAliases = new LinkedHashSet((List)transformAliases);
        for (Object o : uniqueTransformAliases) {
            ConfigDef transformationConfigDef;
            if (!(o instanceof String)) {
                throw new ConfigException("Item in transforms property is not of type String");
            }
            String alias = (String)o;
            String prefix = "transforms." + alias + ".";
            String group = "Transforms: " + alias;
            int orderInGroup = 0;
            final String transformationTypeConfig = prefix + "type";
            ConfigDef.Validator typeValidator = new ConfigDef.Validator(){

                public void ensureValid(String name, Object value) {
                    ConnectorConfig.getConfigDefFromTransformation(transformationTypeConfig, (Class)value);
                }
            };
            newDef.define(transformationTypeConfig, ConfigDef.Type.CLASS, ConfigDef.NO_DEFAULT_VALUE, typeValidator, ConfigDef.Importance.HIGH, "Class for the '" + alias + "' transformation.", group, orderInGroup++, ConfigDef.Width.LONG, "Transformation type for " + alias, Collections.emptyList(), (ConfigDef.Recommender)new TransformationClassRecommender(plugins));
            try {
                String className = props.get(transformationTypeConfig);
                Class cls = (Class)ConfigDef.parseType((String)transformationTypeConfig, (Object)className, (ConfigDef.Type)ConfigDef.Type.CLASS);
                transformationConfigDef = ConnectorConfig.getConfigDefFromTransformation(transformationTypeConfig, cls);
            }
            catch (ConfigException e) {
                if (!requireFullConfig) continue;
                throw e;
            }
            newDef.embed(prefix, group, orderInGroup, transformationConfigDef);
        }
        return newDef;
    }

    static ConfigDef getConfigDefFromTransformation(String key, Class<?> transformationCls) {
        Transformation transformation;
        if (transformationCls == null || !Transformation.class.isAssignableFrom(transformationCls)) {
            throw new ConfigException(key, (Object)String.valueOf(transformationCls), "Not a Transformation");
        }
        if (Modifier.isAbstract(transformationCls.getModifiers())) {
            String childClassNames = Stream.of(transformationCls.getClasses()).filter(transformationCls::isAssignableFrom).filter(c -> !Modifier.isAbstract(c.getModifiers())).filter(c -> Modifier.isPublic(c.getModifiers())).map(Class::getName).collect(Collectors.joining(", "));
            String message = childClassNames.trim().isEmpty() ? "Transformation is abstract and cannot be created." : "Transformation is abstract and cannot be created. Did you mean " + childClassNames + "?";
            throw new ConfigException(key, (Object)String.valueOf(transformationCls), message);
        }
        try {
            transformation = transformationCls.asSubclass(Transformation.class).newInstance();
        }
        catch (Exception e) {
            ConfigException exception = new ConfigException(key, (Object)String.valueOf(transformationCls), "Error getting config definition from Transformation: " + e.getMessage());
            exception.initCause((Throwable)e);
            throw exception;
        }
        ConfigDef configDef = transformation.config();
        if (null == configDef) {
            throw new ConnectException(String.format("%s.config() must return a ConfigDef that is not null.", transformationCls.getName()));
        }
        return configDef;
    }

    static final class TransformationClassRecommender
    implements ConfigDef.Recommender {
        private final Plugins plugins;

        TransformationClassRecommender(Plugins plugins) {
            this.plugins = plugins;
        }

        public List<Object> validValues(String name, Map<String, Object> parsedConfig) {
            ArrayList<Class<Transformation>> transformationPlugins = new ArrayList<Class<Transformation>>();
            for (PluginDesc<Transformation> plugin : this.plugins.transformations()) {
                transformationPlugins.add(plugin.pluginClass());
            }
            return Collections.unmodifiableList(transformationPlugins);
        }

        public boolean visible(String name, Map<String, Object> parsedConfig) {
            return true;
        }
    }

    private static class EnrichedConnectorConfig
    extends AbstractConfig {
        EnrichedConnectorConfig(ConfigDef configDef, Map<String, String> props) {
            super(configDef, props);
        }

        public Object get(String key) {
            return super.get(key);
        }
    }
}

