/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.runtime.ConnectorConfig;
import org.apache.kafka.connect.runtime.TopicCreationConfig;
import org.apache.kafka.connect.runtime.isolation.Plugins;

public class SourceConnectorConfig
extends ConnectorConfig {
    protected static final String TOPIC_CREATION_GROUP = "Topic Creation";
    public static final String TOPIC_CREATION_PREFIX = "topic.creation.";
    public static final String TOPIC_CREATION_GROUPS_CONFIG = "topic.creation.groups";
    private static final String TOPIC_CREATION_GROUPS_DOC = "Groups of configurations for topics created by source connectors";
    private static final String TOPIC_CREATION_GROUPS_DISPLAY = "Topic Creation Groups";
    private static final ConfigDef CONFIG = SourceConnectorConfig.configDef();
    private final EnrichedSourceConnectorConfig enrichedSourceConfig;

    public static ConfigDef configDef() {
        int orderInGroup = 0;
        return new ConfigDef(ConnectorConfig.configDef()).define(TOPIC_CREATION_GROUPS_CONFIG, ConfigDef.Type.LIST, Collections.emptyList(), (ConfigDef.Validator)ConfigDef.CompositeValidator.of((ConfigDef.Validator[])new ConfigDef.Validator[]{new ConfigDef.NonNullValidator(), ConfigDef.LambdaValidator.with((name, value) -> {
            List groupAliases = (List)value;
            if (groupAliases.size() > new HashSet(groupAliases).size()) {
                throw new ConfigException(name, value, "Duplicate alias provided.");
            }
        }, () -> "unique topic creation groups")}), ConfigDef.Importance.LOW, TOPIC_CREATION_GROUPS_DOC, TOPIC_CREATION_GROUP, ++orderInGroup, ConfigDef.Width.LONG, TOPIC_CREATION_GROUPS_DISPLAY);
    }

    public static ConfigDef embedDefaultGroup(ConfigDef baseConfigDef) {
        String defaultGroup = "default";
        ConfigDef newDefaultDef = new ConfigDef(baseConfigDef);
        newDefaultDef.embed("topic.creation.default.", defaultGroup, 0, TopicCreationConfig.defaultGroupConfigDef());
        return newDefaultDef;
    }

    public static ConfigDef enrich(ConfigDef baseConfigDef, Map<String, String> props, AbstractConfig defaultGroupConfig) {
        ArrayList topicCreationGroups = new ArrayList();
        Object aliases = ConfigDef.parseType((String)TOPIC_CREATION_GROUPS_CONFIG, (Object)props.get(TOPIC_CREATION_GROUPS_CONFIG), (ConfigDef.Type)ConfigDef.Type.LIST);
        if (aliases instanceof List) {
            topicCreationGroups.addAll((List)aliases);
        }
        ConfigDef newDef = new ConfigDef(baseConfigDef);
        String defaultGroupPrefix = "topic.creation.default.";
        short defaultGroupReplicationFactor = defaultGroupConfig.getShort(defaultGroupPrefix + "replication.factor");
        int defaultGroupPartitions = defaultGroupConfig.getInt(defaultGroupPrefix + "partitions");
        topicCreationGroups.stream().distinct().forEach(group -> {
            if (!(group instanceof String)) {
                throw new ConfigException("Item in topic.creation.groups property is not of type String");
            }
            String alias = (String)group;
            String prefix = TOPIC_CREATION_PREFIX + alias + ".";
            String configGroup = "Topic Creation: " + alias;
            newDef.embed(prefix, configGroup, 0, TopicCreationConfig.configDef(configGroup, defaultGroupReplicationFactor, defaultGroupPartitions));
        });
        return newDef;
    }

    public SourceConnectorConfig(Plugins plugins, Map<String, String> props, boolean createTopics) {
        super(plugins, CONFIG, props);
        if (createTopics && props.entrySet().stream().anyMatch(e -> ((String)e.getKey()).startsWith(TOPIC_CREATION_PREFIX))) {
            ConfigDef defaultConfigDef = SourceConnectorConfig.embedDefaultGroup(CONFIG);
            AbstractConfig defaultGroup = new AbstractConfig(defaultConfigDef, props, false);
            HashMap<String, String> propsWithoutRegexForDefaultGroup = new HashMap<String, String>(props);
            propsWithoutRegexForDefaultGroup.entrySet().removeIf(e -> ((String)e.getKey()).equals("topic.creation.default.include") || ((String)e.getKey()).equals("topic.creation.default.exclude"));
            this.enrichedSourceConfig = new EnrichedSourceConnectorConfig(plugins, SourceConnectorConfig.enrich(defaultConfigDef, props, defaultGroup), propsWithoutRegexForDefaultGroup);
        } else {
            this.enrichedSourceConfig = null;
        }
    }

    @Override
    public Object get(String key) {
        return this.enrichedSourceConfig != null ? this.enrichedSourceConfig.get(key) : super.get(key);
    }

    public boolean usesTopicCreation() {
        return this.enrichedSourceConfig != null;
    }

    public List<String> topicCreationInclude(String group) {
        return this.getList(TOPIC_CREATION_PREFIX + group + '.' + "include");
    }

    public List<String> topicCreationExclude(String group) {
        return this.getList(TOPIC_CREATION_PREFIX + group + '.' + "exclude");
    }

    public Short topicCreationReplicationFactor(String group) {
        return this.getShort(TOPIC_CREATION_PREFIX + group + '.' + "replication.factor");
    }

    public Integer topicCreationPartitions(String group) {
        return this.getInt(TOPIC_CREATION_PREFIX + group + '.' + "partitions");
    }

    public Map<String, Object> topicCreationOtherConfigs(String group) {
        if (this.enrichedSourceConfig == null) {
            return Collections.emptyMap();
        }
        return this.enrichedSourceConfig.originalsWithPrefix(TOPIC_CREATION_PREFIX + group + '.').entrySet().stream().filter(e -> {
            String key = (String)e.getKey();
            return !"include".equals(key) && !"exclude".equals(key) && !"replication.factor".equals(key) && !"partitions".equals(key);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static void main(String[] args) {
        System.out.println(CONFIG.toHtml(4, config -> "sourceconnectorconfigs_" + config));
    }

    private static class EnrichedSourceConnectorConfig
    extends ConnectorConfig {
        EnrichedSourceConnectorConfig(Plugins plugins, ConfigDef configDef, Map<String, String> props) {
            super(plugins, configDef, props);
        }

        @Override
        public Object get(String key) {
            return super.get(key);
        }
    }
}

