/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.predicates.Predicate;

public class PredicatedTransformation<R extends ConnectRecord<R>>
implements Transformation<R> {
    static final String PREDICATE_CONFIG = "predicate";
    static final String NEGATE_CONFIG = "negate";
    final Predicate<R> predicate;
    final Transformation<R> delegate;
    final boolean negate;

    PredicatedTransformation(Predicate<R> predicate, boolean negate, Transformation<R> delegate) {
        this.predicate = predicate;
        this.negate = negate;
        this.delegate = delegate;
    }

    public void configure(Map<String, ?> configs) {
        throw new ConnectException(PredicatedTransformation.class.getName() + ".configure() should never be called directly.");
    }

    public R apply(R record) {
        if (this.negate ^ this.predicate.test(record)) {
            return (R)this.delegate.apply(record);
        }
        return record;
    }

    public ConfigDef config() {
        throw new ConnectException(PredicatedTransformation.class.getName() + ".config() should never be called directly.");
    }

    public void close() {
        Utils.closeQuietly(this.delegate, (String)"predicated");
        Utils.closeQuietly(this.predicate, (String)PREDICATE_CONFIG);
    }

    public String toString() {
        return "PredicatedTransformation{predicate=" + this.predicate + ", delegate=" + this.delegate + ", negate=" + this.negate + '}';
    }
}

