/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.kafka.message.CodeBuffer;
import org.apache.kafka.message.HeaderGenerator;
import org.apache.kafka.message.MessageGenerator;
import org.apache.kafka.message.MessageSpec;
import org.apache.kafka.message.RequestListenerType;
import org.apache.kafka.message.TypeClassGenerator;
import org.apache.kafka.message.VersionConditional;

public final class ApiMessageTypeGenerator
implements TypeClassGenerator {
    private final HeaderGenerator headerGenerator;
    private final CodeBuffer buffer;
    private final TreeMap<Short, ApiData> apis;
    private final EnumMap<RequestListenerType, List<ApiData>> apisByListener = new EnumMap(RequestListenerType.class);

    public ApiMessageTypeGenerator(String packageName) {
        this.headerGenerator = new HeaderGenerator(packageName);
        this.apis = new TreeMap();
        this.buffer = new CodeBuffer();
    }

    @Override
    public String outputName() {
        return "ApiMessageType.java";
    }

    @Override
    public void registerMessageType(MessageSpec spec) {
        switch (spec.type()) {
            case REQUEST: {
                short apiKey = spec.apiKey().get();
                ApiData data = this.apis.get(apiKey);
                if (!this.apis.containsKey(apiKey)) {
                    data = new ApiData(apiKey);
                    this.apis.put(apiKey, data);
                }
                if (data.requestSpec != null) {
                    throw new RuntimeException("Found more than one request with API key " + spec.apiKey().get());
                }
                data.requestSpec = spec;
                if (spec.listeners() == null) break;
                for (RequestListenerType listener : spec.listeners()) {
                    this.apisByListener.putIfAbsent(listener, new ArrayList());
                    this.apisByListener.get((Object)listener).add(data);
                }
                break;
            }
            case RESPONSE: {
                short apiKey = spec.apiKey().get();
                ApiData data = this.apis.get(apiKey);
                if (!this.apis.containsKey(apiKey)) {
                    data = new ApiData(apiKey);
                    this.apis.put(apiKey, data);
                }
                if (data.responseSpec != null) {
                    throw new RuntimeException("Found more than one response with API key " + spec.apiKey().get());
                }
                data.responseSpec = spec;
                break;
            }
        }
    }

    @Override
    public void generateAndWrite(BufferedWriter writer) throws IOException {
        this.generate();
        this.write(writer);
    }

    private void generate() {
        this.buffer.printf("public enum ApiMessageType {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.generateEnumValues();
        this.buffer.printf("%n", new Object[0]);
        this.generateInstanceVariables();
        this.buffer.printf("%n", new Object[0]);
        this.generateEnumConstructor();
        this.buffer.printf("%n", new Object[0]);
        this.generateFromApiKey();
        this.buffer.printf("%n", new Object[0]);
        this.generateNewApiMessageMethod("request");
        this.buffer.printf("%n", new Object[0]);
        this.generateNewApiMessageMethod("response");
        this.buffer.printf("%n", new Object[0]);
        this.generateAccessor("lowestSupportedVersion", "short");
        this.buffer.printf("%n", new Object[0]);
        this.generateAccessor("highestSupportedVersion", "short");
        this.buffer.printf("%n", new Object[0]);
        this.generateAccessor("listeners", "EnumSet<ListenerType>");
        this.buffer.printf("%n", new Object[0]);
        this.generateAccessor("apiKey", "short");
        this.buffer.printf("%n", new Object[0]);
        this.generateAccessor("requestSchemas", "Schema[]");
        this.buffer.printf("%n", new Object[0]);
        this.generateAccessor("responseSchemas", "Schema[]");
        this.buffer.printf("%n", new Object[0]);
        this.generateToString();
        this.buffer.printf("%n", new Object[0]);
        this.generateHeaderVersion("request");
        this.buffer.printf("%n", new Object[0]);
        this.generateHeaderVersion("response");
        this.buffer.printf("%n", new Object[0]);
        this.generateListenerTypesEnum();
        this.buffer.printf("%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
        this.headerGenerator.generate();
    }

    private String generateListenerTypeEnumSet(Collection<String> values) {
        if (values.isEmpty()) {
            return "EnumSet.noneOf(ListenerType.class)";
        }
        StringBuilder bldr = new StringBuilder("EnumSet.of(");
        Iterator<String> iter = values.iterator();
        while (iter.hasNext()) {
            bldr.append("ListenerType.");
            bldr.append(iter.next());
            if (!iter.hasNext()) continue;
            bldr.append(", ");
        }
        bldr.append(")");
        return bldr.toString();
    }

    private void generateEnumValues() {
        int numProcessed = 0;
        for (Map.Entry<Short, ApiData> entry : this.apis.entrySet()) {
            ApiData apiData = entry.getValue();
            String name = apiData.name();
            Collection<Object> listeners = apiData.requestSpec.listeners() == null ? Collections.emptyList() : (Collection)apiData.requestSpec.listeners().stream().map(Enum::name).collect(Collectors.toList());
            this.buffer.printf("%s(\"%s\", (short) %d, %s, %s, (short) %d, (short) %d, %s)%s%n", MessageGenerator.toSnakeCase(name).toUpperCase(Locale.ROOT), MessageGenerator.capitalizeFirst(name), entry.getKey(), apiData.requestSchema(), apiData.responseSchema(), apiData.requestSpec.struct().versions().lowest(), apiData.requestSpec.struct().versions().highest(), this.generateListenerTypeEnumSet(listeners), ++numProcessed == this.apis.size() ? ";" : ",");
        }
    }

    private void generateInstanceVariables() {
        this.buffer.printf("public final String name;%n", new Object[0]);
        this.buffer.printf("private final short apiKey;%n", new Object[0]);
        this.buffer.printf("private final Schema[] requestSchemas;%n", new Object[0]);
        this.buffer.printf("private final Schema[] responseSchemas;%n", new Object[0]);
        this.buffer.printf("private final short lowestSupportedVersion;%n", new Object[0]);
        this.buffer.printf("private final short highestSupportedVersion;%n", new Object[0]);
        this.buffer.printf("private final EnumSet<ListenerType> listeners;%n", new Object[0]);
        this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.Schema");
        this.headerGenerator.addImport("java.util.EnumSet");
    }

    private void generateEnumConstructor() {
        this.buffer.printf("ApiMessageType(String name, short apiKey, Schema[] requestSchemas, Schema[] responseSchemas, short lowestSupportedVersion, short highestSupportedVersion, EnumSet<ListenerType> listeners) {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.buffer.printf("this.name = name;%n", new Object[0]);
        this.buffer.printf("this.apiKey = apiKey;%n", new Object[0]);
        this.buffer.printf("this.requestSchemas = requestSchemas;%n", new Object[0]);
        this.buffer.printf("this.responseSchemas = responseSchemas;%n", new Object[0]);
        this.buffer.printf("this.lowestSupportedVersion = lowestSupportedVersion;%n", new Object[0]);
        this.buffer.printf("this.highestSupportedVersion = highestSupportedVersion;%n", new Object[0]);
        this.buffer.printf("this.listeners = listeners;%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateFromApiKey() {
        this.buffer.printf("public static ApiMessageType fromApiKey(short apiKey) {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.buffer.printf("switch (apiKey) {%n", new Object[0]);
        this.buffer.incrementIndent();
        for (Map.Entry<Short, ApiData> entry : this.apis.entrySet()) {
            ApiData apiData = entry.getValue();
            String name = apiData.name();
            this.buffer.printf("case %d:%n", entry.getKey());
            this.buffer.incrementIndent();
            this.buffer.printf("return %s;%n", MessageGenerator.toSnakeCase(name).toUpperCase(Locale.ROOT));
            this.buffer.decrementIndent();
        }
        this.buffer.printf("default:%n", new Object[0]);
        this.buffer.incrementIndent();
        this.headerGenerator.addImport("org.apache.kafka.common.errors.UnsupportedVersionException");
        this.buffer.printf("throw new UnsupportedVersionException(\"Unsupported API key \" + apiKey);%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateNewApiMessageMethod(String type) {
        this.headerGenerator.addImport("org.apache.kafka.common.protocol.ApiMessage");
        this.buffer.printf("public ApiMessage new%s() {%n", MessageGenerator.capitalizeFirst(type));
        this.buffer.incrementIndent();
        this.buffer.printf("switch (apiKey) {%n", new Object[0]);
        this.buffer.incrementIndent();
        for (Map.Entry<Short, ApiData> entry : this.apis.entrySet()) {
            this.buffer.printf("case %d:%n", entry.getKey());
            this.buffer.incrementIndent();
            this.buffer.printf("return new %s%sData();%n", entry.getValue().name(), MessageGenerator.capitalizeFirst(type));
            this.buffer.decrementIndent();
        }
        this.buffer.printf("default:%n", new Object[0]);
        this.buffer.incrementIndent();
        this.headerGenerator.addImport("org.apache.kafka.common.errors.UnsupportedVersionException");
        this.buffer.printf("throw new UnsupportedVersionException(\"Unsupported %s API key \" + apiKey);%n", type);
        this.buffer.decrementIndent();
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateAccessor(String name, String type) {
        this.buffer.printf("public %s %s() {%n", type, name);
        this.buffer.incrementIndent();
        this.buffer.printf("return this.%s;%n", name);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateToString() {
        this.buffer.printf("@Override%n", new Object[0]);
        this.buffer.printf("public String toString() {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.buffer.printf("return this.name();%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateHeaderVersion(String type) {
        this.buffer.printf("public short %sHeaderVersion(short _version) {%n", type);
        this.buffer.incrementIndent();
        this.buffer.printf("switch (apiKey) {%n", new Object[0]);
        this.buffer.incrementIndent();
        for (Map.Entry<Short, ApiData> entry : this.apis.entrySet()) {
            short apiKey = entry.getKey();
            ApiData apiData = entry.getValue();
            String name = apiData.name();
            this.buffer.printf("case %d: // %s%n", apiKey, MessageGenerator.capitalizeFirst(name));
            this.buffer.incrementIndent();
            if (type.equals("response") && apiKey == 18) {
                this.buffer.printf("// ApiVersionsResponse always includes a v0 header.%n", new Object[0]);
                this.buffer.printf("// See KIP-511 for details.%n", new Object[0]);
                this.buffer.printf("return (short) 0;%n", new Object[0]);
                this.buffer.decrementIndent();
                continue;
            }
            if (type.equals("request") && apiKey == 7) {
                this.buffer.printf("// Version 0 of ControlledShutdownRequest has a non-standard request header%n", new Object[0]);
                this.buffer.printf("// which does not include clientId.  Version 1 of ControlledShutdownRequest%n", new Object[0]);
                this.buffer.printf("// and later use the standard request header.%n", new Object[0]);
                this.buffer.printf("if (_version == 0) {%n", new Object[0]);
                this.buffer.incrementIndent();
                this.buffer.printf("return (short) 0;%n", new Object[0]);
                this.buffer.decrementIndent();
                this.buffer.printf("}%n", new Object[0]);
            }
            ApiData data = entry.getValue();
            MessageSpec spec = null;
            if (type.equals("request")) {
                spec = data.requestSpec;
            } else if (type.equals("response")) {
                spec = data.responseSpec;
            } else {
                throw new RuntimeException("Invalid type " + type + " for generateHeaderVersion");
            }
            if (spec == null) {
                throw new RuntimeException("failed to find " + type + " for API key " + apiKey);
            }
            VersionConditional.forVersions(spec.flexibleVersions(), spec.validVersions()).ifMember(__ -> {
                if (type.equals("request")) {
                    this.buffer.printf("return (short) 2;%n", new Object[0]);
                } else {
                    this.buffer.printf("return (short) 1;%n", new Object[0]);
                }
            }).ifNotMember(__ -> {
                if (type.equals("request")) {
                    this.buffer.printf("return (short) 1;%n", new Object[0]);
                } else {
                    this.buffer.printf("return (short) 0;%n", new Object[0]);
                }
            }).generate(this.buffer);
            this.buffer.decrementIndent();
        }
        this.buffer.printf("default:%n", new Object[0]);
        this.buffer.incrementIndent();
        this.headerGenerator.addImport("org.apache.kafka.common.errors.UnsupportedVersionException");
        this.buffer.printf("throw new UnsupportedVersionException(\"Unsupported API key \" + apiKey);%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateListenerTypesEnum() {
        this.buffer.printf("public enum ListenerType {%n", new Object[0]);
        this.buffer.incrementIndent();
        Iterator listenerIter = Arrays.stream(RequestListenerType.values()).iterator();
        while (listenerIter.hasNext()) {
            RequestListenerType scope = (RequestListenerType)((Object)listenerIter.next());
            this.buffer.printf("%s%s%n", scope.name(), listenerIter.hasNext() ? "," : ";");
        }
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void write(BufferedWriter writer) throws IOException {
        this.headerGenerator.buffer().write(writer);
        this.buffer.write(writer);
    }

    private static final class ApiData {
        short apiKey;
        MessageSpec requestSpec;
        MessageSpec responseSpec;

        ApiData(short apiKey) {
            this.apiKey = apiKey;
        }

        String name() {
            if (this.requestSpec != null) {
                return MessageGenerator.stripSuffix(this.requestSpec.name(), "Request");
            }
            if (this.responseSpec != null) {
                return MessageGenerator.stripSuffix(this.responseSpec.name(), "Response");
            }
            throw new RuntimeException("Neither requestSpec nor responseSpec is defined for API key " + this.apiKey);
        }

        String requestSchema() {
            if (this.requestSpec == null) {
                return "null";
            }
            return String.format("%sData.SCHEMAS", this.requestSpec.name());
        }

        String responseSchema() {
            if (this.responseSpec == null) {
                return "null";
            }
            return String.format("%sData.SCHEMAS", this.responseSpec.name());
        }
    }
}

