/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import org.apache.kafka.message.ClauseGenerator;
import org.apache.kafka.message.CodeBuffer;
import org.apache.kafka.message.Versions;

public final class VersionConditional {
    private final Versions containingVersions;
    private final Versions possibleVersions;
    private ClauseGenerator ifMember = null;
    private ClauseGenerator ifNotMember = null;
    private boolean alwaysEmitBlockScope = false;
    private boolean allowMembershipCheckAlwaysFalse = true;

    static VersionConditional forVersions(Versions containingVersions, Versions possibleVersions) {
        return new VersionConditional(containingVersions, possibleVersions);
    }

    private VersionConditional(Versions containingVersions, Versions possibleVersions) {
        this.containingVersions = containingVersions;
        this.possibleVersions = possibleVersions;
    }

    VersionConditional ifMember(ClauseGenerator ifMember) {
        this.ifMember = ifMember;
        return this;
    }

    VersionConditional ifNotMember(ClauseGenerator ifNotMember) {
        this.ifNotMember = ifNotMember;
        return this;
    }

    VersionConditional alwaysEmitBlockScope(boolean alwaysEmitBlockScope) {
        this.alwaysEmitBlockScope = alwaysEmitBlockScope;
        return this;
    }

    VersionConditional allowMembershipCheckAlwaysFalse(boolean allowMembershipCheckAlwaysFalse) {
        this.allowMembershipCheckAlwaysFalse = allowMembershipCheckAlwaysFalse;
        return this;
    }

    private void generateFullRangeCheck(Versions ifVersions, Versions ifNotVersions, CodeBuffer buffer) {
        if (this.ifMember != null) {
            buffer.printf("if ((_version >= %d) && (_version <= %d)) {%n", this.containingVersions.lowest(), this.containingVersions.highest());
            buffer.incrementIndent();
            this.ifMember.generate(ifVersions);
            buffer.decrementIndent();
            if (this.ifNotMember != null) {
                buffer.printf("} else {%n", new Object[0]);
                buffer.incrementIndent();
                this.ifNotMember.generate(ifNotVersions);
                buffer.decrementIndent();
            }
            buffer.printf("}%n", new Object[0]);
        } else if (this.ifNotMember != null) {
            buffer.printf("if ((_version < %d) || (_version > %d)) {%n", this.containingVersions.lowest(), this.containingVersions.highest());
            buffer.incrementIndent();
            this.ifNotMember.generate(ifNotVersions);
            buffer.decrementIndent();
            buffer.printf("}%n", new Object[0]);
        }
    }

    private void generateLowerRangeCheck(Versions ifVersions, Versions ifNotVersions, CodeBuffer buffer) {
        if (this.ifMember != null) {
            buffer.printf("if (_version >= %d) {%n", this.containingVersions.lowest());
            buffer.incrementIndent();
            this.ifMember.generate(ifVersions);
            buffer.decrementIndent();
            if (this.ifNotMember != null) {
                buffer.printf("} else {%n", new Object[0]);
                buffer.incrementIndent();
                this.ifNotMember.generate(ifNotVersions);
                buffer.decrementIndent();
            }
            buffer.printf("}%n", new Object[0]);
        } else if (this.ifNotMember != null) {
            buffer.printf("if (_version < %d) {%n", this.containingVersions.lowest());
            buffer.incrementIndent();
            this.ifNotMember.generate(ifNotVersions);
            buffer.decrementIndent();
            buffer.printf("}%n", new Object[0]);
        }
    }

    private void generateUpperRangeCheck(Versions ifVersions, Versions ifNotVersions, CodeBuffer buffer) {
        if (this.ifMember != null) {
            buffer.printf("if (_version <= %d) {%n", this.containingVersions.highest());
            buffer.incrementIndent();
            this.ifMember.generate(ifVersions);
            buffer.decrementIndent();
            if (this.ifNotMember != null) {
                buffer.printf("} else {%n", new Object[0]);
                buffer.incrementIndent();
                this.ifNotMember.generate(ifNotVersions);
                buffer.decrementIndent();
            }
            buffer.printf("}%n", new Object[0]);
        } else if (this.ifNotMember != null) {
            buffer.printf("if (_version > %d) {%n", this.containingVersions.highest());
            buffer.incrementIndent();
            this.ifNotMember.generate(ifNotVersions);
            buffer.decrementIndent();
            buffer.printf("}%n", new Object[0]);
        }
    }

    private void generateAlwaysTrueCheck(Versions ifVersions, CodeBuffer buffer) {
        if (this.ifMember != null) {
            if (this.alwaysEmitBlockScope) {
                buffer.printf("{%n", new Object[0]);
                buffer.incrementIndent();
            }
            this.ifMember.generate(ifVersions);
            if (this.alwaysEmitBlockScope) {
                buffer.decrementIndent();
                buffer.printf("}%n", new Object[0]);
            }
        }
    }

    private void generateAlwaysFalseCheck(Versions ifNotVersions, CodeBuffer buffer) {
        if (!this.allowMembershipCheckAlwaysFalse) {
            throw new RuntimeException("Version ranges " + this.containingVersions + " and " + this.possibleVersions + " have no versions in common.");
        }
        if (this.ifNotMember != null) {
            if (this.alwaysEmitBlockScope) {
                buffer.printf("{%n", new Object[0]);
                buffer.incrementIndent();
            }
            this.ifNotMember.generate(ifNotVersions);
            if (this.alwaysEmitBlockScope) {
                buffer.decrementIndent();
                buffer.printf("}%n", new Object[0]);
            }
        }
    }

    void generate(CodeBuffer buffer) {
        Versions ifVersions = this.possibleVersions.intersect(this.containingVersions);
        Versions ifNotVersions = this.possibleVersions.subtract(this.containingVersions);
        if (ifNotVersions == null) {
            ifNotVersions = this.possibleVersions;
        }
        if (this.possibleVersions.lowest() < this.containingVersions.lowest()) {
            if (this.possibleVersions.highest() > this.containingVersions.highest()) {
                this.generateFullRangeCheck(ifVersions, ifNotVersions, buffer);
            } else if (this.possibleVersions.highest() >= this.containingVersions.lowest()) {
                this.generateLowerRangeCheck(ifVersions, ifNotVersions, buffer);
            } else {
                this.generateAlwaysFalseCheck(ifNotVersions, buffer);
            }
        } else if (this.possibleVersions.highest() >= this.containingVersions.lowest() && this.possibleVersions.lowest() <= this.containingVersions.highest()) {
            if (this.possibleVersions.highest() > this.containingVersions.highest()) {
                this.generateUpperRangeCheck(ifVersions, ifNotVersions, buffer);
            } else {
                this.generateAlwaysTrueCheck(ifVersions, buffer);
            }
        } else {
            this.generateAlwaysFalseCheck(ifNotVersions, buffer);
        }
    }
}

