/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;

public class MockClient
implements KafkaClient {
    public static final RequestMatcher ALWAYS_TRUE = new RequestMatcher(){

        @Override
        public boolean matches(ClientRequest request) {
            return true;
        }
    };
    private final Time time;
    private int correlation = 0;
    private Node node = null;
    private final Set<String> ready = new HashSet<String>();
    private final Map<Node, Long> blackedOut = new HashMap<Node, Long>();
    private final Queue<ClientRequest> requests = new ArrayDeque<ClientRequest>();
    private final Queue<ClientResponse> responses = new ArrayDeque<ClientResponse>();
    private final Queue<FutureResponse> futureResponses = new ArrayDeque<FutureResponse>();

    public MockClient(Time time) {
        this.time = time;
    }

    public boolean isReady(Node node, long now) {
        return this.ready.contains(node.idString());
    }

    public boolean ready(Node node, long now) {
        if (this.isBlackedOut(node)) {
            return false;
        }
        this.ready.add(node.idString());
        return true;
    }

    public long connectionDelay(Node node, long now) {
        return 0L;
    }

    public void blackout(Node node, long duration) {
        this.blackedOut.put(node, this.time.milliseconds() + duration);
    }

    private boolean isBlackedOut(Node node) {
        if (this.blackedOut.containsKey(node)) {
            long expiration = this.blackedOut.get(node);
            if (this.time.milliseconds() > expiration) {
                this.blackedOut.remove(node);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean connectionFailed(Node node) {
        return this.isBlackedOut(node);
    }

    public void disconnect(String node) {
        long now = this.time.milliseconds();
        Iterator iter = this.requests.iterator();
        while (iter.hasNext()) {
            ClientRequest request = (ClientRequest)iter.next();
            if (!request.request().destination().equals(node)) continue;
            this.responses.add(new ClientResponse(request, now, true, null));
            iter.remove();
        }
        this.ready.remove(node);
    }

    public void send(ClientRequest request, long now) {
        Iterator iterator = this.futureResponses.iterator();
        while (iterator.hasNext()) {
            FutureResponse futureResp = (FutureResponse)iterator.next();
            if (futureResp.node != null && !request.request().destination().equals(futureResp.node.idString())) continue;
            if (!futureResp.requestMatcher.matches(request)) {
                throw new IllegalStateException("Next in line response did not match expected request");
            }
            ClientResponse resp = new ClientResponse(request, this.time.milliseconds(), futureResp.disconnected, futureResp.responseBody);
            this.responses.add(resp);
            iterator.remove();
            return;
        }
        request.setSendTimeMs(now);
        this.requests.add(request);
    }

    public List<ClientResponse> poll(long timeoutMs, long now) {
        ArrayList<ClientResponse> copy = new ArrayList<ClientResponse>(this.responses);
        while (!this.responses.isEmpty()) {
            ClientResponse response = this.responses.poll();
            if (!response.request().hasCallback()) continue;
            response.request().callback().onComplete(response);
        }
        return copy;
    }

    public Queue<ClientRequest> requests() {
        return this.requests;
    }

    public void respond(Struct body) {
        this.respond(body, false);
    }

    public void respond(Struct body, boolean disconnected) {
        ClientRequest request = this.requests.remove();
        this.responses.add(new ClientResponse(request, this.time.milliseconds(), disconnected, body));
    }

    public void respondFrom(Struct body, Node node) {
        this.respondFrom(body, node, false);
    }

    public void respondFrom(Struct body, Node node, boolean disconnected) {
        Iterator iterator = this.requests.iterator();
        while (iterator.hasNext()) {
            ClientRequest request = (ClientRequest)iterator.next();
            if (!request.request().destination().equals(node.idString())) continue;
            iterator.remove();
            this.responses.add(new ClientResponse(request, this.time.milliseconds(), disconnected, body));
            return;
        }
        throw new IllegalArgumentException("No requests available to node " + node);
    }

    public void prepareResponse(Struct body) {
        this.prepareResponse(ALWAYS_TRUE, body, false);
    }

    public void prepareResponseFrom(Struct body, Node node) {
        this.prepareResponseFrom(ALWAYS_TRUE, body, node, false);
    }

    public void prepareResponse(RequestMatcher matcher, Struct body) {
        this.prepareResponse(matcher, body, false);
    }

    public void prepareResponseFrom(RequestMatcher matcher, Struct body, Node node) {
        this.prepareResponseFrom(matcher, body, node, false);
    }

    public void prepareResponse(Struct body, boolean disconnected) {
        this.prepareResponse(ALWAYS_TRUE, body, disconnected);
    }

    public void prepareResponseFrom(Struct body, Node node, boolean disconnected) {
        this.prepareResponseFrom(ALWAYS_TRUE, body, node, disconnected);
    }

    public void prepareResponse(RequestMatcher matcher, Struct body, boolean disconnected) {
        this.prepareResponseFrom(matcher, body, null, disconnected);
    }

    public void prepareResponseFrom(RequestMatcher matcher, Struct body, Node node, boolean disconnected) {
        this.futureResponses.add(new FutureResponse(body, disconnected, matcher, node));
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public int inFlightRequestCount() {
        return this.requests.size();
    }

    public int inFlightRequestCount(String node) {
        return this.requests.size();
    }

    public RequestHeader nextRequestHeader(ApiKeys key) {
        return new RequestHeader(key.id, "mock", this.correlation++);
    }

    public RequestHeader nextRequestHeader(ApiKeys key, short version) {
        return new RequestHeader(key.id, version, "mock", this.correlation++);
    }

    public void wakeup() {
    }

    public void close() {
    }

    public void close(String node) {
        this.ready.remove(node);
    }

    public Node leastLoadedNode(long now) {
        return this.node;
    }

    public static interface RequestMatcher {
        public boolean matches(ClientRequest var1);
    }

    private class FutureResponse {
        public final Struct responseBody;
        public final boolean disconnected;
        public final RequestMatcher requestMatcher;
        public Node node;

        public FutureResponse(Struct responseBody, boolean disconnected, RequestMatcher requestMatcher, Node node) {
            this.responseBody = responseBody;
            this.disconnected = disconnected;
            this.requestMatcher = requestMatcher;
            this.node = node;
        }
    }
}

