/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.test.MockSerializer;
import org.junit.Assert;
import org.junit.Test;

public class MockProducerTest {
    private String topic = "topic";

    @Test
    public void testAutoCompleteMock() throws Exception {
        MockProducer producer = new MockProducer(true, (Serializer)new MockSerializer(), (Serializer)new MockSerializer());
        ProducerRecord record = new ProducerRecord(this.topic, (Object)"key".getBytes(), (Object)"value".getBytes());
        Future metadata = producer.send(record);
        Assert.assertTrue((String)"Send should be immediately complete", (boolean)metadata.isDone());
        Assert.assertFalse((String)"Send should be successful", (boolean)this.isError(metadata));
        Assert.assertEquals((String)"Offset should be 0", (long)0L, (long)((RecordMetadata)metadata.get()).offset());
        Assert.assertEquals((Object)this.topic, (Object)((RecordMetadata)metadata.get()).topic());
        Assert.assertEquals((String)"We should have the record in our history", Collections.singletonList(record), (Object)producer.history());
        producer.clear();
        Assert.assertEquals((String)"Clear should erase our history", (long)0L, (long)producer.history().size());
    }

    @Test
    public void testPartitioner() throws Exception {
        PartitionInfo partitionInfo0 = new PartitionInfo(this.topic, 0, null, null, null);
        PartitionInfo partitionInfo1 = new PartitionInfo(this.topic, 1, null, null, null);
        Cluster cluster = new Cluster(new ArrayList(0), Arrays.asList(partitionInfo0, partitionInfo1), Collections.emptySet());
        MockProducer producer = new MockProducer(cluster, true, (Partitioner)new DefaultPartitioner(), (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        ProducerRecord record = new ProducerRecord(this.topic, (Object)"key", (Object)"value");
        Future metadata = producer.send(record);
        Assert.assertEquals((String)"Partition should be correct", (long)1L, (long)((RecordMetadata)metadata.get()).partition());
        producer.clear();
        Assert.assertEquals((String)"Clear should erase our history", (long)0L, (long)producer.history().size());
    }

    @Test
    public void testManualCompletion() throws Exception {
        MockProducer producer = new MockProducer(false, (Serializer)new MockSerializer(), (Serializer)new MockSerializer());
        ProducerRecord record1 = new ProducerRecord(this.topic, (Object)"key1".getBytes(), (Object)"value1".getBytes());
        ProducerRecord record2 = new ProducerRecord(this.topic, (Object)"key2".getBytes(), (Object)"value2".getBytes());
        Future md1 = producer.send(record1);
        Assert.assertFalse((String)"Send shouldn't have completed", (boolean)md1.isDone());
        Future md2 = producer.send(record2);
        Assert.assertFalse((String)"Send shouldn't have completed", (boolean)md2.isDone());
        Assert.assertTrue((String)"Complete the first request", (boolean)producer.completeNext());
        Assert.assertFalse((String)"Requst should be successful", (boolean)this.isError(md1));
        Assert.assertFalse((String)"Second request still incomplete", (boolean)md2.isDone());
        IllegalArgumentException e = new IllegalArgumentException("blah");
        Assert.assertTrue((String)"Complete the second request with an error", (boolean)producer.errorNext((RuntimeException)e));
        try {
            md2.get();
            Assert.fail((String)"Expected error to be thrown");
        }
        catch (ExecutionException err) {
            Assert.assertEquals((Object)e, (Object)err.getCause());
        }
        Assert.assertFalse((String)"No more requests to complete", (boolean)producer.completeNext());
        Future md3 = producer.send(record1);
        Future md4 = producer.send(record2);
        Assert.assertTrue((String)"Requests should not be completed.", (!md3.isDone() && !md4.isDone() ? 1 : 0) != 0);
        producer.flush();
        Assert.assertTrue((String)"Requests should be completed.", (md3.isDone() && md4.isDone() ? 1 : 0) != 0);
    }

    private boolean isError(Future<?> future) {
        try {
            future.get();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }
}

