/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.TrustManagerFactory;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.Mode;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v1CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;

public class TestSslUtils {
    public static X509Certificate generateCertificate(String dn, KeyPair pair, int days, String algorithm) throws CertificateException {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(algorithm);
            AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
            AsymmetricKeyParameter privateKeyAsymKeyParam = PrivateKeyFactory.createKey((byte[])pair.getPrivate().getEncoded());
            SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)pair.getPublic().getEncoded());
            ContentSigner sigGen = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(privateKeyAsymKeyParam);
            X500Name name = new X500Name(dn);
            Date from = new Date();
            Date to = new Date(from.getTime() + (long)days * 86400000L);
            BigInteger sn = new BigInteger(64, new SecureRandom());
            X509v1CertificateBuilder v1CertGen = new X509v1CertificateBuilder(name, sn, from, to, name, subPubKeyInfo);
            X509CertificateHolder certificateHolder = v1CertGen.build(sigGen);
            return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateHolder);
        }
        catch (CertificateException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CertificateException(e);
        }
    }

    public static KeyPair generateKeyPair(String algorithm) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(algorithm);
        keyGen.initialize(1024);
        return keyGen.genKeyPair();
    }

    private static KeyStore createEmptyKeyStore() throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        return ks;
    }

    private static void saveKeyStore(KeyStore ks, String filename, Password password) throws GeneralSecurityException, IOException {
        try (FileOutputStream out = new FileOutputStream(filename);){
            ks.store(out, password.value().toCharArray());
        }
    }

    public static void createKeyStore(String filename, Password password, String alias, Key privateKey, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore ks = TestSslUtils.createEmptyKeyStore();
        ks.setKeyEntry(alias, privateKey, password.value().toCharArray(), new Certificate[]{cert});
        TestSslUtils.saveKeyStore(ks, filename, password);
    }

    public static void createKeyStore(String filename, Password password, Password keyPassword, String alias, Key privateKey, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore ks = TestSslUtils.createEmptyKeyStore();
        ks.setKeyEntry(alias, privateKey, keyPassword.value().toCharArray(), new Certificate[]{cert});
        TestSslUtils.saveKeyStore(ks, filename, password);
    }

    public static <T extends Certificate> void createTrustStore(String filename, Password password, Map<String, T> certs) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        try {
            FileInputStream in = new FileInputStream(filename);
            ks.load(in, password.value().toCharArray());
            in.close();
        }
        catch (EOFException e) {
            ks = TestSslUtils.createEmptyKeyStore();
        }
        for (Map.Entry<String, T> cert : certs.entrySet()) {
            ks.setCertificateEntry(cert.getKey(), (Certificate)cert.getValue());
        }
        TestSslUtils.saveKeyStore(ks, filename, password);
    }

    private static Map<String, Object> createSslConfig(Mode mode, File keyStoreFile, Password password, Password keyPassword, File trustStoreFile, Password trustStorePassword) {
        HashMap<String, Object> sslConfigs = new HashMap<String, Object>();
        sslConfigs.put("ssl.protocol", "TLSv1.2");
        if (mode == Mode.SERVER || mode == Mode.CLIENT && keyStoreFile != null) {
            sslConfigs.put("ssl.keystore.location", keyStoreFile.getPath());
            sslConfigs.put("ssl.keystore.type", "JKS");
            sslConfigs.put("ssl.keymanager.algorithm", TrustManagerFactory.getDefaultAlgorithm());
            sslConfigs.put("ssl.keystore.password", password);
            sslConfigs.put("ssl.key.password", keyPassword);
        }
        sslConfigs.put("ssl.truststore.location", trustStoreFile.getPath());
        sslConfigs.put("ssl.truststore.password", trustStorePassword);
        sslConfigs.put("ssl.truststore.type", "JKS");
        sslConfigs.put("ssl.trustmanager.algorithm", TrustManagerFactory.getDefaultAlgorithm());
        ArrayList<String> enabledProtocols = new ArrayList<String>();
        enabledProtocols.add("TLSv1.2");
        sslConfigs.put("ssl.enabled.protocols", enabledProtocols);
        return sslConfigs;
    }

    public static Map<String, Object> createSslConfig(boolean useClientCert, boolean trustStore, Mode mode, File trustStoreFile, String certAlias) throws IOException, GeneralSecurityException {
        return TestSslUtils.createSslConfig(useClientCert, trustStore, mode, trustStoreFile, certAlias, "localhost");
    }

    public static Map<String, Object> createSslConfig(boolean useClientCert, boolean trustStore, Mode mode, File trustStoreFile, String certAlias, String host) throws IOException, GeneralSecurityException {
        HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
        File keyStoreFile = null;
        Password password = mode == Mode.SERVER ? new Password("ServerPassword") : new Password("ClientPassword");
        Password trustStorePassword = new Password("TrustStorePassword");
        if (mode == Mode.CLIENT && useClientCert) {
            keyStoreFile = File.createTempFile("clientKS", ".jks");
            KeyPair cKP = TestSslUtils.generateKeyPair("RSA");
            X509Certificate cCert = TestSslUtils.generateCertificate("CN=" + host + ", O=A client", cKP, 30, "SHA1withRSA");
            TestSslUtils.createKeyStore(keyStoreFile.getPath(), password, "client", cKP.getPrivate(), cCert);
            certs.put(certAlias, cCert);
            keyStoreFile.deleteOnExit();
        } else if (mode == Mode.SERVER) {
            keyStoreFile = File.createTempFile("serverKS", ".jks");
            KeyPair sKP = TestSslUtils.generateKeyPair("RSA");
            X509Certificate sCert = TestSslUtils.generateCertificate("CN=" + host + ", O=A server", sKP, 30, "SHA1withRSA");
            TestSslUtils.createKeyStore(keyStoreFile.getPath(), password, password, "server", sKP.getPrivate(), sCert);
            certs.put(certAlias, sCert);
            keyStoreFile.deleteOnExit();
        }
        if (trustStore) {
            TestSslUtils.createTrustStore(trustStoreFile.getPath(), trustStorePassword, certs);
            trustStoreFile.deleteOnExit();
        }
        return TestSslUtils.createSslConfig(mode, keyStoreFile, password, password, trustStoreFile, trustStorePassword);
    }
}

