/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.consumer.internals.RequestFuture;
import org.apache.kafka.clients.consumer.internals.RequestFutureAdapter;
import org.apache.kafka.clients.consumer.internals.RequestFutureListener;
import org.junit.Assert;
import org.junit.Test;

public class RequestFutureTest {
    @Test
    public void testBasicCompletion() {
        RequestFuture future = new RequestFuture();
        String value = "foo";
        future.complete((Object)value);
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertEquals((Object)value, (Object)future.value());
    }

    @Test
    public void testBasicFailure() {
        RequestFuture future = new RequestFuture();
        RuntimeException exception = new RuntimeException();
        future.raise(exception);
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertEquals((Object)exception, (Object)future.exception());
    }

    @Test
    public void testVoidFuture() {
        RequestFuture future = new RequestFuture();
        future.complete(null);
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertNull((Object)future.value());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRuntimeExceptionInComplete() {
        RequestFuture future = new RequestFuture();
        future.complete((Object)new RuntimeException());
    }

    @Test(expected=IllegalStateException.class)
    public void invokeCompleteAfterAlreadyComplete() {
        RequestFuture future = new RequestFuture();
        future.complete(null);
        future.complete(null);
    }

    @Test(expected=IllegalStateException.class)
    public void invokeCompleteAfterAlreadyFailed() {
        RequestFuture future = new RequestFuture();
        future.raise(new RuntimeException());
        future.complete(null);
    }

    @Test(expected=IllegalStateException.class)
    public void invokeRaiseAfterAlreadyFailed() {
        RequestFuture future = new RequestFuture();
        future.raise(new RuntimeException());
        future.raise(new RuntimeException());
    }

    @Test(expected=IllegalStateException.class)
    public void invokeRaiseAfterAlreadyCompleted() {
        RequestFuture future = new RequestFuture();
        future.complete(null);
        future.raise(new RuntimeException());
    }

    @Test(expected=IllegalStateException.class)
    public void invokeExceptionAfterSuccess() {
        RequestFuture future = new RequestFuture();
        future.complete(null);
        future.exception();
    }

    @Test(expected=IllegalStateException.class)
    public void invokeValueAfterFailure() {
        RequestFuture future = new RequestFuture();
        future.raise(new RuntimeException());
        future.value();
    }

    @Test
    public void listenerInvokedIfAddedBeforeFutureCompletion() {
        RequestFuture future = new RequestFuture();
        MockRequestFutureListener listener = new MockRequestFutureListener();
        future.addListener(listener);
        future.complete(null);
        RequestFutureTest.assertOnSuccessInvoked(listener);
    }

    @Test
    public void listenerInvokedIfAddedBeforeFutureFailure() {
        RequestFuture future = new RequestFuture();
        MockRequestFutureListener listener = new MockRequestFutureListener();
        future.addListener(listener);
        future.raise(new RuntimeException());
        RequestFutureTest.assertOnFailureInvoked(listener);
    }

    @Test
    public void listenerInvokedIfAddedAfterFutureCompletion() {
        RequestFuture future = new RequestFuture();
        future.complete(null);
        MockRequestFutureListener listener = new MockRequestFutureListener();
        future.addListener(listener);
        RequestFutureTest.assertOnSuccessInvoked(listener);
    }

    @Test
    public void listenerInvokedIfAddedAfterFutureFailure() {
        RequestFuture future = new RequestFuture();
        future.raise(new RuntimeException());
        MockRequestFutureListener listener = new MockRequestFutureListener();
        future.addListener(listener);
        RequestFutureTest.assertOnFailureInvoked(listener);
    }

    @Test
    public void listenersInvokedIfAddedBeforeAndAfterFailure() {
        RequestFuture future = new RequestFuture();
        MockRequestFutureListener beforeListener = new MockRequestFutureListener();
        future.addListener(beforeListener);
        future.raise(new RuntimeException());
        MockRequestFutureListener afterListener = new MockRequestFutureListener();
        future.addListener(afterListener);
        RequestFutureTest.assertOnFailureInvoked(beforeListener);
        RequestFutureTest.assertOnFailureInvoked(afterListener);
    }

    @Test
    public void listenersInvokedIfAddedBeforeAndAfterCompletion() {
        RequestFuture future = new RequestFuture();
        MockRequestFutureListener beforeListener = new MockRequestFutureListener();
        future.addListener(beforeListener);
        future.complete(null);
        MockRequestFutureListener afterListener = new MockRequestFutureListener();
        future.addListener(afterListener);
        RequestFutureTest.assertOnSuccessInvoked(beforeListener);
        RequestFutureTest.assertOnSuccessInvoked(afterListener);
    }

    @Test
    public void testComposeSuccessCase() {
        RequestFuture future = new RequestFuture();
        RequestFuture composed = future.compose((RequestFutureAdapter)new RequestFutureAdapter<String, Integer>(){

            public void onSuccess(String value, RequestFuture<Integer> future) {
                future.complete((Object)value.length());
            }
        });
        future.complete((Object)"hello");
        Assert.assertTrue((boolean)composed.isDone());
        Assert.assertTrue((boolean)composed.succeeded());
        Assert.assertEquals((long)5L, (long)((Integer)composed.value()).intValue());
    }

    @Test
    public void testComposeFailureCase() {
        RequestFuture future = new RequestFuture();
        RequestFuture composed = future.compose((RequestFutureAdapter)new RequestFutureAdapter<String, Integer>(){

            public void onSuccess(String value, RequestFuture<Integer> future) {
                future.complete((Object)value.length());
            }
        });
        RuntimeException e = new RuntimeException();
        future.raise(e);
        Assert.assertTrue((boolean)composed.isDone());
        Assert.assertTrue((boolean)composed.failed());
        Assert.assertEquals((Object)e, (Object)composed.exception());
    }

    private static <T> void assertOnSuccessInvoked(MockRequestFutureListener<T> listener) {
        Assert.assertEquals((long)1L, (long)((MockRequestFutureListener)listener).numOnSuccessCalls.get());
        Assert.assertEquals((long)0L, (long)((MockRequestFutureListener)listener).numOnFailureCalls.get());
    }

    private static <T> void assertOnFailureInvoked(MockRequestFutureListener<T> listener) {
        Assert.assertEquals((long)0L, (long)((MockRequestFutureListener)listener).numOnSuccessCalls.get());
        Assert.assertEquals((long)1L, (long)((MockRequestFutureListener)listener).numOnFailureCalls.get());
    }

    private static class MockRequestFutureListener<T>
    implements RequestFutureListener<T> {
        private final AtomicInteger numOnSuccessCalls = new AtomicInteger(0);
        private final AtomicInteger numOnFailureCalls = new AtomicInteger(0);

        private MockRequestFutureListener() {
        }

        public void onSuccess(T value) {
            this.numOnSuccessCalls.incrementAndGet();
        }

        public void onFailure(RuntimeException e) {
            this.numOnFailureCalls.incrementAndGet();
        }
    }
}

