/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.nio.ByteBuffer;
import org.apache.kafka.common.utils.Crc32;
import org.junit.Assert;
import org.junit.Test;

public class CrcTest {
    @Test
    public void testUpdate() {
        byte[] bytes = "Any String you want".getBytes();
        int len = bytes.length;
        Crc32 crc1 = new Crc32();
        Crc32 crc2 = new Crc32();
        Crc32 crc3 = new Crc32();
        crc1.update(bytes, 0, len);
        for (int i = 0; i < len; ++i) {
            crc2.update((int)bytes[i]);
        }
        crc3.update(bytes, 0, len / 2);
        crc3.update(bytes, len / 2, len - len / 2);
        Assert.assertEquals((String)"Crc values should be the same", (long)crc1.getValue(), (long)crc2.getValue());
        Assert.assertEquals((String)"Crc values should be the same", (long)crc1.getValue(), (long)crc3.getValue());
    }

    @Test
    public void testUpdateInt() {
        int value = 1000;
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(1000);
        Crc32 crc1 = new Crc32();
        Crc32 crc2 = new Crc32();
        crc1.updateInt(1000);
        crc2.update(buffer.array(), buffer.arrayOffset(), 4);
        Assert.assertEquals((String)"Crc values should be the same", (long)crc1.getValue(), (long)crc2.getValue());
    }
}

