/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.serialization.Deserializer;

public class MockDeserializer
implements ClusterResourceListener,
Deserializer<byte[]> {
    public static final AtomicInteger INIT_COUNT = new AtomicInteger(0);
    public static final AtomicInteger CLOSE_COUNT = new AtomicInteger(0);
    public static final AtomicReference<ClusterResource> CLUSTER_META = new AtomicReference();
    public static final ClusterResource NO_CLUSTER_ID = new ClusterResource("no_cluster_id");
    public static final AtomicReference<ClusterResource> CLUSTER_ID_BEFORE_DESERIALIZE = new AtomicReference<ClusterResource>(NO_CLUSTER_ID);

    public MockDeserializer() {
        INIT_COUNT.incrementAndGet();
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public byte[] deserialize(String topic, byte[] data) {
        CLUSTER_ID_BEFORE_DESERIALIZE.compareAndSet(NO_CLUSTER_ID, CLUSTER_META.get());
        return data;
    }

    public void close() {
        CLOSE_COUNT.incrementAndGet();
    }

    public void onUpdate(ClusterResource clusterResource) {
        CLUSTER_META.set(clusterResource);
    }
}

