/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;

public class MockClient
implements KafkaClient {
    public static final RequestMatcher ALWAYS_TRUE = new RequestMatcher(){

        @Override
        public boolean matches(AbstractRequest body) {
            return true;
        }
    };
    private final Time time;
    private final Metadata metadata;
    private int correlation = 0;
    private Node node = null;
    private final Set<String> ready = new HashSet<String>();
    private final Map<Node, Long> blackedOut = new HashMap<Node, Long>();
    private final Queue<ClientRequest> requests = new ConcurrentLinkedDeque<ClientRequest>();
    private final Queue<ClientResponse> responses = new ConcurrentLinkedDeque<ClientResponse>();
    private final Queue<FutureResponse> futureResponses = new ArrayDeque<FutureResponse>();
    private final Queue<Cluster> metadataUpdates = new ArrayDeque<Cluster>();
    private volatile NodeApiVersions nodeApiVersions = NodeApiVersions.create();

    public MockClient(Time time) {
        this.time = time;
        this.metadata = null;
    }

    public MockClient(Time time, Metadata metadata) {
        this.time = time;
        this.metadata = metadata;
    }

    public boolean isReady(Node node, long now) {
        return this.ready.contains(node.idString());
    }

    public boolean ready(Node node, long now) {
        if (this.isBlackedOut(node)) {
            return false;
        }
        this.ready.add(node.idString());
        return true;
    }

    public long connectionDelay(Node node, long now) {
        return 0L;
    }

    public void blackout(Node node, long duration) {
        this.blackedOut.put(node, this.time.milliseconds() + duration);
    }

    private boolean isBlackedOut(Node node) {
        if (this.blackedOut.containsKey(node)) {
            long expiration = this.blackedOut.get(node);
            if (this.time.milliseconds() > expiration) {
                this.blackedOut.remove(node);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean connectionFailed(Node node) {
        return this.isBlackedOut(node);
    }

    public void disconnect(String node) {
        long now = this.time.milliseconds();
        Iterator iter = this.requests.iterator();
        while (iter.hasNext()) {
            ClientRequest request = (ClientRequest)iter.next();
            if (!request.destination().equals(node)) continue;
            this.responses.add(new ClientResponse(request.makeHeader(), request.callback(), request.destination(), request.createdTimeMs(), now, true, null, null));
            iter.remove();
        }
        this.ready.remove(node);
    }

    public void send(ClientRequest request, long now) {
        Iterator iterator = this.futureResponses.iterator();
        while (iterator.hasNext()) {
            FutureResponse futureResp = (FutureResponse)iterator.next();
            if (futureResp.node != null && !request.destination().equals(futureResp.node.idString())) continue;
            request.requestBuilder().setVersion(this.nodeApiVersions.usableVersion(request.requestBuilder().apiKey()));
            AbstractRequest abstractRequest = request.requestBuilder().build();
            if (!futureResp.requestMatcher.matches(abstractRequest)) {
                throw new IllegalStateException("Next in line response did not match expected request");
            }
            ClientResponse resp = new ClientResponse(request.makeHeader(), request.callback(), request.destination(), request.createdTimeMs(), this.time.milliseconds(), futureResp.disconnected, null, futureResp.responseBody);
            this.responses.add(resp);
            iterator.remove();
            return;
        }
        this.requests.add(request);
    }

    public List<ClientResponse> poll(long timeoutMs, long now) {
        ArrayList<ClientResponse> copy = new ArrayList<ClientResponse>(this.responses);
        if (this.metadata != null && this.metadata.updateRequested()) {
            Cluster cluster = this.metadataUpdates.poll();
            if (cluster == null) {
                this.metadata.update(this.metadata.fetch(), this.time.milliseconds());
            } else {
                this.metadata.update(cluster, this.time.milliseconds());
            }
        }
        while (!this.responses.isEmpty()) {
            ClientResponse response = this.responses.poll();
            response.onComplete();
        }
        return copy;
    }

    public Queue<ClientRequest> requests() {
        return this.requests;
    }

    public void respond(AbstractResponse response) {
        this.respond(response, false);
    }

    public void respond(AbstractResponse response, boolean disconnected) {
        ClientRequest request = this.requests.remove();
        this.responses.add(new ClientResponse(request.makeHeader(), request.callback(), request.destination(), request.createdTimeMs(), this.time.milliseconds(), disconnected, null, response));
    }

    public void respondFrom(AbstractResponse response, Node node) {
        this.respondFrom(response, node, false);
    }

    public void respondFrom(AbstractResponse response, Node node, boolean disconnected) {
        Iterator iterator = this.requests.iterator();
        while (iterator.hasNext()) {
            ClientRequest request = (ClientRequest)iterator.next();
            if (!request.destination().equals(node.idString())) continue;
            iterator.remove();
            this.responses.add(new ClientResponse(request.makeHeader(), request.callback(), request.destination(), request.createdTimeMs(), this.time.milliseconds(), disconnected, null, response));
            return;
        }
        throw new IllegalArgumentException("No requests available to node " + node);
    }

    public void prepareResponse(AbstractResponse response) {
        this.prepareResponse(ALWAYS_TRUE, response, false);
    }

    public void prepareResponseFrom(AbstractResponse response, Node node) {
        this.prepareResponseFrom(ALWAYS_TRUE, response, node, false);
    }

    public void prepareResponse(RequestMatcher matcher, AbstractResponse response) {
        this.prepareResponse(matcher, response, false);
    }

    public void prepareResponseFrom(RequestMatcher matcher, AbstractResponse response, Node node) {
        this.prepareResponseFrom(matcher, response, node, false);
    }

    public void prepareResponse(AbstractResponse response, boolean disconnected) {
        this.prepareResponse(ALWAYS_TRUE, response, disconnected);
    }

    public void prepareResponseFrom(AbstractResponse response, Node node, boolean disconnected) {
        this.prepareResponseFrom(ALWAYS_TRUE, response, node, disconnected);
    }

    public void prepareResponse(RequestMatcher matcher, AbstractResponse response, boolean disconnected) {
        this.prepareResponseFrom(matcher, response, null, disconnected);
    }

    public void prepareResponseFrom(RequestMatcher matcher, AbstractResponse response, Node node, boolean disconnected) {
        this.futureResponses.add(new FutureResponse(response, disconnected, matcher, node));
    }

    public void waitForRequests(final int minRequests, long maxWaitMs) throws InterruptedException {
        TestUtils.waitForCondition(new TestCondition(){

            @Override
            public boolean conditionMet() {
                return MockClient.this.requests.size() >= minRequests;
            }
        }, maxWaitMs, "Expected requests have not been sent");
    }

    public void reset() {
        this.ready.clear();
        this.blackedOut.clear();
        this.requests.clear();
        this.responses.clear();
        this.futureResponses.clear();
        this.metadataUpdates.clear();
    }

    public void prepareMetadataUpdate(Cluster cluster) {
        this.metadataUpdates.add(cluster);
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public int inFlightRequestCount() {
        return this.requests.size();
    }

    public int inFlightRequestCount(String node) {
        return this.requests.size();
    }

    public ClientRequest newClientRequest(String nodeId, AbstractRequest.Builder<?> requestBuilder, long createdTimeMs, boolean expectResponse) {
        return this.newClientRequest(nodeId, requestBuilder, createdTimeMs, expectResponse, null);
    }

    public ClientRequest newClientRequest(String nodeId, AbstractRequest.Builder<?> requestBuilder, long createdTimeMs, boolean expectResponse, RequestCompletionHandler callback) {
        return new ClientRequest(nodeId, requestBuilder, 0, "mockClientId", createdTimeMs, expectResponse, callback);
    }

    public void wakeup() {
    }

    public void close() {
    }

    public void close(String node) {
        this.ready.remove(node);
    }

    public Node leastLoadedNode(long now) {
        return this.node;
    }

    public void setNodeApiVersions(NodeApiVersions nodeApiVersions) {
        this.nodeApiVersions = nodeApiVersions;
    }

    public static interface RequestMatcher {
        public boolean matches(AbstractRequest var1);
    }

    private class FutureResponse {
        public final AbstractResponse responseBody;
        public final boolean disconnected;
        public final RequestMatcher requestMatcher;
        public Node node;

        public FutureResponse(AbstractResponse responseBody, boolean disconnected, RequestMatcher requestMatcher, Node node) {
            this.responseBody = responseBody;
            this.disconnected = disconnected;
            this.requestMatcher = requestMatcher;
            this.node = node;
        }
    }
}

