/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.test.TestSslUtils;

public class CertStores {
    private final Map<String, Object> sslConfig;

    public CertStores(boolean server, String host) throws Exception {
        String name = server ? "server" : "client";
        Mode mode = server ? Mode.SERVER : Mode.CLIENT;
        File truststoreFile = File.createTempFile(name + "TS", ".jks");
        this.sslConfig = TestSslUtils.createSslConfig(!server, true, mode, truststoreFile, name, host);
        if (server) {
            this.sslConfig.put("principal.builder.class", Class.forName("org.apache.kafka.common.security.auth.DefaultPrincipalBuilder"));
        }
    }

    public Map<String, Object> getTrustingConfig(CertStores truststoreConfig) {
        HashMap<String, Object> config = new HashMap<String, Object>(this.sslConfig);
        config.put("ssl.truststore.location", truststoreConfig.sslConfig.get("ssl.truststore.location"));
        config.put("ssl.truststore.password", truststoreConfig.sslConfig.get("ssl.truststore.password"));
        config.put("ssl.truststore.type", truststoreConfig.sslConfig.get("ssl.truststore.type"));
        return config;
    }

    public Map<String, Object> getUntrustingConfig() {
        return this.sslConfig;
    }
}

