/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MemoryRecordsTest {
    private CompressionType compression;
    private byte magic;
    private long firstOffset;

    public MemoryRecordsTest(byte magic, long firstOffset, CompressionType compression) {
        this.magic = magic;
        this.compression = compression;
        this.firstOffset = firstOffset;
    }

    @Test
    public void testIterator() {
        MemoryRecordsBuilder builder1 = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)this.firstOffset);
        MemoryRecordsBuilder builder2 = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)this.firstOffset);
        List<Record> list = Arrays.asList(Record.create((byte)this.magic, (long)1L, (byte[])"a".getBytes(), (byte[])"1".getBytes()), Record.create((byte)this.magic, (long)2L, (byte[])"b".getBytes(), (byte[])"2".getBytes()), Record.create((byte)this.magic, (long)3L, (byte[])"c".getBytes(), (byte[])"3".getBytes()), Record.create((byte)this.magic, (long)4L, null, (byte[])"4".getBytes()), Record.create((byte)this.magic, (long)5L, (byte[])"e".getBytes(), null), Record.create((byte)this.magic, (long)6L, null, null));
        for (int i = 0; i < list.size(); ++i) {
            Record r = list.get(i);
            builder1.append(r);
            builder2.append((long)(i + 1), Utils.toNullableArray((ByteBuffer)r.key()), Utils.toNullableArray((ByteBuffer)r.value()));
        }
        MemoryRecords recs1 = builder1.build();
        MemoryRecords recs2 = builder2.build();
        for (int iteration = 0; iteration < 2; ++iteration) {
            for (MemoryRecords recs : Arrays.asList(recs1, recs2)) {
                Iterator iter = recs.deepEntries().iterator();
                for (int i = 0; i < list.size(); ++i) {
                    Assert.assertTrue((boolean)iter.hasNext());
                    LogEntry entry = (LogEntry)iter.next();
                    Assert.assertEquals((long)(this.firstOffset + (long)i), (long)entry.offset());
                    Assert.assertEquals((Object)list.get(i), (Object)entry.record());
                    entry.record().ensureValid();
                }
                Assert.assertFalse((boolean)iter.hasNext());
            }
        }
    }

    @Test
    public void testHasRoomForMethod() {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME);
        builder.append(Record.create((byte)this.magic, (long)0L, (byte[])"a".getBytes(), (byte[])"1".getBytes()));
        Assert.assertTrue((boolean)builder.hasRoomFor("b".getBytes(), "2".getBytes()));
        builder.close();
        Assert.assertFalse((boolean)builder.hasRoomFor("b".getBytes(), "2".getBytes()));
    }

    @Test
    public void testFilterTo() {
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, null, "a".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
        builder.append(11L, "1".getBytes(), "b".getBytes());
        builder.append(12L, null, "c".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)3L);
        builder.append(13L, null, "d".getBytes());
        builder.append(20L, "4".getBytes(), "e".getBytes());
        builder.append(15L, "5".getBytes(), "f".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.CREATE_TIME, (long)6L);
        builder.append(16L, "6".getBytes(), "g".getBytes());
        builder.close();
        buffer.flip();
        ByteBuffer filtered = ByteBuffer.allocate(2048);
        MemoryRecords.FilterResult result = MemoryRecords.readableRecords((ByteBuffer)buffer).filterTo((MemoryRecords.LogEntryFilter)new RetainNonNullKeysFilter(), filtered);
        filtered.flip();
        Assert.assertEquals((long)7L, (long)result.messagesRead);
        Assert.assertEquals((long)4L, (long)result.messagesRetained);
        Assert.assertEquals((long)buffer.limit(), (long)result.bytesRead);
        Assert.assertEquals((long)filtered.limit(), (long)result.bytesRetained);
        if (this.magic > 0) {
            Assert.assertEquals((long)20L, (long)result.maxTimestamp);
            if (this.compression == CompressionType.NONE) {
                Assert.assertEquals((long)4L, (long)result.shallowOffsetOfMaxTimestamp);
            } else {
                Assert.assertEquals((long)5L, (long)result.shallowOffsetOfMaxTimestamp);
            }
        }
        MemoryRecords filteredRecords = MemoryRecords.readableRecords((ByteBuffer)filtered);
        List shallowEntries = TestUtils.toList(filteredRecords.shallowEntries());
        List<Long> expectedOffsets = this.compression == CompressionType.NONE ? Arrays.asList(1L, 4L, 5L, 6L) : Arrays.asList(1L, 5L, 6L);
        Assert.assertEquals((long)expectedOffsets.size(), (long)shallowEntries.size());
        for (int i = 0; i < expectedOffsets.size(); ++i) {
            LogEntry shallowEntry = (LogEntry)shallowEntries.get(i);
            Assert.assertEquals((long)expectedOffsets.get(i), (long)shallowEntry.offset());
            Assert.assertEquals((long)this.magic, (long)shallowEntry.record().magic());
            Assert.assertEquals((Object)this.compression, (Object)shallowEntry.record().compressionType());
            Assert.assertEquals((Object)(this.magic == 0 ? TimestampType.NO_TIMESTAMP_TYPE : TimestampType.CREATE_TIME), (Object)shallowEntry.record().timestampType());
        }
        List deepEntries = TestUtils.toList(filteredRecords.deepEntries());
        Assert.assertEquals((long)4L, (long)deepEntries.size());
        LogEntry first = (LogEntry)deepEntries.get(0);
        Assert.assertEquals((long)1L, (long)first.offset());
        Assert.assertEquals((Object)Record.create((byte)this.magic, (long)11L, (byte[])"1".getBytes(), (byte[])"b".getBytes()), (Object)first.record());
        LogEntry second = (LogEntry)deepEntries.get(1);
        Assert.assertEquals((long)4L, (long)second.offset());
        Assert.assertEquals((Object)Record.create((byte)this.magic, (long)20L, (byte[])"4".getBytes(), (byte[])"e".getBytes()), (Object)second.record());
        LogEntry third = (LogEntry)deepEntries.get(2);
        Assert.assertEquals((long)5L, (long)third.offset());
        Assert.assertEquals((Object)Record.create((byte)this.magic, (long)15L, (byte[])"5".getBytes(), (byte[])"f".getBytes()), (Object)third.record());
        LogEntry fourth = (LogEntry)deepEntries.get(3);
        Assert.assertEquals((long)6L, (long)fourth.offset());
        Assert.assertEquals((Object)Record.create((byte)this.magic, (long)16L, (byte[])"6".getBytes(), (byte[])"g".getBytes()), (Object)fourth.record());
    }

    @Test
    public void testFilterToPreservesLogAppendTime() {
        long logAppendTime = System.currentTimeMillis();
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)0L, (long)logAppendTime);
        builder.append(10L, null, "a".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)1L, (long)logAppendTime);
        builder.append(11L, "1".getBytes(), "b".getBytes());
        builder.append(12L, null, "c".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)this.magic, (CompressionType)this.compression, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)3L, (long)logAppendTime);
        builder.append(13L, null, "d".getBytes());
        builder.append(14L, "4".getBytes(), "e".getBytes());
        builder.append(15L, "5".getBytes(), "f".getBytes());
        builder.close();
        buffer.flip();
        ByteBuffer filtered = ByteBuffer.allocate(2048);
        MemoryRecords.readableRecords((ByteBuffer)buffer).filterTo((MemoryRecords.LogEntryFilter)new RetainNonNullKeysFilter(), filtered);
        filtered.flip();
        MemoryRecords filteredRecords = MemoryRecords.readableRecords((ByteBuffer)filtered);
        List<LogEntry> shallowEntries = TestUtils.toList(filteredRecords.shallowEntries());
        Assert.assertEquals((long)(this.compression == CompressionType.NONE ? 3L : 2L), (long)shallowEntries.size());
        for (LogEntry shallowEntry : shallowEntries) {
            Assert.assertEquals((Object)this.compression, (Object)shallowEntry.record().compressionType());
            if (this.magic <= 0) continue;
            Assert.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)shallowEntry.record().timestampType());
            Assert.assertEquals((long)logAppendTime, (long)shallowEntry.record().timestamp());
        }
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (long firstOffset : Arrays.asList(0L, 57L)) {
            for (byte magic : Arrays.asList((byte)0, (byte)1)) {
                for (CompressionType type : CompressionType.values()) {
                    values.add(new Object[]{magic, firstOffset, type});
                }
            }
        }
        return values;
    }

    private static class RetainNonNullKeysFilter
    implements MemoryRecords.LogEntryFilter {
        private RetainNonNullKeysFilter() {
        }

        public boolean shouldRetain(LogEntry entry) {
            return entry.record().hasKey();
        }
    }
}

