/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.MockKafkaAdminClientEnv;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.resource.Resource;
import org.apache.kafka.common.resource.ResourceFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAdminClientTest {
    private static final Logger log = LoggerFactory.getLogger(KafkaAdminClientTest.class);
    @Rule
    public final Timeout globalTimeout = Timeout.millis((long)120000L);
    private static final AclBinding ACL1 = new AclBinding(new Resource(ResourceType.TOPIC, "mytopic3"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
    private static final AclBinding ACL2 = new AclBinding(new Resource(ResourceType.TOPIC, "mytopic4"), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.DENY));
    private static final AclBindingFilter FILTER1 = new AclBindingFilter(new ResourceFilter(ResourceType.ANY, null), new AccessControlEntryFilter("User:ANONYMOUS", null, AclOperation.ANY, AclPermissionType.ANY));
    private static final AclBindingFilter FILTER2 = new AclBindingFilter(new ResourceFilter(ResourceType.ANY, null), new AccessControlEntryFilter("User:bob", null, AclOperation.ANY, AclPermissionType.ANY));

    @Test
    public void testGetOrCreateListValue() {
        HashMap map = new HashMap();
        List fooList = KafkaAdminClient.getOrCreateListValue(map, (Object)"foo");
        Assert.assertNotNull((Object)fooList);
        fooList.add("a");
        fooList.add("b");
        List fooList2 = KafkaAdminClient.getOrCreateListValue(map, (Object)"foo");
        Assert.assertEquals((Object)fooList, (Object)fooList2);
        Assert.assertTrue((boolean)fooList2.contains("a"));
        Assert.assertTrue((boolean)fooList2.contains("b"));
        List barList = KafkaAdminClient.getOrCreateListValue(map, (Object)"bar");
        Assert.assertNotNull((Object)barList);
        Assert.assertTrue((boolean)barList.isEmpty());
    }

    @Test
    public void testCalcTimeoutMsRemainingAsInt() {
        Assert.assertEquals((long)0L, (long)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)1000L, (long)1000L));
        Assert.assertEquals((long)100L, (long)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)1000L, (long)1100L));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)0L, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)Long.MAX_VALUE, (long)0L));
    }

    @Test
    public void testPrettyPrintException() {
        Assert.assertEquals((Object)"Null exception.", (Object)KafkaAdminClient.prettyPrintException(null));
        Assert.assertEquals((Object)"TimeoutException", (Object)KafkaAdminClient.prettyPrintException((Throwable)new TimeoutException()));
        Assert.assertEquals((Object)"TimeoutException: The foobar timed out.", (Object)KafkaAdminClient.prettyPrintException((Throwable)new TimeoutException("The foobar timed out.")));
    }

    private static Map<String, Object> newStrMap(String ... vals) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bootstrap.servers", "localhost:8121");
        map.put("request.timeout.ms", "1000");
        if (vals.length % 2 != 0) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < vals.length; i += 2) {
            map.put(vals[i], vals[i + 1]);
        }
        return map;
    }

    private static AdminClientConfig newConfMap(String ... vals) {
        return new AdminClientConfig(KafkaAdminClientTest.newStrMap(vals));
    }

    @Test
    public void testGenerateClientId() {
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < 10; ++i) {
            String id = KafkaAdminClient.generateClientId((AdminClientConfig)KafkaAdminClientTest.newConfMap("client.id", ""));
            Assert.assertTrue((String)("Got duplicate id " + id), (!ids.contains(id) ? 1 : 0) != 0);
            ids.add(id);
        }
        Assert.assertEquals((Object)"myCustomId", (Object)KafkaAdminClient.generateClientId((AdminClientConfig)KafkaAdminClientTest.newConfMap("client.id", "myCustomId")));
    }

    private static MockKafkaAdminClientEnv mockClientEnv(String ... configVals) {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        nodes.put(0, new Node(0, "localhost", 8121));
        nodes.put(1, new Node(1, "localhost", 8122));
        nodes.put(2, new Node(2, "localhost", 8123));
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        return new MockKafkaAdminClientEnv(cluster, configVals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseAdminClient() throws Exception {
        block5: {
            MockKafkaAdminClientEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);
            Throwable throwable = null;
            if (env == null) break block5;
            if (throwable != null) {
                try {
                    env.close();
                }
                catch (Throwable x2) {
                    throwable.addSuppressed(x2);
                }
            } else {
                env.close();
            }
        }
    }

    private static void assertFutureError(Future<?> future, Class<? extends Throwable> exceptionClass) throws InterruptedException {
        try {
            future.get();
            Assert.fail((String)("Expected a " + exceptionClass.getSimpleName() + " exception, but got success."));
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            Assert.assertEquals((String)("Expected a " + exceptionClass.getSimpleName() + " exception, but got " + cause.getClass().getSimpleName()), exceptionClass, cause.getClass());
        }
    }

    @Test
    public void testTimeoutWithoutMetadata() throws Exception {
        try (MockKafkaAdminClientEnv env = KafkaAdminClientTest.mockClientEnv("request.timeout.ms", "10");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().setNode(new Node(0, "localhost", 8121));
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateTopicsResponse(Collections.singletonMap("myTopic", new ApiError(Errors.NONE, ""))));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(1000))).all();
            KafkaAdminClientTest.assertFutureError(future, TimeoutException.class);
        }
    }

    @Test
    public void testCreateTopics() throws Exception {
        try (MockKafkaAdminClientEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareMetadataUpdate(env.cluster(), Collections.emptySet());
            env.kafkaClient().setNode(env.cluster().controller());
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateTopicsResponse(Collections.singletonMap("myTopic", new ApiError(Errors.NONE, ""))));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testDescribeAcls() throws Exception {
        try (MockKafkaAdminClientEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareMetadataUpdate(env.cluster(), Collections.emptySet());
            env.kafkaClient().setNode(env.cluster().controller());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeAclsResponse(0, ApiError.NONE, Arrays.asList(ACL1, ACL2)));
            KafkaAdminClientTest.assertCollectionIs((Collection)env.adminClient().describeAcls(FILTER1).values().get(), ACL1, ACL2);
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeAclsResponse(0, ApiError.NONE, Collections.emptySet()));
            Assert.assertTrue((boolean)((Collection)env.adminClient().describeAcls(FILTER2).values().get()).isEmpty());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeAclsResponse(0, new ApiError(Errors.SECURITY_DISABLED, "Security is disabled"), Collections.emptySet()));
            KafkaAdminClientTest.assertFutureError(env.adminClient().describeAcls(FILTER2).values(), SecurityDisabledException.class);
        }
    }

    @Test
    public void testCreateAcls() throws Exception {
        try (MockKafkaAdminClientEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareMetadataUpdate(env.cluster(), Collections.emptySet());
            env.kafkaClient().setNode(env.cluster().controller());
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateAclsResponse(0, Arrays.asList(new CreateAclsResponse.AclCreationResponse(ApiError.NONE), new CreateAclsResponse.AclCreationResponse(ApiError.NONE))));
            CreateAclsResult results = env.adminClient().createAcls(Arrays.asList(ACL1, ACL2));
            KafkaAdminClientTest.assertCollectionIs(results.values().keySet(), ACL1, ACL2);
            for (KafkaFuture future : results.values().values()) {
                future.get();
            }
            results.all().get();
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateAclsResponse(0, Arrays.asList(new CreateAclsResponse.AclCreationResponse(new ApiError(Errors.SECURITY_DISABLED, "Security is disabled")), new CreateAclsResponse.AclCreationResponse(ApiError.NONE))));
            results = env.adminClient().createAcls(Arrays.asList(ACL1, ACL2));
            KafkaAdminClientTest.assertCollectionIs(results.values().keySet(), ACL1, ACL2);
            KafkaAdminClientTest.assertFutureError((Future)results.values().get(ACL1), SecurityDisabledException.class);
            ((KafkaFuture)results.values().get(ACL2)).get();
            KafkaAdminClientTest.assertFutureError(results.all(), SecurityDisabledException.class);
        }
    }

    @Test
    public void testDeleteAcls() throws Exception {
        try (MockKafkaAdminClientEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareMetadataUpdate(env.cluster(), Collections.emptySet());
            env.kafkaClient().setNode(env.cluster().controller());
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteAclsResponse(0, Arrays.asList(new DeleteAclsResponse.AclFilterResponse(Arrays.asList(new DeleteAclsResponse.AclDeletionResult(ACL1), new DeleteAclsResponse.AclDeletionResult(ACL2))), new DeleteAclsResponse.AclFilterResponse(new ApiError(Errors.SECURITY_DISABLED, "No security"), Collections.emptySet()))));
            DeleteAclsResult results = env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2));
            Map filterResults = results.values();
            DeleteAclsResult.FilterResults filter1Results = (DeleteAclsResult.FilterResults)((KafkaFuture)filterResults.get(FILTER1)).get();
            Assert.assertEquals(null, (Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(0)).exception());
            Assert.assertEquals((Object)ACL1, (Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(0)).binding());
            Assert.assertEquals(null, (Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(1)).exception());
            Assert.assertEquals((Object)ACL2, (Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(1)).binding());
            KafkaAdminClientTest.assertFutureError((Future)filterResults.get(FILTER2), SecurityDisabledException.class);
            KafkaAdminClientTest.assertFutureError(results.all(), SecurityDisabledException.class);
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteAclsResponse(0, Arrays.asList(new DeleteAclsResponse.AclFilterResponse(Arrays.asList(new DeleteAclsResponse.AclDeletionResult(ACL1), new DeleteAclsResponse.AclDeletionResult(new ApiError(Errors.SECURITY_DISABLED, "No security"), ACL2))), new DeleteAclsResponse.AclFilterResponse(Collections.emptySet()))));
            results = env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2));
            Assert.assertTrue((boolean)((DeleteAclsResult.FilterResults)((KafkaFuture)results.values().get(FILTER2)).get()).values().isEmpty());
            KafkaAdminClientTest.assertFutureError(results.all(), SecurityDisabledException.class);
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteAclsResponse(0, Arrays.asList(new DeleteAclsResponse.AclFilterResponse(Arrays.asList(new DeleteAclsResponse.AclDeletionResult(ACL1))), new DeleteAclsResponse.AclFilterResponse(Arrays.asList(new DeleteAclsResponse.AclDeletionResult(ACL2))))));
            results = env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2));
            Collection deleted = (Collection)results.all().get();
            KafkaAdminClientTest.assertCollectionIs(deleted, ACL1, ACL2);
        }
    }

    private static <T> void assertCollectionIs(Collection<T> collection, T ... elements) {
        for (T element : elements) {
            Assert.assertTrue((String)("Did not find " + element), (boolean)collection.contains(element));
        }
        Assert.assertEquals((String)"There are unexpected extra elements in the collection.", (long)elements.length, (long)collection.size());
    }

    public static KafkaAdminClient createInternal(AdminClientConfig config, KafkaAdminClient.TimeoutProcessorFactory timeoutProcessorFactory) {
        return KafkaAdminClient.createInternal((AdminClientConfig)config, (KafkaAdminClient.TimeoutProcessorFactory)timeoutProcessorFactory);
    }

    public static class FailureInjectingTimeoutProcessorFactory
    extends KafkaAdminClient.TimeoutProcessorFactory {
        private int numTries = 0;

        public KafkaAdminClient.TimeoutProcessor create(long now) {
            return new FailureInjectingTimeoutProcessor(now);
        }

        synchronized boolean shouldInjectFailure() {
            ++this.numTries;
            return this.numTries == 3;
        }

        public final class FailureInjectingTimeoutProcessor
        extends KafkaAdminClient.TimeoutProcessor {
            public FailureInjectingTimeoutProcessor(long now) {
                super(now);
            }

            boolean callHasExpired(KafkaAdminClient.Call call) {
                if (FailureInjectingTimeoutProcessorFactory.this.shouldInjectFailure()) {
                    log.debug("Injecting timeout for {}.", (Object)call);
                    return true;
                }
                boolean ret = super.callHasExpired(call);
                log.debug("callHasExpired({}) = {}", (Object)call, (Object)ret);
                return ret;
            }
        }
    }
}

