/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class ApiVersionsResponseTest {
    @Test
    public void shouldCreateApiResponseOnlyWithKeysSupportedByMagicValue() throws Exception {
        ApiVersionsResponse response = ApiVersionsResponse.apiVersionsResponse((int)10, (byte)1);
        this.verifyApiKeysForMagic(response, (byte)1);
        Assert.assertEquals((long)10L, (long)response.throttleTimeMs());
    }

    @Test
    public void shouldCreateApiResponseThatHasAllApiKeysSupportedByBroker() throws Exception {
        Assert.assertEquals(this.apiKeysInResponse(ApiVersionsResponse.API_VERSIONS_RESPONSE), (Object)Utils.mkSet((Object[])ApiKeys.values()));
    }

    @Test
    public void shouldReturnAllKeysWhenMagicIsCurrentValueAndThrottleMsIsDefaultThrottle() throws Exception {
        ApiVersionsResponse response = ApiVersionsResponse.apiVersionsResponse((int)0, (byte)2);
        Assert.assertEquals((Object)Utils.mkSet((Object[])ApiKeys.values()), this.apiKeysInResponse(response));
        Assert.assertEquals((long)0L, (long)response.throttleTimeMs());
    }

    private void verifyApiKeysForMagic(ApiVersionsResponse response, byte maxMagic) {
        for (ApiVersionsResponse.ApiVersion version : response.apiVersions()) {
            Assert.assertTrue((ApiKeys.forId((int)version.apiKey).minRequiredInterBrokerMagic <= maxMagic ? 1 : 0) != 0);
        }
    }

    private Set<ApiKeys> apiKeysInResponse(ApiVersionsResponse apiVersions) {
        HashSet<ApiKeys> apiKeys = new HashSet<ApiKeys>();
        for (ApiVersionsResponse.ApiVersion version : apiVersions.apiVersions()) {
            apiKeys.add(ApiKeys.forId((int)version.apiKey));
        }
        return apiKeys;
    }
}

