/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.apache.kafka.common.security.plain.PlainLoginModule;

public class TestDigestLoginModule
extends PlainLoginModule {
    private static final SaslServerFactory STANDARD_DIGEST_SASL_SERVER_FACTORY;

    static {
        SaslServerFactory digestSaslServerFactory = null;
        Enumeration<SaslServerFactory> factories = Sasl.getSaslServerFactories();
        HashMap emptyProps = new HashMap();
        while (factories.hasMoreElements()) {
            SaslServerFactory factory = factories.nextElement();
            if (!Arrays.asList(factory.getMechanismNames(emptyProps)).contains("DIGEST-MD5")) continue;
            digestSaslServerFactory = factory;
            break;
        }
        STANDARD_DIGEST_SASL_SERVER_FACTORY = digestSaslServerFactory;
        Security.insertProviderAt(new DigestSaslServerProvider(), 1);
    }

    public static class DigestSaslServerProvider
    extends Provider {
        private static final long serialVersionUID = 1L;

        protected DigestSaslServerProvider() {
            super("Test SASL/Digest-MD5 Server Provider", 1.0, "Test SASL/Digest-MD5 Server Provider for Kafka");
            super.put("SaslServerFactory.DIGEST-MD5", DigestSaslServerFactory.class.getName());
        }
    }

    public static class DigestSaslServerFactory
    implements SaslServerFactory {
        @Override
        public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
            return STANDARD_DIGEST_SASL_SERVER_FACTORY.createSaslServer(mechanism, protocol, serverName, props, new DigestServerCallbackHandler());
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return new String[]{"DIGEST-MD5"};
        }
    }

    public static class DigestServerCallbackHandler
    implements CallbackHandler {
        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                AuthorizeCallback authCallback;
                if (callback instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)callback;
                    nameCallback.setName(nameCallback.getDefaultName());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback passwordCallback = (PasswordCallback)callback;
                    passwordCallback.setPassword("mypassword".toCharArray());
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    RealmCallback realmCallback = (RealmCallback)callback;
                    realmCallback.setText(realmCallback.getDefaultText());
                    continue;
                }
                if (!(callback instanceof AuthorizeCallback) || !"myuser".equals((authCallback = (AuthorizeCallback)callback).getAuthenticationID())) continue;
                authCallback.setAuthorized(true);
                authCallback.setAuthorizedID(authCallback.getAuthenticationID());
            }
        }
    }
}

