/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.junit.Assert;
import org.junit.Test;

public class NodeApiVersionsTest {
    @Test
    public void testUnsupportedVersionsToString() {
        NodeApiVersions versions = new NodeApiVersions(Collections.emptyList());
        StringBuilder bld = new StringBuilder();
        String prefix = "(";
        for (ApiKeys apiKey : ApiKeys.values()) {
            bld.append(prefix).append(apiKey.name).append("(").append(apiKey.id).append("): UNSUPPORTED");
            prefix = ", ";
        }
        bld.append(")");
        Assert.assertEquals((Object)bld.toString(), (Object)versions.toString());
    }

    @Test
    public void testUnknownApiVersionsToString() {
        ApiVersionsResponse.ApiVersion unknownApiVersion = new ApiVersionsResponse.ApiVersion(337, 0, 1);
        NodeApiVersions versions = new NodeApiVersions(Collections.singleton(unknownApiVersion));
        Assert.assertTrue((boolean)versions.toString().endsWith("UNKNOWN(337): 0 to 1)"));
    }

    @Test
    public void testVersionsToString() {
        ArrayList<ApiVersionsResponse.ApiVersion> versionList = new ArrayList<ApiVersionsResponse.ApiVersion>();
        for (ApiKeys apiKey : ApiKeys.values()) {
            if (apiKey == ApiKeys.CONTROLLED_SHUTDOWN_KEY) {
                versionList.add(new ApiVersionsResponse.ApiVersion(apiKey.id, 0, 0));
                continue;
            }
            if (apiKey == ApiKeys.DELETE_TOPICS) {
                versionList.add(new ApiVersionsResponse.ApiVersion(apiKey.id, 10000, 10001));
                continue;
            }
            versionList.add(new ApiVersionsResponse.ApiVersion(apiKey));
        }
        NodeApiVersions versions = new NodeApiVersions(versionList);
        StringBuilder bld = new StringBuilder();
        String prefix = "(";
        for (ApiKeys apiKey : ApiKeys.values()) {
            bld.append(prefix);
            if (apiKey == ApiKeys.CONTROLLED_SHUTDOWN_KEY) {
                bld.append("ControlledShutdown(7): 0 [unusable: node too old]");
            } else if (apiKey == ApiKeys.DELETE_TOPICS) {
                bld.append("DeleteTopics(20): 10000 to 10001 [unusable: node too new]");
            } else {
                bld.append(apiKey.name).append("(").append(apiKey.id).append("): ");
                if (apiKey.oldestVersion() == apiKey.latestVersion()) {
                    bld.append(apiKey.oldestVersion());
                } else {
                    bld.append(apiKey.oldestVersion()).append(" to ").append(apiKey.latestVersion());
                }
                bld.append(" [usable: ").append(apiKey.latestVersion()).append("]");
            }
            prefix = ", ";
        }
        bld.append(")");
        Assert.assertEquals((Object)bld.toString(), (Object)versions.toString());
    }

    @Test
    public void testUsableVersionCalculation() {
        ArrayList<ApiVersionsResponse.ApiVersion> versionList = new ArrayList<ApiVersionsResponse.ApiVersion>();
        versionList.add(new ApiVersionsResponse.ApiVersion(ApiKeys.CONTROLLED_SHUTDOWN_KEY.id, 0, 0));
        versionList.add(new ApiVersionsResponse.ApiVersion(ApiKeys.FETCH.id, 1, 2));
        NodeApiVersions versions = new NodeApiVersions(versionList);
        try {
            versions.usableVersion(ApiKeys.CONTROLLED_SHUTDOWN_KEY);
            Assert.fail((String)"expected UnsupportedVersionException");
        }
        catch (UnsupportedVersionException unsupportedVersionException) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)versions.usableVersion(ApiKeys.FETCH));
    }

    @Test
    public void testUsableVersionNoDesiredVersionReturnsLatestUsable() {
        NodeApiVersions apiVersions = NodeApiVersions.create(Collections.singleton(new ApiVersionsResponse.ApiVersion(ApiKeys.PRODUCE.id, 1, 3)));
        Assert.assertEquals((long)3L, (long)apiVersions.usableVersion(ApiKeys.PRODUCE, null));
    }

    @Test
    public void testDesiredVersion() {
        NodeApiVersions apiVersions = NodeApiVersions.create(Collections.singleton(new ApiVersionsResponse.ApiVersion(ApiKeys.PRODUCE.id, 1, 3)));
        Assert.assertEquals((long)1L, (long)apiVersions.usableVersion(ApiKeys.PRODUCE, Short.valueOf((short)1)));
        Assert.assertEquals((long)2L, (long)apiVersions.usableVersion(ApiKeys.PRODUCE, Short.valueOf((short)2)));
        Assert.assertEquals((long)3L, (long)apiVersions.usableVersion(ApiKeys.PRODUCE, Short.valueOf((short)3)));
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testDesiredVersionTooLarge() {
        NodeApiVersions apiVersions = NodeApiVersions.create(Collections.singleton(new ApiVersionsResponse.ApiVersion(ApiKeys.PRODUCE.id, 1, 2)));
        apiVersions.usableVersion(ApiKeys.PRODUCE, Short.valueOf((short)3));
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testDesiredVersionTooSmall() {
        NodeApiVersions apiVersions = NodeApiVersions.create(Collections.singleton(new ApiVersionsResponse.ApiVersion(ApiKeys.PRODUCE.id, 1, 2)));
        apiVersions.usableVersion(ApiKeys.PRODUCE, Short.valueOf((short)0));
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testUsableVersionCalculationNoKnownVersions() {
        ArrayList versionList = new ArrayList();
        NodeApiVersions versions = new NodeApiVersions(versionList);
        versions.usableVersion(ApiKeys.FETCH);
    }

    @Test
    public void testUsableVersionLatestVersions() {
        LinkedList<ApiVersionsResponse.ApiVersion> versionList = new LinkedList<ApiVersionsResponse.ApiVersion>();
        for (ApiVersionsResponse.ApiVersion apiVersion : ApiVersionsResponse.API_VERSIONS_RESPONSE.apiVersions()) {
            versionList.add(apiVersion);
        }
        versionList.add(new ApiVersionsResponse.ApiVersion(100, 0, 1));
        NodeApiVersions versions = new NodeApiVersions(versionList);
        for (ApiKeys apiKey : ApiKeys.values()) {
            Assert.assertEquals((long)apiKey.latestVersion(), (long)versions.usableVersion(apiKey));
        }
    }
}

