/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.utils.Time;

public class MockKafkaAdminClientEnv
implements AutoCloseable {
    private final Time time;
    private final AdminClientConfig adminClientConfig;
    private final Metadata metadata;
    private final MockClient mockClient;
    private final KafkaAdminClient client;
    private final Cluster cluster;

    public MockKafkaAdminClientEnv(Cluster cluster, String ... vals) {
        this(Time.SYSTEM, cluster, vals);
    }

    public MockKafkaAdminClientEnv(Time time, Cluster cluster, String ... vals) {
        this(time, cluster, MockKafkaAdminClientEnv.newStrMap(vals));
    }

    public MockKafkaAdminClientEnv(Time time, Cluster cluster, Map<String, Object> config) {
        this.time = time;
        this.adminClientConfig = new AdminClientConfig(config);
        this.cluster = cluster;
        this.metadata = new Metadata(this.adminClientConfig.getLong("retry.backoff.ms").longValue(), this.adminClientConfig.getLong("metadata.max.age.ms").longValue(), false);
        this.mockClient = new MockClient(time, this.metadata);
        this.client = KafkaAdminClient.createInternal((AdminClientConfig)this.adminClientConfig, (KafkaClient)this.mockClient, (Metadata)this.metadata, (Time)time);
    }

    public Time time() {
        return this.time;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public AdminClient adminClient() {
        return this.client;
    }

    public MockClient kafkaClient() {
        return this.mockClient;
    }

    @Override
    public void close() {
        this.client.close();
    }

    private static Map<String, Object> newStrMap(String ... vals) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bootstrap.servers", "localhost:8121");
        map.put("request.timeout.ms", "1000");
        if (vals.length % 2 != 0) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < vals.length; i += 2) {
            map.put(vals[i], vals[i + 1]);
        }
        return map;
    }
}

