/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerCoordinator;
import org.apache.kafka.clients.consumer.internals.ConsumerInterceptors;
import org.apache.kafka.clients.consumer.internals.ConsumerMetrics;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.clients.consumer.internals.Fetcher;
import org.apache.kafka.clients.consumer.internals.NoOpConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.apache.kafka.test.MockMetricsReporter;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class KafkaConsumerTest {
    private final String topic = "test";
    private final TopicPartition tp0 = new TopicPartition("test", 0);
    private final TopicPartition tp1 = new TopicPartition("test", 1);
    private final String topic2 = "test2";
    private final TopicPartition t2p0 = new TopicPartition("test2", 0);
    private final String topic3 = "test3";
    private final TopicPartition t3p0 = new TopicPartition("test3", 0);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testConstructorClose() throws Exception {
        Properties props = new Properties();
        props.setProperty("client.id", "testConstructorClose");
        props.setProperty("bootstrap.servers", "some.invalid.hostname.foo.bar.local:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        int oldInitCount = MockMetricsReporter.INIT_COUNT.get();
        int oldCloseCount = MockMetricsReporter.CLOSE_COUNT.get();
        try {
            new KafkaConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        }
        catch (KafkaException e) {
            Assert.assertEquals((long)(oldInitCount + 1), (long)MockMetricsReporter.INIT_COUNT.get());
            Assert.assertEquals((long)(oldCloseCount + 1), (long)MockMetricsReporter.CLOSE_COUNT.get());
            Assert.assertEquals((Object)"Failed to construct kafka consumer", (Object)e.getMessage());
            return;
        }
        Assert.fail((String)"should have caught an exception and returned");
    }

    @Test
    public void testOsDefaultSocketBufferSizes() throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", "localhost:9999");
        config.put("send.buffer.bytes", -1);
        config.put("receive.buffer.bytes", -1);
        KafkaConsumer consumer = new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        consumer.close();
    }

    @Test(expected=KafkaException.class)
    public void testInvalidSocketSendBufferSize() throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", "localhost:9999");
        config.put("send.buffer.bytes", -2);
        new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
    }

    @Test(expected=KafkaException.class)
    public void testInvalidSocketReceiveBufferSize() throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", "localhost:9999");
        config.put("receive.buffer.bytes", -2);
        new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
    }

    @Test
    public void testSubscription() {
        KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();
        consumer.subscribe(Collections.singletonList("test"));
        Assert.assertEquals(Collections.singleton("test"), (Object)consumer.subscription());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        consumer.subscribe(Collections.emptyList());
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        consumer.assign(Collections.singletonList(this.tp0));
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
        consumer.unsubscribe();
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        consumer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testSubscriptionOnNullTopicCollection() {
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.subscribe(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testSubscriptionOnNullTopic() {
        Object nullTopic = null;
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.subscribe(Collections.singletonList(nullTopic));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testSubscriptionOnEmptyTopic() {
        String emptyTopic = "  ";
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.subscribe(Collections.singletonList(emptyTopic));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testSubscriptionOnNullPattern() {
        Pattern pattern = null;
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.subscribe(pattern, (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testSeekNegative() {
        Properties props = new Properties();
        props.setProperty("client.id", "testSeekNegative");
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.assign(Arrays.asList(new TopicPartition("nonExistTopic", 0)));
            consumer.seek(new TopicPartition("nonExistTopic", 0), -1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testAssignOnNullTopicPartition() {
        Properties props = new Properties();
        props.setProperty("client.id", "testAssignOnNullTopicPartition");
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.assign(null);
        }
    }

    @Test
    public void testAssignOnEmptyTopicPartition() {
        KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();
        consumer.assign(Collections.emptyList());
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        consumer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testAssignOnNullTopicInPartition() {
        Properties props = new Properties();
        props.setProperty("client.id", "testAssignOnNullTopicInPartition");
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.assign(Arrays.asList(new TopicPartition(null, 0)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testAssignOnEmptyTopicInPartition() {
        Properties props = new Properties();
        props.setProperty("client.id", "testAssignOnEmptyTopicInPartition");
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.assign(Arrays.asList(new TopicPartition("  ", 0)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterceptorConstructorClose() throws Exception {
        try {
            Properties props = new Properties();
            props.setProperty("bootstrap.servers", "localhost:9999");
            props.setProperty("interceptor.classes", MockConsumerInterceptor.class.getName());
            KafkaConsumer consumer = new KafkaConsumer(props, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            Assert.assertEquals((long)1L, (long)MockConsumerInterceptor.INIT_COUNT.get());
            Assert.assertEquals((long)0L, (long)MockConsumerInterceptor.CLOSE_COUNT.get());
            consumer.close();
            Assert.assertEquals((long)1L, (long)MockConsumerInterceptor.INIT_COUNT.get());
            Assert.assertEquals((long)1L, (long)MockConsumerInterceptor.CLOSE_COUNT.get());
            Assert.assertNull((Object)MockConsumerInterceptor.CLUSTER_META.get());
        }
        finally {
            MockConsumerInterceptor.resetCounters();
        }
    }

    @Test
    public void testPause() {
        KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();
        consumer.assign(Collections.singletonList(this.tp0));
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
        Assert.assertTrue((boolean)consumer.paused().isEmpty());
        consumer.pause(Collections.singleton(this.tp0));
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.paused());
        consumer.resume(Collections.singleton(this.tp0));
        Assert.assertTrue((boolean)consumer.paused().isEmpty());
        consumer.unsubscribe();
        Assert.assertTrue((boolean)consumer.paused().isEmpty());
        consumer.close();
    }

    private KafkaConsumer<byte[], byte[]> newConsumer() {
        Properties props = new Properties();
        props.setProperty("client.id", "my.consumer");
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        return new KafkaConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
    }

    @Test
    public void verifyHeartbeatSent() throws Exception {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 1000;
        int autoCommitIntervalMs = 10000;
        MockTime time = new MockTime();
        Cluster cluster = TestUtils.singletonCluster("test", 1);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = this.createMetadata();
        metadata.update(cluster, Collections.emptySet(), time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, true, autoCommitIntervalMs);
        consumer.subscribe(Arrays.asList("test"), this.getConsumerRebalanceListener(consumer));
        Node coordinator = this.prepareRebalance(client, node, (PartitionAssignor)assignor, Arrays.asList(this.tp0), null);
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 0L, 0), node);
        consumer.poll(0L);
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
        AtomicBoolean heartbeatReceived = this.prepareHeartbeatResponse(client, coordinator);
        time.sleep(heartbeatIntervalMs);
        Thread.sleep(heartbeatIntervalMs);
        consumer.poll(0L);
        Assert.assertTrue((boolean)heartbeatReceived.get());
        consumer.close(0L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void verifyHeartbeatSentWhenFetchedDataReady() throws Exception {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 1000;
        int autoCommitIntervalMs = 10000;
        MockTime time = new MockTime();
        Cluster cluster = TestUtils.singletonCluster("test", 1);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = this.createMetadata();
        metadata.update(cluster, Collections.emptySet(), time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, true, autoCommitIntervalMs);
        consumer.subscribe(Arrays.asList("test"), this.getConsumerRebalanceListener(consumer));
        Node coordinator = this.prepareRebalance(client, node, (PartitionAssignor)assignor, Arrays.asList(this.tp0), null);
        consumer.poll(0L);
        client.respondFrom((AbstractResponse)this.fetchResponse(this.tp0, 0L, 5), node);
        client.poll(0L, time.milliseconds());
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 5L, 0), node);
        AtomicBoolean heartbeatReceived = this.prepareHeartbeatResponse(client, coordinator);
        time.sleep(heartbeatIntervalMs);
        Thread.sleep(heartbeatIntervalMs);
        consumer.poll(0L);
        Assert.assertTrue((boolean)heartbeatReceived.get());
        consumer.close(0L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void verifyNoCoordinatorLookupForManualAssignmentWithSeek() {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 3000;
        int heartbeatIntervalMs = 2000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        Cluster cluster = TestUtils.singletonCluster("test", 1);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = this.createMetadata();
        metadata.update(cluster, Collections.emptySet(), time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, true, autoCommitIntervalMs);
        consumer.assign(Arrays.asList(this.tp0));
        consumer.seekToBeginning(Arrays.asList(this.tp0));
        client.prepareResponse((AbstractResponse)this.listOffsetsResponse(Collections.singletonMap(this.tp0, 50L), Errors.NONE));
        client.prepareResponse((AbstractResponse)this.fetchResponse(this.tp0, 50L, 5));
        ConsumerRecords records = consumer.poll(0L);
        Assert.assertEquals((long)5L, (long)records.count());
        Assert.assertEquals((long)55L, (long)consumer.position(this.tp0));
        consumer.close(0L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testCommitsFetchedDuringAssign() {
        long offset1 = 10000L;
        long offset2 = 20000L;
        int rebalanceTimeoutMs = 6000;
        int sessionTimeoutMs = 3000;
        int heartbeatIntervalMs = 2000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        Cluster cluster = TestUtils.singletonCluster("test", 1);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = this.createMetadata();
        metadata.update(cluster, Collections.emptySet(), time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, true, autoCommitIntervalMs);
        consumer.assign(Collections.singletonList(this.tp0));
        client.prepareResponseFrom((AbstractResponse)new FindCoordinatorResponse(Errors.NONE, node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, offset1), Errors.NONE), coordinator);
        Assert.assertEquals((long)offset1, (long)consumer.committed(this.tp0).offset());
        consumer.assign(Arrays.asList(this.tp0, this.tp1));
        HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
        offsets.put(this.tp0, offset1);
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(offsets, Errors.NONE), coordinator);
        Assert.assertEquals((long)offset1, (long)consumer.committed(this.tp0).offset());
        offsets.remove(this.tp0);
        offsets.put(this.tp1, offset2);
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(offsets, Errors.NONE), coordinator);
        Assert.assertEquals((long)offset2, (long)consumer.committed(this.tp1).offset());
        consumer.close(0L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testAutoCommitSentBeforePositionUpdate() {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        Cluster cluster = TestUtils.singletonCluster("test", 1);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = this.createMetadata();
        metadata.update(cluster, Collections.emptySet(), time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, true, autoCommitIntervalMs);
        consumer.subscribe(Arrays.asList("test"), this.getConsumerRebalanceListener(consumer));
        Node coordinator = this.prepareRebalance(client, node, (PartitionAssignor)assignor, Arrays.asList(this.tp0), null);
        consumer.poll(0L);
        client.respondFrom((AbstractResponse)this.fetchResponse(this.tp0, 0L, 5), node);
        client.poll(0L, time.milliseconds());
        time.sleep(autoCommitIntervalMs);
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 5L, 0), node);
        AtomicBoolean commitReceived = this.prepareOffsetCommitResponse(client, coordinator, this.tp0, 0L);
        consumer.poll(0L);
        Assert.assertTrue((boolean)commitReceived.get());
        consumer.close(0L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testRegexSubscription() {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        String unmatchedTopic = "unmatched";
        MockTime time = new MockTime();
        HashMap<String, Integer> topicMetadata = new HashMap<String, Integer>();
        topicMetadata.put("test", 1);
        topicMetadata.put(unmatchedTopic, 1);
        Cluster cluster = TestUtils.clusterWith(1, topicMetadata);
        Metadata metadata = this.createMetadata();
        Node node = (Node)cluster.nodes().get(0);
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, true, autoCommitIntervalMs);
        this.prepareRebalance(client, node, Collections.singleton("test"), (PartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        consumer.subscribe(Pattern.compile("test"), this.getConsumerRebalanceListener(consumer));
        client.prepareMetadataUpdate(cluster, Collections.emptySet());
        consumer.poll(0L);
        Assert.assertEquals(Collections.singleton("test"), (Object)consumer.subscription());
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
        consumer.close(0L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testChangingRegexSubscription() {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        String otherTopic = "other";
        TopicPartition otherTopicPartition = new TopicPartition(otherTopic, 0);
        MockTime time = new MockTime();
        HashMap<String, Integer> topicMetadata = new HashMap<String, Integer>();
        topicMetadata.put("test", 1);
        topicMetadata.put(otherTopic, 1);
        Cluster cluster = TestUtils.clusterWith(1, topicMetadata);
        Metadata metadata = this.createMetadata();
        Node node = (Node)cluster.nodes().get(0);
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        client.cluster(cluster);
        metadata.update(cluster, Collections.emptySet(), time.milliseconds());
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, false, autoCommitIntervalMs);
        Node coordinator = this.prepareRebalance(client, node, Collections.singleton("test"), (PartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        consumer.subscribe(Pattern.compile("test"), this.getConsumerRebalanceListener(consumer));
        consumer.poll(0L);
        Assert.assertEquals(Collections.singleton("test"), (Object)consumer.subscription());
        consumer.subscribe(Pattern.compile(otherTopic), this.getConsumerRebalanceListener(consumer));
        this.prepareRebalance(client, node, Collections.singleton(otherTopic), (PartitionAssignor)assignor, Collections.singletonList(otherTopicPartition), coordinator);
        consumer.poll(0L);
        Assert.assertEquals(Collections.singleton(otherTopic), (Object)consumer.subscription());
        consumer.close(0L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testWakeupWithFetchDataAvailable() throws Exception {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        final MockTime time = new MockTime();
        Cluster cluster = TestUtils.singletonCluster("test", 1);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = this.createMetadata();
        metadata.update(cluster, Collections.emptySet(), time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, 30000, heartbeatIntervalMs, true, autoCommitIntervalMs);
        consumer.subscribe(Arrays.asList("test"), this.getConsumerRebalanceListener(consumer));
        this.prepareRebalance(client, node, (PartitionAssignor)assignor, Arrays.asList(this.tp0), null);
        consumer.poll(0L);
        client.respondFrom((AbstractResponse)this.fetchResponse(this.tp0, 0L, 5), node);
        client.poll(0L, time.milliseconds());
        consumer.wakeup();
        try {
            consumer.poll(0L);
            Assert.fail();
        }
        catch (WakeupException e) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)consumer.position(this.tp0));
        ConsumerRecords records = consumer.poll(0L);
        Assert.assertEquals((long)5L, (long)records.count());
        ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();
        exec.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                time.sleep(30000L);
            }
        }, 0L, 10L, TimeUnit.MILLISECONDS);
        consumer.close();
        exec.shutdownNow();
        exec.awaitTermination(5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPollThrowsInterruptExceptionIfInterrupted() throws Exception {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        MockTime time = new MockTime();
        Cluster cluster = TestUtils.singletonCluster("test", 1);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = this.createMetadata();
        metadata.update(cluster, Collections.emptySet(), time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, false, 0);
        consumer.subscribe(Arrays.asList("test"), this.getConsumerRebalanceListener(consumer));
        this.prepareRebalance(client, node, (PartitionAssignor)assignor, Arrays.asList(this.tp0), null);
        consumer.poll(0L);
        try {
            Thread.currentThread().interrupt();
            this.expectedException.expect(InterruptException.class);
            consumer.poll(0L);
        }
        finally {
            Thread.interrupted();
        }
        consumer.close(0L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void fetchResponseWithUnexpectedPartitionIsIgnored() {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        Cluster cluster = TestUtils.singletonCluster(Collections.singletonMap("test", 1));
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = this.createMetadata();
        metadata.update(cluster, Collections.emptySet(), time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RangeAssignor assignor = new RangeAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, true, autoCommitIntervalMs);
        consumer.subscribe(Collections.singletonList("test"), this.getConsumerRebalanceListener(consumer));
        this.prepareRebalance(client, node, (PartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        HashMap<TopicPartition, FetchInfo> fetches1 = new HashMap<TopicPartition, FetchInfo>();
        fetches1.put(this.tp0, new FetchInfo(0L, 1));
        fetches1.put(this.t2p0, new FetchInfo(0L, 10));
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(fetches1), node);
        ConsumerRecords records = consumer.poll(0L);
        Assert.assertEquals((long)0L, (long)records.count());
        consumer.close(0L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testSubscriptionChangesWithAutoCommitEnabled() {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        HashMap<String, Integer> tpCounts = new HashMap<String, Integer>();
        tpCounts.put("test", 1);
        tpCounts.put("test2", 1);
        tpCounts.put("test3", 1);
        Cluster cluster = TestUtils.singletonCluster(tpCounts);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = this.createMetadata();
        metadata.update(cluster, Collections.emptySet(), time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RangeAssignor assignor = new RangeAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, true, autoCommitIntervalMs);
        consumer.subscribe(Arrays.asList("test", "test2"), this.getConsumerRebalanceListener(consumer));
        Assert.assertTrue((consumer.subscription().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((consumer.subscription().contains("test") && consumer.subscription().contains("test2") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        Node coordinator = this.prepareRebalance(client, node, (PartitionAssignor)assignor, Arrays.asList(this.tp0, this.t2p0), null);
        consumer.poll(0L);
        Assert.assertTrue((consumer.subscription().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((consumer.subscription().contains("test") && consumer.subscription().contains("test2") ? 1 : 0) != 0);
        Assert.assertTrue((consumer.assignment().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((consumer.assignment().contains(this.tp0) && consumer.assignment().contains(this.t2p0) ? 1 : 0) != 0);
        HashMap<TopicPartition, FetchInfo> fetches1 = new HashMap<TopicPartition, FetchInfo>();
        fetches1.put(this.tp0, new FetchInfo(0L, 1));
        fetches1.put(this.t2p0, new FetchInfo(0L, 10));
        client.respondFrom((AbstractResponse)this.fetchResponse(fetches1), node);
        client.poll(0L, time.milliseconds());
        ConsumerRecords records = consumer.poll(0L);
        fetches1.put(this.tp0, new FetchInfo(1L, 0));
        fetches1.put(this.t2p0, new FetchInfo(10L, 0));
        client.respondFrom((AbstractResponse)this.fetchResponse(fetches1), node);
        client.poll(0L, time.milliseconds());
        Assert.assertEquals((long)11L, (long)records.count());
        Assert.assertEquals((long)1L, (long)consumer.position(this.tp0));
        Assert.assertEquals((long)10L, (long)consumer.position(this.t2p0));
        consumer.subscribe(Arrays.asList("test", "test3"), this.getConsumerRebalanceListener(consumer));
        Assert.assertTrue((consumer.subscription().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((consumer.subscription().contains("test") && consumer.subscription().contains("test3") ? 1 : 0) != 0);
        Assert.assertTrue((consumer.assignment().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((consumer.assignment().contains(this.tp0) && consumer.assignment().contains(this.t2p0) ? 1 : 0) != 0);
        HashMap<TopicPartition, Long> partitionOffsets1 = new HashMap<TopicPartition, Long>();
        partitionOffsets1.put(this.tp0, 1L);
        partitionOffsets1.put(this.t2p0, 10L);
        AtomicBoolean commitReceived = this.prepareOffsetCommitResponse(client, coordinator, partitionOffsets1);
        this.prepareRebalance(client, node, (PartitionAssignor)assignor, Arrays.asList(this.tp0, this.t3p0), coordinator);
        HashMap<TopicPartition, FetchInfo> fetches2 = new HashMap<TopicPartition, FetchInfo>();
        fetches2.put(this.tp0, new FetchInfo(1L, 1));
        fetches2.put(this.t3p0, new FetchInfo(0L, 100));
        client.prepareResponse((AbstractResponse)this.fetchResponse(fetches2));
        records = consumer.poll(0L);
        Assert.assertEquals((long)101L, (long)records.count());
        Assert.assertEquals((long)2L, (long)consumer.position(this.tp0));
        Assert.assertEquals((long)100L, (long)consumer.position(this.t3p0));
        Assert.assertTrue((boolean)commitReceived.get());
        Assert.assertTrue((consumer.subscription().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((consumer.subscription().contains("test") && consumer.subscription().contains("test3") ? 1 : 0) != 0);
        Assert.assertTrue((consumer.assignment().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((consumer.assignment().contains(this.tp0) && consumer.assignment().contains(this.t3p0) ? 1 : 0) != 0);
        consumer.unsubscribe();
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        client.requests().clear();
        consumer.close();
    }

    @Test
    public void testSubscriptionChangesWithAutoCommitDisabled() {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        HashMap<String, Integer> tpCounts = new HashMap<String, Integer>();
        tpCounts.put("test", 1);
        tpCounts.put("test2", 1);
        Cluster cluster = TestUtils.singletonCluster(tpCounts);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = this.createMetadata();
        metadata.update(cluster, Collections.emptySet(), time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RangeAssignor assignor = new RangeAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, false, autoCommitIntervalMs);
        consumer.subscribe(Arrays.asList("test"), this.getConsumerRebalanceListener(consumer));
        Assert.assertTrue((boolean)consumer.subscription().equals(Collections.singleton("test")));
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        this.prepareRebalance(client, node, (PartitionAssignor)assignor, Arrays.asList(this.tp0), null);
        consumer.poll(0L);
        Assert.assertTrue((boolean)consumer.subscription().equals(Collections.singleton("test")));
        Assert.assertTrue((boolean)consumer.assignment().equals(Collections.singleton(this.tp0)));
        consumer.poll(0L);
        consumer.subscribe(Arrays.asList("test2"), this.getConsumerRebalanceListener(consumer));
        Assert.assertTrue((boolean)consumer.subscription().equals(Collections.singleton("test2")));
        Assert.assertTrue((boolean)consumer.assignment().equals(Collections.singleton(this.tp0)));
        for (ClientRequest req : client.requests()) {
            Assert.assertTrue((req.requestBuilder().apiKey() != ApiKeys.OFFSET_COMMIT ? 1 : 0) != 0);
        }
        consumer.unsubscribe();
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        for (ClientRequest req : client.requests()) {
            Assert.assertTrue((req.requestBuilder().apiKey() != ApiKeys.OFFSET_COMMIT ? 1 : 0) != 0);
        }
        client.requests().clear();
        consumer.close();
    }

    @Test
    public void testManualAssignmentChangeWithAutoCommitEnabled() {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        HashMap<String, Integer> tpCounts = new HashMap<String, Integer>();
        tpCounts.put("test", 1);
        tpCounts.put("test2", 1);
        Cluster cluster = TestUtils.singletonCluster(tpCounts);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = this.createMetadata();
        metadata.update(cluster, Collections.emptySet(), time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RangeAssignor assignor = new RangeAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, true, autoCommitIntervalMs);
        client.prepareResponseFrom((AbstractResponse)new FindCoordinatorResponse(Errors.NONE, node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        consumer.assign(Arrays.asList(this.tp0));
        consumer.seekToBeginning(Arrays.asList(this.tp0));
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, 0L), Errors.NONE), coordinator);
        Assert.assertEquals((long)0L, (long)consumer.committed(this.tp0).offset());
        Assert.assertTrue((boolean)consumer.assignment().equals(Collections.singleton(this.tp0)));
        client.prepareResponse((AbstractResponse)this.listOffsetsResponse(Collections.singletonMap(this.tp0, 10L), Errors.NONE));
        client.prepareResponse((AbstractResponse)this.fetchResponse(this.tp0, 10L, 1));
        ConsumerRecords records = consumer.poll(0L);
        Assert.assertEquals((long)1L, (long)records.count());
        Assert.assertEquals((long)11L, (long)consumer.position(this.tp0));
        AtomicBoolean commitReceived = this.prepareOffsetCommitResponse(client, coordinator, this.tp0, 11L);
        consumer.assign(Arrays.asList(this.t2p0));
        Assert.assertTrue((boolean)consumer.assignment().equals(Collections.singleton(this.t2p0)));
        Assert.assertTrue((boolean)commitReceived.get());
        client.requests().clear();
        consumer.close();
    }

    @Test
    public void testManualAssignmentChangeWithAutoCommitDisabled() {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        HashMap<String, Integer> tpCounts = new HashMap<String, Integer>();
        tpCounts.put("test", 1);
        tpCounts.put("test2", 1);
        Cluster cluster = TestUtils.singletonCluster(tpCounts);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = this.createMetadata();
        metadata.update(cluster, Collections.emptySet(), time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RangeAssignor assignor = new RangeAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, false, autoCommitIntervalMs);
        client.prepareResponseFrom((AbstractResponse)new FindCoordinatorResponse(Errors.NONE, node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        consumer.assign(Arrays.asList(this.tp0));
        consumer.seekToBeginning(Arrays.asList(this.tp0));
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, 0L), Errors.NONE), coordinator);
        Assert.assertEquals((long)0L, (long)consumer.committed(this.tp0).offset());
        Assert.assertTrue((boolean)consumer.assignment().equals(Collections.singleton(this.tp0)));
        client.prepareResponse((AbstractResponse)this.listOffsetsResponse(Collections.singletonMap(this.tp0, 10L), Errors.NONE));
        client.prepareResponse((AbstractResponse)this.fetchResponse(this.tp0, 10L, 1));
        ConsumerRecords records = consumer.poll(0L);
        Assert.assertEquals((long)1L, (long)records.count());
        Assert.assertEquals((long)11L, (long)consumer.position(this.tp0));
        consumer.assign(Arrays.asList(this.t2p0));
        Assert.assertTrue((boolean)consumer.assignment().equals(Collections.singleton(this.t2p0)));
        for (ClientRequest req : client.requests()) {
            Assert.assertTrue((req.requestBuilder().apiKey() != ApiKeys.OFFSET_COMMIT ? 1 : 0) != 0);
        }
        client.requests().clear();
        consumer.close();
    }

    @Test
    public void testOffsetOfPausedPartitions() {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        Cluster cluster = TestUtils.singletonCluster("test", 2);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = this.createMetadata();
        metadata.update(cluster, Collections.emptySet(), time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RangeAssignor assignor = new RangeAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, true, autoCommitIntervalMs);
        client.prepareResponseFrom((AbstractResponse)new FindCoordinatorResponse(Errors.NONE, node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        Set partitions = Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.tp1});
        consumer.assign((Collection)partitions);
        Assert.assertTrue((boolean)consumer.assignment().equals(partitions));
        consumer.pause((Collection)partitions);
        consumer.seekToEnd((Collection)partitions);
        HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
        offsets.put(this.tp0, 0L);
        offsets.put(this.tp1, 0L);
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(offsets, Errors.NONE), coordinator);
        Assert.assertEquals((long)0L, (long)consumer.committed(this.tp0).offset());
        offsets.remove(this.tp0);
        offsets.put(this.tp1, 0L);
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(offsets, Errors.NONE), coordinator);
        Assert.assertEquals((long)0L, (long)consumer.committed(this.tp1).offset());
        HashMap<TopicPartition, Long> offsetResponse = new HashMap<TopicPartition, Long>();
        offsetResponse.put(this.tp0, 3L);
        offsetResponse.put(this.tp1, 3L);
        client.prepareResponse((AbstractResponse)this.listOffsetsResponse(offsetResponse, Errors.NONE));
        Assert.assertEquals((long)3L, (long)consumer.position(this.tp0));
        Assert.assertEquals((long)3L, (long)consumer.position(this.tp1));
        client.requests().clear();
        consumer.unsubscribe();
        consumer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testPollWithNoSubscription() {
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.poll(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testPollWithEmptySubscription() {
        consumer.subscribe(Collections.emptyList());
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.poll(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testPollWithEmptyUserAssignment() {
        consumer.assign(Collections.emptySet());
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.poll(0L);
        }
    }

    @Test
    public void testGracefulClose() throws Exception {
        HashMap<TopicPartition, Errors> response = new HashMap<TopicPartition, Errors>();
        response.put(this.tp0, Errors.NONE);
        OffsetCommitResponse commitResponse = this.offsetCommitResponse(response);
        LeaveGroupResponse leaveGroupResponse = new LeaveGroupResponse(Errors.NONE);
        this.consumerCloseTest(5000L, Arrays.asList(commitResponse, leaveGroupResponse), 0L, false);
    }

    @Test
    public void testCloseTimeout() throws Exception {
        this.consumerCloseTest(5000L, Collections.emptyList(), 5000L, false);
    }

    @Test
    public void testLeaveGroupTimeout() throws Exception {
        HashMap<TopicPartition, Errors> response = new HashMap<TopicPartition, Errors>();
        response.put(this.tp0, Errors.NONE);
        OffsetCommitResponse commitResponse = this.offsetCommitResponse(response);
        this.consumerCloseTest(5000L, Arrays.asList(commitResponse), 5000L, false);
    }

    @Test
    public void testCloseNoWait() throws Exception {
        this.consumerCloseTest(0L, Collections.emptyList(), 0L, false);
    }

    @Test
    public void testCloseInterrupt() throws Exception {
        this.consumerCloseTest(Long.MAX_VALUE, Collections.emptyList(), 0L, true);
    }

    @Test
    public void closeShouldBeIdempotent() {
        KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();
        consumer.close();
        consumer.close();
    }

    @Test
    public void testMetricConfigRecordingLevel() {
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:9000");
        try (KafkaConsumer consumer = new KafkaConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());){
            Assert.assertEquals((Object)Sensor.RecordingLevel.INFO, (Object)consumer.metrics.config().recordLevel());
        }
        props.put("metrics.recording.level", "DEBUG");
        consumer = new KafkaConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        var3_3 = null;
        try {
            Assert.assertEquals((Object)Sensor.RecordingLevel.DEBUG, (Object)consumer.metrics.config().recordLevel());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (consumer != null) {
                if (var3_3 != null) {
                    try {
                        consumer.close();
                    }
                    catch (Throwable x2) {
                        var3_3.addSuppressed(x2);
                    }
                } else {
                    consumer.close();
                }
            }
        }
    }

    @Test
    public void shouldAttemptToRejoinGroupAfterSyncGroupFailed() throws Exception {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 500;
        MockTime time = new MockTime();
        Cluster cluster = TestUtils.singletonCluster("test", 1);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = new Metadata(0L, Long.MAX_VALUE, false);
        metadata.update(cluster, Collections.emptySet(), time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, false, 1000);
        consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(consumer));
        client.prepareResponseFrom((AbstractResponse)new FindCoordinatorResponse(Errors.NONE, node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)this.joinGroupFollowerResponse((PartitionAssignor)assignor, 1, "memberId", "leaderId", Errors.NONE), coordinator);
        client.prepareResponseFrom((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.tp0), Errors.NONE), coordinator);
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 0L, 1), node);
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 1L, 0), node);
        consumer.poll(0L);
        client.prepareResponseFrom(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                return true;
            }
        }, (AbstractResponse)new HeartbeatResponse(Errors.REBALANCE_IN_PROGRESS), coordinator);
        ByteBuffer byteBuffer = ConsumerProtocol.serializeSubscription((PartitionAssignor.Subscription)new PartitionAssignor.Subscription(Collections.singletonList("test")));
        JoinGroupResponse leaderResponse = new JoinGroupResponse(Errors.NONE, 1, assignor.name(), "memberId", "memberId", Collections.singletonMap("memberId", byteBuffer));
        client.prepareResponseFrom((AbstractResponse)leaderResponse, coordinator);
        client.prepareResponseFrom((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.tp0), Errors.NONE), coordinator, true);
        client.prepareResponseFrom((AbstractResponse)new FindCoordinatorResponse(Errors.NONE, node), node);
        client.prepareResponseFrom((AbstractResponse)this.joinGroupFollowerResponse((PartitionAssignor)assignor, 1, "memberId", "leaderId", Errors.NONE), coordinator);
        client.prepareResponseFrom((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.tp0), Errors.NONE), coordinator);
        client.prepareResponseFrom(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                return body instanceof FetchRequest && ((FetchRequest)body).fetchData().containsKey(KafkaConsumerTest.this.tp0);
            }
        }, (AbstractResponse)this.fetchResponse(this.tp0, 1L, 1), node);
        time.sleep(heartbeatIntervalMs);
        Thread.sleep(heartbeatIntervalMs);
        ConsumerRecords records = consumer.poll(0L);
        Assert.assertFalse((boolean)records.isEmpty());
        consumer.close(0L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumerCloseTest(final long closeTimeoutMs, List<? extends AbstractResponse> responses, long waitMs, boolean interrupt) throws Exception {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 5000;
        MockTime time = new MockTime();
        Cluster cluster = TestUtils.singletonCluster("test", 1);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = this.createMetadata();
        metadata.update(cluster, Collections.emptySet(), time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        final KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, false, 1000);
        consumer.subscribe(Arrays.asList("test"), this.getConsumerRebalanceListener(consumer));
        Node coordinator = this.prepareRebalance(client, node, (PartitionAssignor)assignor, Arrays.asList(this.tp0), null);
        client.prepareMetadataUpdate(cluster, Collections.emptySet());
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 0L, 1), node);
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 1L, 0), node);
        consumer.poll(0L);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        final AtomicReference closeException = new AtomicReference();
        try {
            Future<?> future = executor.submit(new Runnable(){

                @Override
                public void run() {
                    consumer.commitAsync();
                    try {
                        consumer.close(closeTimeoutMs, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        closeException.set(e);
                    }
                }
            });
            try {
                future.get(100L, TimeUnit.MILLISECONDS);
                if (closeTimeoutMs != 0L) {
                    Assert.fail((String)"Close completed without waiting for commit or leave response");
                }
            }
            catch (TimeoutException e) {
                // empty catch block
            }
            client.waitForRequests(2, 1000L);
            for (int i = 0; i < responses.size(); ++i) {
                client.waitForRequests(1, 1000L);
                client.respondFrom(responses.get(i), coordinator);
                if (i == responses.size() - 1) continue;
                try {
                    future.get(100L, TimeUnit.MILLISECONDS);
                    Assert.fail((String)"Close completed without waiting for response");
                    continue;
                }
                catch (TimeoutException e) {
                    // empty catch block
                }
            }
            if (waitMs > 0L) {
                time.sleep(waitMs);
            }
            if (interrupt) {
                Assert.assertTrue((String)"Close terminated prematurely", (boolean)future.cancel(true));
            }
            executor.submit(new Runnable(){

                @Override
                public void run() {
                }
            }).get(500L, TimeUnit.MILLISECONDS);
            if (!interrupt) {
                future.get(500L, TimeUnit.MILLISECONDS);
                Assert.assertNull((String)"Unexpected exception during close", closeException.get());
            } else {
                Assert.assertTrue((String)("Expected exception not thrown " + closeException), (boolean)(closeException.get() instanceof InterruptException));
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    private ConsumerRebalanceListener getConsumerRebalanceListener(final KafkaConsumer<String, String> consumer) {
        return new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                for (TopicPartition partition : partitions) {
                    consumer.seek(partition, 0L);
                }
            }
        };
    }

    private Metadata createMetadata() {
        return new Metadata(0L, Long.MAX_VALUE, true);
    }

    private Node prepareRebalance(MockClient client, Node node, final Set<String> subscribedTopics, PartitionAssignor assignor, List<TopicPartition> partitions, Node coordinator) {
        if (coordinator == null) {
            client.prepareResponseFrom((AbstractResponse)new FindCoordinatorResponse(Errors.NONE, node), node);
            coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        }
        client.prepareResponseFrom(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                JoinGroupRequest joinGroupRequest = (JoinGroupRequest)body;
                PartitionAssignor.Subscription subscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)((JoinGroupRequest.ProtocolMetadata)joinGroupRequest.groupProtocols().get(0)).metadata());
                return subscribedTopics.equals(new HashSet(subscription.topics()));
            }
        }, (AbstractResponse)this.joinGroupFollowerResponse(assignor, 1, "memberId", "leaderId", Errors.NONE), coordinator);
        client.prepareResponseFrom((AbstractResponse)this.syncGroupResponse(partitions, Errors.NONE), coordinator);
        return coordinator;
    }

    private Node prepareRebalance(MockClient client, Node node, PartitionAssignor assignor, List<TopicPartition> partitions, Node coordinator) {
        if (coordinator == null) {
            client.prepareResponseFrom((AbstractResponse)new FindCoordinatorResponse(Errors.NONE, node), node);
            coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        }
        client.prepareResponseFrom((AbstractResponse)this.joinGroupFollowerResponse(assignor, 1, "memberId", "leaderId", Errors.NONE), coordinator);
        client.prepareResponseFrom((AbstractResponse)this.syncGroupResponse(partitions, Errors.NONE), coordinator);
        return coordinator;
    }

    private AtomicBoolean prepareHeartbeatResponse(MockClient client, Node coordinator) {
        final AtomicBoolean heartbeatReceived = new AtomicBoolean(false);
        client.prepareResponseFrom(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                heartbeatReceived.set(true);
                return true;
            }
        }, (AbstractResponse)new HeartbeatResponse(Errors.NONE), coordinator);
        return heartbeatReceived;
    }

    private AtomicBoolean prepareOffsetCommitResponse(MockClient client, Node coordinator, final Map<TopicPartition, Long> partitionOffsets) {
        final AtomicBoolean commitReceived = new AtomicBoolean(true);
        HashMap<TopicPartition, Errors> response = new HashMap<TopicPartition, Errors>();
        for (TopicPartition partition : partitionOffsets.keySet()) {
            response.put(partition, Errors.NONE);
        }
        client.prepareResponseFrom(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(AbstractRequest body) {
                OffsetCommitRequest commitRequest = (OffsetCommitRequest)body;
                for (Map.Entry partitionOffset : partitionOffsets.entrySet()) {
                    OffsetCommitRequest.PartitionData partitionData = (OffsetCommitRequest.PartitionData)commitRequest.offsetData().get(partitionOffset.getKey());
                    if (partitionData.offset == (Long)partitionOffset.getValue()) continue;
                    commitReceived.set(false);
                    return false;
                }
                return true;
            }
        }, (AbstractResponse)this.offsetCommitResponse(response), coordinator);
        return commitReceived;
    }

    private AtomicBoolean prepareOffsetCommitResponse(MockClient client, Node coordinator, TopicPartition partition, long offset) {
        return this.prepareOffsetCommitResponse(client, coordinator, Collections.singletonMap(partition, offset));
    }

    private OffsetCommitResponse offsetCommitResponse(Map<TopicPartition, Errors> responseData) {
        return new OffsetCommitResponse(responseData);
    }

    private JoinGroupResponse joinGroupFollowerResponse(PartitionAssignor assignor, int generationId, String memberId, String leaderId, Errors error) {
        return new JoinGroupResponse(error, generationId, assignor.name(), memberId, leaderId, Collections.emptyMap());
    }

    private SyncGroupResponse syncGroupResponse(List<TopicPartition> partitions, Errors error) {
        ByteBuffer buf = ConsumerProtocol.serializeAssignment((PartitionAssignor.Assignment)new PartitionAssignor.Assignment(partitions));
        return new SyncGroupResponse(error, buf);
    }

    private OffsetFetchResponse offsetResponse(Map<TopicPartition, Long> offsets, Errors error) {
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> partitionData = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        for (Map.Entry<TopicPartition, Long> entry : offsets.entrySet()) {
            partitionData.put(entry.getKey(), new OffsetFetchResponse.PartitionData(entry.getValue().longValue(), "", error));
        }
        return new OffsetFetchResponse(Errors.NONE, partitionData);
    }

    private ListOffsetResponse listOffsetsResponse(Map<TopicPartition, Long> offsets, Errors error) {
        HashMap<TopicPartition, ListOffsetResponse.PartitionData> partitionData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
        for (Map.Entry<TopicPartition, Long> partitionOffset : offsets.entrySet()) {
            partitionData.put(partitionOffset.getKey(), new ListOffsetResponse.PartitionData(error, 1L, partitionOffset.getValue().longValue()));
        }
        return new ListOffsetResponse(partitionData);
    }

    private FetchResponse fetchResponse(Map<TopicPartition, FetchInfo> fetches) {
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> tpResponses = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        for (Map.Entry<TopicPartition, FetchInfo> fetchEntry : fetches.entrySet()) {
            MemoryRecords records;
            TopicPartition partition = fetchEntry.getKey();
            long fetchOffset = fetchEntry.getValue().offset;
            int fetchCount = fetchEntry.getValue().count;
            if (fetchCount == 0) {
                records = MemoryRecords.EMPTY;
            } else {
                MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)fetchOffset);
                for (int i = 0; i < fetchCount; ++i) {
                    builder.append(0L, ("key-" + i).getBytes(), ("value-" + i).getBytes());
                }
                records = builder.build();
            }
            tpResponses.put(partition, new FetchResponse.PartitionData(Errors.NONE, 0L, -1L, 0L, null, (Records)records));
        }
        return new FetchResponse(tpResponses, 0);
    }

    private FetchResponse fetchResponse(TopicPartition partition, long fetchOffset, int count) {
        FetchInfo fetchInfo = new FetchInfo(fetchOffset, count);
        return this.fetchResponse(Collections.singletonMap(partition, fetchInfo));
    }

    private KafkaConsumer<String, String> newConsumer(Time time, KafkaClient client, Metadata metadata, PartitionAssignor assignor, int rebalanceTimeoutMs, int sessionTimeoutMs, int heartbeatIntervalMs, boolean autoCommitEnabled, int autoCommitIntervalMs) {
        String clientId = "mock-consumer";
        String groupId = "mock-group";
        String metricGroupPrefix = "consumer";
        long retryBackoffMs = 100L;
        long requestTimeoutMs = 30000L;
        boolean excludeInternalTopics = true;
        int minBytes = 1;
        int maxBytes = Integer.MAX_VALUE;
        int maxWaitMs = 500;
        int fetchSize = 0x100000;
        int maxPollRecords = Integer.MAX_VALUE;
        boolean checkCrcs = true;
        StringDeserializer keyDeserializer = new StringDeserializer();
        StringDeserializer valueDeserializer = new StringDeserializer();
        OffsetResetStrategy autoResetStrategy = OffsetResetStrategy.EARLIEST;
        List<PartitionAssignor> assignors = Arrays.asList(assignor);
        ConsumerInterceptors interceptors = null;
        Metrics metrics = new Metrics();
        ConsumerMetrics metricsRegistry = new ConsumerMetrics(metricGroupPrefix);
        SubscriptionState subscriptions = new SubscriptionState(autoResetStrategy);
        ConsumerNetworkClient consumerClient = new ConsumerNetworkClient(client, metadata, time, retryBackoffMs, requestTimeoutMs);
        ConsumerCoordinator consumerCoordinator = new ConsumerCoordinator(consumerClient, groupId, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, assignors, metadata, subscriptions, metrics, metricGroupPrefix, time, retryBackoffMs, autoCommitEnabled, autoCommitIntervalMs, interceptors, excludeInternalTopics, true);
        Fetcher fetcher = new Fetcher(consumerClient, minBytes, maxBytes, maxWaitMs, fetchSize, maxPollRecords, checkCrcs, (Deserializer)keyDeserializer, (Deserializer)valueDeserializer, metadata, subscriptions, metrics, metricsRegistry.fetcherMetrics, time, retryBackoffMs, IsolationLevel.READ_UNCOMMITTED);
        return new KafkaConsumer(clientId, consumerCoordinator, (Deserializer)keyDeserializer, (Deserializer)valueDeserializer, fetcher, interceptors, time, consumerClient, metrics, subscriptions, metadata, retryBackoffMs, requestTimeoutMs);
    }

    private static class FetchInfo {
        long offset;
        int count;

        FetchInfo(long offset, int count) {
            this.offset = offset;
            this.count = count;
        }
    }
}

