/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.SampleMetrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Count;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Min;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.apache.kafka.common.metrics.stats.SimpleRate;
import org.apache.kafka.common.metrics.stats.Total;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetricsTest {
    private static final double EPS = 1.0E-6;
    private MockTime time = new MockTime();
    private MetricConfig config = new MetricConfig();
    private Metrics metrics;

    @Before
    public void setup() {
        this.metrics = new Metrics(this.config, Arrays.asList(new JmxReporter()), (Time)this.time, true);
    }

    @After
    public void tearDown() {
        this.metrics.close();
    }

    @Test
    public void testMetricName() {
        MetricName n1 = this.metrics.metricName("name", "group", "description", new String[]{"key1", "value1", "key2", "value2"});
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("key1", "value1");
        tags.put("key2", "value2");
        MetricName n2 = this.metrics.metricName("name", "group", "description", tags);
        Assert.assertEquals((String)"metric names created in two different ways should be equal", (Object)n1, (Object)n2);
        try {
            this.metrics.metricName("name", "group", "description", new String[]{"key1"});
            Assert.fail((String)"Creating MetricName with an odd number of keyValue should fail");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleStats() throws Exception {
        ConstantMeasurable measurable = new ConstantMeasurable();
        this.metrics.addMetric(this.metrics.metricName("direct.measurable", "grp1", "The fraction of time an appender waits for space allocation."), (Measurable)measurable);
        Sensor s = this.metrics.sensor("test.sensor");
        s.add(this.metrics.metricName("test.avg", "grp1"), (MeasurableStat)new Avg());
        s.add(this.metrics.metricName("test.max", "grp1"), (MeasurableStat)new Max());
        s.add(this.metrics.metricName("test.min", "grp1"), (MeasurableStat)new Min());
        s.add(this.metrics.metricName("test.rate", "grp1"), (MeasurableStat)new Rate(TimeUnit.SECONDS));
        s.add(this.metrics.metricName("test.occurences", "grp1"), (MeasurableStat)new Rate(TimeUnit.SECONDS, (SampledStat)new Count()));
        s.add(this.metrics.metricName("test.count", "grp1"), (MeasurableStat)new Count());
        s.add((CompoundStat)new Percentiles(100, -100.0, 100.0, Percentiles.BucketSizing.CONSTANT, new Percentile[]{new Percentile(this.metrics.metricName("test.median", "grp1"), 50.0), new Percentile(this.metrics.metricName("test.perc99_9", "grp1"), 99.9)}));
        Sensor s2 = this.metrics.sensor("test.sensor2");
        s2.add(this.metrics.metricName("s2.total", "grp1"), (MeasurableStat)new Total());
        s2.record(5.0);
        int sum = 0;
        int count = 10;
        for (int i = 0; i < count; ++i) {
            s.record((double)i);
            sum += i;
        }
        double elapsedSecs = (double)(this.config.timeWindowMs() * (long)(this.config.samples() - 1)) / 1000.0;
        Assert.assertEquals((String)String.format("Occurrences(0...%d) = %f", count, (double)count / elapsedSecs), (double)((double)count / elapsedSecs), (double)((KafkaMetric)this.metrics.metrics().get(this.metrics.metricName("test.occurences", "grp1"))).value(), (double)1.0E-6);
        long sleepTimeMs = 2L;
        this.time.sleep(sleepTimeMs * 1000L);
        Assert.assertEquals((String)"s2 reflects the constant value", (double)5.0, (double)((KafkaMetric)this.metrics.metrics().get(this.metrics.metricName("s2.total", "grp1"))).value(), (double)1.0E-6);
        Assert.assertEquals((String)"Avg(0...9) = 4.5", (double)4.5, (double)((KafkaMetric)this.metrics.metrics().get(this.metrics.metricName("test.avg", "grp1"))).value(), (double)1.0E-6);
        Assert.assertEquals((String)"Max(0...9) = 9", (double)(count - 1), (double)((KafkaMetric)this.metrics.metrics().get(this.metrics.metricName("test.max", "grp1"))).value(), (double)1.0E-6);
        Assert.assertEquals((String)"Min(0...9) = 0", (double)0.0, (double)((KafkaMetric)this.metrics.metrics().get(this.metrics.metricName("test.min", "grp1"))).value(), (double)1.0E-6);
        Assert.assertEquals((String)"Rate(0...9) = 1.40625", (double)((double)sum / (elapsedSecs += (double)sleepTimeMs)), (double)((KafkaMetric)this.metrics.metrics().get(this.metrics.metricName("test.rate", "grp1"))).value(), (double)1.0E-6);
        Assert.assertEquals((String)String.format("Occurrences(0...%d) = %f", count, (double)count / elapsedSecs), (double)((double)count / elapsedSecs), (double)((KafkaMetric)this.metrics.metrics().get(this.metrics.metricName("test.occurences", "grp1"))).value(), (double)1.0E-6);
        Assert.assertEquals((String)"Count(0...9) = 10", (double)count, (double)((KafkaMetric)this.metrics.metrics().get(this.metrics.metricName("test.count", "grp1"))).value(), (double)1.0E-6);
    }

    @Test
    public void testHierarchicalSensors() {
        Sensor parent1 = this.metrics.sensor("test.parent1");
        parent1.add(this.metrics.metricName("test.parent1.count", "grp1"), (MeasurableStat)new Count());
        Sensor parent2 = this.metrics.sensor("test.parent2");
        parent2.add(this.metrics.metricName("test.parent2.count", "grp1"), (MeasurableStat)new Count());
        Sensor child1 = this.metrics.sensor("test.child1", new Sensor[]{parent1, parent2});
        child1.add(this.metrics.metricName("test.child1.count", "grp1"), (MeasurableStat)new Count());
        Sensor child2 = this.metrics.sensor("test.child2", new Sensor[]{parent1});
        child2.add(this.metrics.metricName("test.child2.count", "grp1"), (MeasurableStat)new Count());
        Sensor grandchild = this.metrics.sensor("test.grandchild", new Sensor[]{child1});
        grandchild.add(this.metrics.metricName("test.grandchild.count", "grp1"), (MeasurableStat)new Count());
        parent1.record();
        parent2.record();
        child1.record();
        child2.record();
        grandchild.record();
        double p1 = ((KafkaMetric)parent1.metrics().get(0)).value();
        double p2 = ((KafkaMetric)parent2.metrics().get(0)).value();
        double c1 = ((KafkaMetric)child1.metrics().get(0)).value();
        double c2 = ((KafkaMetric)child2.metrics().get(0)).value();
        double gc = ((KafkaMetric)grandchild.metrics().get(0)).value();
        Assert.assertEquals((double)1.0, (double)gc, (double)1.0E-6);
        Assert.assertEquals((double)(1.0 + gc), (double)c1, (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)c2, (double)1.0E-6);
        Assert.assertEquals((double)(1.0 + c1), (double)p2, (double)1.0E-6);
        Assert.assertEquals((double)(1.0 + c1 + c2), (double)p1, (double)1.0E-6);
        Assert.assertEquals(Arrays.asList(child1, child2), this.metrics.childrenSensors().get(parent1));
        Assert.assertEquals(Arrays.asList(child1), this.metrics.childrenSensors().get(parent2));
        Assert.assertNull(this.metrics.childrenSensors().get(grandchild));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadSensorHierarchy() {
        Sensor p = this.metrics.sensor("parent");
        Sensor c1 = this.metrics.sensor("child1", new Sensor[]{p});
        Sensor c2 = this.metrics.sensor("child2", new Sensor[]{p});
        this.metrics.sensor("gc", new Sensor[]{c1, c2});
    }

    @Test
    public void testRemoveSensor() {
        int size = this.metrics.metrics().size();
        Sensor parent1 = this.metrics.sensor("test.parent1");
        parent1.add(this.metrics.metricName("test.parent1.count", "grp1"), (MeasurableStat)new Count());
        Sensor parent2 = this.metrics.sensor("test.parent2");
        parent2.add(this.metrics.metricName("test.parent2.count", "grp1"), (MeasurableStat)new Count());
        Sensor child1 = this.metrics.sensor("test.child1", new Sensor[]{parent1, parent2});
        child1.add(this.metrics.metricName("test.child1.count", "grp1"), (MeasurableStat)new Count());
        Sensor child2 = this.metrics.sensor("test.child2", new Sensor[]{parent2});
        child2.add(this.metrics.metricName("test.child2.count", "grp1"), (MeasurableStat)new Count());
        Sensor grandChild1 = this.metrics.sensor("test.gchild2", new Sensor[]{child2});
        grandChild1.add(this.metrics.metricName("test.gchild2.count", "grp1"), (MeasurableStat)new Count());
        Sensor sensor = this.metrics.getSensor("test.parent1");
        Assert.assertNotNull((Object)sensor);
        this.metrics.removeSensor("test.parent1");
        Assert.assertNull((Object)this.metrics.getSensor("test.parent1"));
        Assert.assertNull(this.metrics.metrics().get(this.metrics.metricName("test.parent1.count", "grp1")));
        Assert.assertNull((Object)this.metrics.getSensor("test.child1"));
        Assert.assertNull(this.metrics.childrenSensors().get(sensor));
        Assert.assertNull(this.metrics.metrics().get(this.metrics.metricName("test.child1.count", "grp1")));
        sensor = this.metrics.getSensor("test.gchild2");
        Assert.assertNotNull((Object)sensor);
        this.metrics.removeSensor("test.gchild2");
        Assert.assertNull((Object)this.metrics.getSensor("test.gchild2"));
        Assert.assertNull(this.metrics.childrenSensors().get(sensor));
        Assert.assertNull(this.metrics.metrics().get(this.metrics.metricName("test.gchild2.count", "grp1")));
        sensor = this.metrics.getSensor("test.child2");
        Assert.assertNotNull((Object)sensor);
        this.metrics.removeSensor("test.child2");
        Assert.assertNull((Object)this.metrics.getSensor("test.child2"));
        Assert.assertNull(this.metrics.childrenSensors().get(sensor));
        Assert.assertNull(this.metrics.metrics().get(this.metrics.metricName("test.child2.count", "grp1")));
        sensor = this.metrics.getSensor("test.parent2");
        Assert.assertNotNull((Object)sensor);
        this.metrics.removeSensor("test.parent2");
        Assert.assertNull((Object)this.metrics.getSensor("test.parent2"));
        Assert.assertNull(this.metrics.childrenSensors().get(sensor));
        Assert.assertNull(this.metrics.metrics().get(this.metrics.metricName("test.parent2.count", "grp1")));
        Assert.assertEquals((long)size, (long)this.metrics.metrics().size());
    }

    @Test
    public void testRemoveInactiveMetrics() {
        Sensor s1 = this.metrics.sensor("test.s1", null, 1L, new Sensor[0]);
        s1.add(this.metrics.metricName("test.s1.count", "grp1"), (MeasurableStat)new Count());
        Sensor s2 = this.metrics.sensor("test.s2", null, 3L, new Sensor[0]);
        s2.add(this.metrics.metricName("test.s2.count", "grp1"), (MeasurableStat)new Count());
        Metrics.ExpireSensorTask purger = new Metrics.ExpireSensorTask(this.metrics);
        purger.run();
        Assert.assertNotNull((String)"Sensor test.s1 must be present", (Object)this.metrics.getSensor("test.s1"));
        Assert.assertNotNull((String)"MetricName test.s1.count must be present", this.metrics.metrics().get(this.metrics.metricName("test.s1.count", "grp1")));
        Assert.assertNotNull((String)"Sensor test.s2 must be present", (Object)this.metrics.getSensor("test.s2"));
        Assert.assertNotNull((String)"MetricName test.s2.count must be present", this.metrics.metrics().get(this.metrics.metricName("test.s2.count", "grp1")));
        this.time.sleep(1001L);
        purger.run();
        Assert.assertNull((String)"Sensor test.s1 should have been purged", (Object)this.metrics.getSensor("test.s1"));
        Assert.assertNull((String)"MetricName test.s1.count should have been purged", this.metrics.metrics().get(this.metrics.metricName("test.s1.count", "grp1")));
        Assert.assertNotNull((String)"Sensor test.s2 must be present", (Object)this.metrics.getSensor("test.s2"));
        Assert.assertNotNull((String)"MetricName test.s2.count must be present", this.metrics.metrics().get(this.metrics.metricName("test.s2.count", "grp1")));
        s2.record();
        this.time.sleep(2000L);
        purger.run();
        Assert.assertNotNull((String)"Sensor test.s2 must be present", (Object)this.metrics.getSensor("test.s2"));
        Assert.assertNotNull((String)"MetricName test.s2.count must be present", this.metrics.metrics().get(this.metrics.metricName("test.s2.count", "grp1")));
        this.time.sleep(1000L);
        purger.run();
        Assert.assertNull((String)"Sensor test.s2 should have been purged", (Object)this.metrics.getSensor("test.s1"));
        Assert.assertNull((String)"MetricName test.s2.count should have been purged", this.metrics.metrics().get(this.metrics.metricName("test.s1.count", "grp1")));
        s1 = this.metrics.sensor("test.s1", null, 1L, new Sensor[0]);
        s1.add(this.metrics.metricName("test.s1.count", "grp1"), (MeasurableStat)new Count());
        Assert.assertNotNull((String)"Sensor test.s1 must be present", (Object)this.metrics.getSensor("test.s1"));
        Assert.assertNotNull((String)"MetricName test.s1.count must be present", this.metrics.metrics().get(this.metrics.metricName("test.s1.count", "grp1")));
    }

    @Test
    public void testRemoveMetric() {
        int size = this.metrics.metrics().size();
        this.metrics.addMetric(this.metrics.metricName("test1", "grp1"), (Measurable)new Count());
        this.metrics.addMetric(this.metrics.metricName("test2", "grp1"), (Measurable)new Count());
        Assert.assertNotNull((Object)this.metrics.removeMetric(this.metrics.metricName("test1", "grp1")));
        Assert.assertNull(this.metrics.metrics().get(this.metrics.metricName("test1", "grp1")));
        Assert.assertNotNull(this.metrics.metrics().get(this.metrics.metricName("test2", "grp1")));
        Assert.assertNotNull((Object)this.metrics.removeMetric(this.metrics.metricName("test2", "grp1")));
        Assert.assertNull(this.metrics.metrics().get(this.metrics.metricName("test2", "grp1")));
        Assert.assertEquals((long)size, (long)this.metrics.metrics().size());
    }

    @Test
    public void testEventWindowing() {
        Count count = new Count();
        MetricConfig config = new MetricConfig().eventWindow(1L).samples(2);
        count.record(config, 1.0, this.time.milliseconds());
        count.record(config, 1.0, this.time.milliseconds());
        Assert.assertEquals((double)2.0, (double)count.measure(config, this.time.milliseconds()), (double)1.0E-6);
        count.record(config, 1.0, this.time.milliseconds());
        Assert.assertEquals((double)2.0, (double)count.measure(config, this.time.milliseconds()), (double)1.0E-6);
    }

    @Test
    public void testTimeWindowing() {
        Count count = new Count();
        MetricConfig config = new MetricConfig().timeWindow(1L, TimeUnit.MILLISECONDS).samples(2);
        count.record(config, 1.0, this.time.milliseconds());
        this.time.sleep(1L);
        count.record(config, 1.0, this.time.milliseconds());
        Assert.assertEquals((double)2.0, (double)count.measure(config, this.time.milliseconds()), (double)1.0E-6);
        this.time.sleep(1L);
        count.record(config, 1.0, this.time.milliseconds());
        Assert.assertEquals((double)2.0, (double)count.measure(config, this.time.milliseconds()), (double)1.0E-6);
    }

    @Test
    public void testOldDataHasNoEffect() {
        Max max = new Max();
        long windowMs = 100L;
        int samples = 2;
        MetricConfig config = new MetricConfig().timeWindow(windowMs, TimeUnit.MILLISECONDS).samples(samples);
        max.record(config, 50.0, this.time.milliseconds());
        this.time.sleep((long)samples * windowMs);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)max.measure(config, this.time.milliseconds()), (double)1.0E-6);
    }

    @Test
    public void testSampledStatInitialValue() {
        Max max = new Max();
        Min min = new Min();
        Avg avg = new Avg();
        Count count = new Count();
        Rate.SampledTotal sampledTotal = new Rate.SampledTotal();
        long windowMs = 100L;
        int samples = 2;
        MetricConfig config = new MetricConfig().timeWindow(windowMs, TimeUnit.MILLISECONDS).samples(samples);
        max.record(config, 50.0, this.time.milliseconds());
        min.record(config, 50.0, this.time.milliseconds());
        avg.record(config, 50.0, this.time.milliseconds());
        count.record(config, 50.0, this.time.milliseconds());
        sampledTotal.record(config, 50.0, this.time.milliseconds());
        this.time.sleep((long)samples * windowMs);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)max.measure(config, this.time.milliseconds()), (double)1.0E-6);
        Assert.assertEquals((double)Double.MAX_VALUE, (double)min.measure(config, this.time.milliseconds()), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)avg.measure(config, this.time.milliseconds()), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)count.measure(config, this.time.milliseconds()), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)sampledTotal.measure(config, this.time.milliseconds()), (double)1.0E-6);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDuplicateMetricName() {
        this.metrics.sensor("test").add(this.metrics.metricName("test", "grp1"), (MeasurableStat)new Avg());
        this.metrics.sensor("test2").add(this.metrics.metricName("test", "grp1"), (MeasurableStat)new Total());
    }

    @Test
    public void testQuotas() {
        Sensor sensor = this.metrics.sensor("test");
        sensor.add(this.metrics.metricName("test1.total", "grp1"), (MeasurableStat)new Total(), new MetricConfig().quota(Quota.upperBound((double)5.0)));
        sensor.add(this.metrics.metricName("test2.total", "grp1"), (MeasurableStat)new Total(), new MetricConfig().quota(Quota.lowerBound((double)0.0)));
        sensor.record(5.0);
        try {
            sensor.record(1.0);
            Assert.fail((String)"Should have gotten a quota violation.");
        }
        catch (QuotaViolationException e) {
            // empty catch block
        }
        Assert.assertEquals((double)6.0, (double)((KafkaMetric)this.metrics.metrics().get(this.metrics.metricName("test1.total", "grp1"))).value(), (double)1.0E-6);
        sensor.record(-6.0);
        try {
            sensor.record(-1.0);
            Assert.fail((String)"Should have gotten a quota violation.");
        }
        catch (QuotaViolationException quotaViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testQuotasEquality() {
        Quota quota1 = Quota.upperBound((double)10.5);
        Quota quota2 = Quota.lowerBound((double)10.5);
        Assert.assertFalse((String)"Quota with different upper values shouldn't be equal", (boolean)quota1.equals((Object)quota2));
        Quota quota3 = Quota.lowerBound((double)10.5);
        Assert.assertTrue((String)"Quota with same upper and bound values should be equal", (boolean)quota2.equals((Object)quota3));
    }

    @Test
    public void testPercentiles() {
        int i;
        int buckets = 100;
        Percentiles percs = new Percentiles(4 * buckets, 0.0, 100.0, Percentiles.BucketSizing.CONSTANT, new Percentile[]{new Percentile(this.metrics.metricName("test.p25", "grp1"), 25.0), new Percentile(this.metrics.metricName("test.p50", "grp1"), 50.0), new Percentile(this.metrics.metricName("test.p75", "grp1"), 75.0)});
        MetricConfig config = new MetricConfig().eventWindow(50L).samples(2);
        Sensor sensor = this.metrics.sensor("test", config, new Sensor[0]);
        sensor.add((CompoundStat)percs);
        Metric p25 = (Metric)this.metrics.metrics().get(this.metrics.metricName("test.p25", "grp1"));
        Metric p50 = (Metric)this.metrics.metrics().get(this.metrics.metricName("test.p50", "grp1"));
        Metric p75 = (Metric)this.metrics.metrics().get(this.metrics.metricName("test.p75", "grp1"));
        for (i = 0; i < buckets; ++i) {
            sensor.record((double)i);
        }
        Assert.assertEquals((double)25.0, (double)p25.value(), (double)1.0);
        Assert.assertEquals((double)50.0, (double)p50.value(), (double)1.0);
        Assert.assertEquals((double)75.0, (double)p75.value(), (double)1.0);
        for (i = 0; i < buckets; ++i) {
            sensor.record(0.0);
        }
        Assert.assertEquals((double)0.0, (double)p25.value(), (double)1.0);
        Assert.assertEquals((double)0.0, (double)p50.value(), (double)1.0);
        Assert.assertEquals((double)0.0, (double)p75.value(), (double)1.0);
        for (i = 0; i < buckets; ++i) {
            sensor.record((double)i);
        }
        Assert.assertEquals((double)25.0, (double)p25.value(), (double)1.0);
        Assert.assertEquals((double)50.0, (double)p50.value(), (double)1.0);
        Assert.assertEquals((double)75.0, (double)p75.value(), (double)1.0);
    }

    @Test
    public void testRateWindowing() throws Exception {
        MetricConfig cfg = new MetricConfig().samples(3);
        Sensor s = this.metrics.sensor("test.sensor", cfg, new Sensor[0]);
        s.add(this.metrics.metricName("test.rate", "grp1"), (MeasurableStat)new Rate(TimeUnit.SECONDS));
        int sum = 0;
        int count = cfg.samples() - 1;
        for (int i = 0; i < count; ++i) {
            s.record(100.0);
            sum += 100;
            this.time.sleep(cfg.timeWindowMs());
        }
        this.time.sleep(cfg.timeWindowMs() / 2L);
        double elapsedSecs = (double)(cfg.timeWindowMs() * (long)(cfg.samples() - 1) + cfg.timeWindowMs() / 2L) / 1000.0;
        KafkaMetric km = (KafkaMetric)this.metrics.metrics().get(this.metrics.metricName("test.rate", "grp1"));
        Assert.assertEquals((String)"Rate(0...2) = 2.666", (double)((double)sum / elapsedSecs), (double)km.value(), (double)1.0E-6);
        Assert.assertEquals((String)"Elapsed Time = 75 seconds", (double)elapsedSecs, (double)(((Rate)km.measurable()).windowSize(cfg, this.time.milliseconds()) / 1000L), (double)1.0E-6);
    }

    @Test
    public void testSimpleRate() {
        SimpleRate rate = new SimpleRate();
        MetricConfig config = new MetricConfig().timeWindow(1L, TimeUnit.SECONDS).samples(10);
        this.record((Rate)rate, config, 1000);
        Assert.assertEquals((double)1000.0, (double)this.measure((Measurable)rate, config), (double)0.0);
        this.time.sleep(100L);
        Assert.assertEquals((double)1000.0, (double)this.measure((Measurable)rate, config), (double)0.0);
        this.time.sleep(100L);
        Assert.assertEquals((double)1000.0, (double)this.measure((Measurable)rate, config), (double)0.0);
        this.time.sleep(200L);
        Assert.assertEquals((double)1000.0, (double)this.measure((Measurable)rate, config), (double)0.0);
        this.time.sleep(600L);
        Assert.assertEquals((double)1000.0, (double)this.measure((Measurable)rate, config), (double)0.0);
        this.time.sleep(200L);
        Assert.assertEquals((double)833.3333333333334, (double)this.measure((Measurable)rate, config), (double)0.0);
        this.time.sleep(200L);
        Assert.assertEquals((double)714.2857142857143, (double)this.measure((Measurable)rate, config), (double)0.0);
        this.record((Rate)rate, config, 1000);
        Assert.assertEquals((double)1428.5714285714287, (double)this.measure((Measurable)rate, config), (double)0.0);
        this.time.sleep(1100L);
        Assert.assertEquals((double)800.0, (double)this.measure((Measurable)rate, config), (double)0.0);
        this.record((Rate)rate, config, 1000);
        Assert.assertEquals((double)1200.0, (double)this.measure((Measurable)rate, config), (double)0.0);
        this.time.sleep(6500L);
        Assert.assertEquals((double)333.0, (double)this.measure((Measurable)rate, config), (double)1.0);
        this.record((Rate)rate, config, 1000);
        Assert.assertEquals((double)444.0, (double)this.measure((Measurable)rate, config), (double)1.0);
        this.time.sleep(1500L);
        Assert.assertEquals((double)329.6703296703297, (double)this.measure((Measurable)rate, config), (double)1.0);
        this.record((Rate)rate, config, 1000);
        Assert.assertEquals((double)439.5604395604396, (double)this.measure((Measurable)rate, config), (double)1.0);
    }

    private void record(Rate rate, MetricConfig config, int value) {
        rate.record(config, (double)value, this.time.milliseconds());
    }

    private Double measure(Measurable rate, MetricConfig config) {
        return rate.measure(config, this.time.milliseconds());
    }

    @Test
    public void testMetricInstances() {
        MetricName n1 = this.metrics.metricInstance(SampleMetrics.METRIC1, new String[]{"key1", "value1", "key2", "value2"});
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("key1", "value1");
        tags.put("key2", "value2");
        MetricName n2 = this.metrics.metricInstance(SampleMetrics.METRIC2, tags);
        Assert.assertEquals((String)"metric names created in two different ways should be equal", (Object)n1, (Object)n2);
        try {
            this.metrics.metricInstance(SampleMetrics.METRIC1, new String[]{"key1"});
            Assert.fail((String)"Creating MetricName with an odd number of keyValue should fail");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        HashMap<String, String> parentTagsWithValues = new HashMap<String, String>();
        parentTagsWithValues.put("parent-tag", "parent-tag-value");
        HashMap<String, String> childTagsWithValues = new HashMap<String, String>();
        childTagsWithValues.put("child-tag", "child-tag-value");
        try (Metrics inherited = new Metrics(new MetricConfig().tags(parentTagsWithValues), Arrays.asList(new JmxReporter()), (Time)this.time, true);){
            MetricName inheritedMetric = inherited.metricInstance(SampleMetrics.METRIC_WITH_INHERITED_TAGS, childTagsWithValues);
            Map filledOutTags = inheritedMetric.tags();
            Assert.assertEquals((String)"parent-tag should be set properly", filledOutTags.get("parent-tag"), (Object)"parent-tag-value");
            Assert.assertEquals((String)"child-tag should be set properly", filledOutTags.get("child-tag"), (Object)"child-tag-value");
            try {
                inherited.metricInstance(SampleMetrics.METRIC_WITH_INHERITED_TAGS, parentTagsWithValues);
                Assert.fail((String)"Creating MetricName should fail if the child metrics are not defined at runtime");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                HashMap<String, String> runtimeTags = new HashMap<String, String>();
                runtimeTags.put("child-tag", "child-tag-value");
                runtimeTags.put("tag-not-in-template", "unexpected-value");
                inherited.metricInstance(SampleMetrics.METRIC_WITH_INHERITED_TAGS, runtimeTags);
                Assert.fail((String)"Creating MetricName should fail if there is a tag at runtime that is not in the template");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
    }

    public static class ConstantMeasurable
    implements Measurable {
        public double value = 0.0;

        public double measure(MetricConfig config, long now) {
            return this.value;
        }
    }
}

