/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Protocol;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.junit.Assert;
import org.junit.Test;

public class ApiKeysTest {
    @Test(expected=IllegalArgumentException.class)
    public void testForIdWithInvalidIdLow() {
        ApiKeys.forId((int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testForIdWithInvalidIdHigh() {
        ApiKeys.forId((int)10000);
    }

    @Test(expected=IllegalArgumentException.class)
    public void schemaVersionOutOfRange() {
        ApiKeys.PRODUCE.requestSchema((short)Protocol.REQUESTS[ApiKeys.PRODUCE.id].length);
    }

    @Test
    public void testResponseThrottleTime() {
        List<ApiKeys> authenticationKeys = Arrays.asList(ApiKeys.SASL_HANDSHAKE);
        for (ApiKeys apiKey : ApiKeys.values()) {
            Schema responseSchema = apiKey.responseSchema(apiKey.latestVersion());
            Field throttleTimeField = responseSchema.get("throttle_time_ms");
            if (apiKey.clusterAction || authenticationKeys.contains(apiKey)) {
                Assert.assertNull((String)("Unexpected throttle time field: " + apiKey), (Object)throttleTimeField);
                continue;
            }
            Assert.assertNotNull((String)("Throttle time field missing: " + apiKey), (Object)throttleTimeField);
        }
    }
}

