/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import org.apache.kafka.common.errors.IllegalSaslStateException;
import org.apache.kafka.common.network.InvalidReceiveException;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.PrincipalBuilder;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.authenticator.SaslServerAuthenticator;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.security.scram.ScramMechanism;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Test;

public class SaslServerAuthenticatorTest {
    @Test(expected=InvalidReceiveException.class)
    public void testOversizeRequest() throws IOException {
        SaslServerAuthenticator authenticator = this.setupAuthenticator();
        TransportLayer transportLayer = (TransportLayer)EasyMock.mock(TransportLayer.class);
        PrincipalBuilder principalBuilder = null;
        Map<String, List<String>> configs = Collections.singletonMap("sasl.enabled.mechanisms", Collections.singletonList(ScramMechanism.SCRAM_SHA_256.mechanismName()));
        final Capture size = EasyMock.newCapture();
        EasyMock.expect((Object)transportLayer.read((ByteBuffer)EasyMock.capture((Capture)size))).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                ((ByteBuffer)size.getValue()).putInt(524289);
                return 4;
            }
        });
        EasyMock.replay((Object[])new Object[]{transportLayer});
        authenticator.configure(transportLayer, principalBuilder, configs);
        authenticator.authenticate();
    }

    @Test
    public void testUnexpectedRequestType() throws IOException {
        SaslServerAuthenticator authenticator = this.setupAuthenticator();
        TransportLayer transportLayer = (TransportLayer)EasyMock.mock(TransportLayer.class);
        PrincipalBuilder principalBuilder = null;
        Map<String, List<String>> configs = Collections.singletonMap("sasl.enabled.mechanisms", Collections.singletonList(ScramMechanism.SCRAM_SHA_256.mechanismName()));
        RequestHeader header = new RequestHeader(ApiKeys.METADATA.id, 0, "clientId", 13243);
        final Struct headerStruct = header.toStruct();
        final Capture size = EasyMock.newCapture();
        EasyMock.expect((Object)transportLayer.read((ByteBuffer)EasyMock.capture((Capture)size))).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                ((ByteBuffer)size.getValue()).putInt(headerStruct.sizeOf());
                return 4;
            }
        });
        final Capture payload = EasyMock.newCapture();
        EasyMock.expect((Object)transportLayer.read((ByteBuffer)EasyMock.capture((Capture)payload))).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                headerStruct.writeTo((ByteBuffer)payload.getValue());
                return headerStruct.sizeOf();
            }
        });
        EasyMock.replay((Object[])new Object[]{transportLayer});
        authenticator.configure(transportLayer, principalBuilder, configs);
        try {
            authenticator.authenticate();
            Assert.fail((String)"Expected authenticate() to raise an exception");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalSaslStateException));
        }
    }

    private SaslServerAuthenticator setupAuthenticator() throws IOException {
        TestJaasConfig jaasConfig = new TestJaasConfig();
        jaasConfig.addEntry("jaasContext", PlainLoginModule.class.getName(), new HashMap<String, Object>());
        JaasContext jaasContext = new JaasContext("jaasContext", JaasContext.Type.SERVER, (Configuration)jaasConfig);
        Subject subject = new Subject();
        return new SaslServerAuthenticator("node", jaasContext, subject, null, "localhost", new CredentialCache());
    }
}

