/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.scram;

import javax.xml.bind.DatatypeConverter;
import org.apache.kafka.common.security.scram.ScramFormatter;
import org.apache.kafka.common.security.scram.ScramMechanism;
import org.apache.kafka.common.security.scram.ScramMessages;
import org.junit.Assert;
import org.junit.Test;

public class ScramFormatterTest {
    @Test
    public void rfc7677Example() throws Exception {
        ScramFormatter formatter = new ScramFormatter(ScramMechanism.SCRAM_SHA_256);
        String password = "pencil";
        String c1 = "n,,n=user,r=rOprNGfwEbeRWgbNEkqO";
        String s1 = "r=rOprNGfwEbeRWgbNEkqO%hvYDpWUa2RaTCAfuxFIlj)hNlF$k0,s=W22ZaJ0SNY7soEsUEjb6gQ==,i=4096";
        String c2 = "c=biws,r=rOprNGfwEbeRWgbNEkqO%hvYDpWUa2RaTCAfuxFIlj)hNlF$k0,p=dHzbZapWIk4jUhN+Ute9ytag9zjfMHgsqmmiz7AndVQ=";
        String s2 = "v=6rriTRBi23WpRR/wtup+mMhUZUn/dB5nLTJRsjl95G4=";
        ScramMessages.ClientFirstMessage clientFirst = new ScramMessages.ClientFirstMessage(formatter.toBytes(c1));
        ScramMessages.ServerFirstMessage serverFirst = new ScramMessages.ServerFirstMessage(formatter.toBytes(s1));
        ScramMessages.ClientFinalMessage clientFinal = new ScramMessages.ClientFinalMessage(formatter.toBytes(c2));
        ScramMessages.ServerFinalMessage serverFinal = new ScramMessages.ServerFinalMessage(formatter.toBytes(s2));
        String username = clientFirst.saslName();
        Assert.assertEquals((Object)"user", (Object)username);
        String clientNonce = clientFirst.nonce();
        Assert.assertEquals((Object)"rOprNGfwEbeRWgbNEkqO", (Object)clientNonce);
        String serverNonce = serverFirst.nonce().substring(clientNonce.length());
        Assert.assertEquals((Object)"%hvYDpWUa2RaTCAfuxFIlj)hNlF$k0", (Object)serverNonce);
        byte[] salt = serverFirst.salt();
        Assert.assertArrayEquals((byte[])DatatypeConverter.parseBase64Binary((String)"W22ZaJ0SNY7soEsUEjb6gQ=="), (byte[])salt);
        int iterations = serverFirst.iterations();
        Assert.assertEquals((long)4096L, (long)iterations);
        byte[] channelBinding = clientFinal.channelBinding();
        Assert.assertArrayEquals((byte[])DatatypeConverter.parseBase64Binary((String)"biws"), (byte[])channelBinding);
        byte[] serverSignature = serverFinal.serverSignature();
        Assert.assertArrayEquals((byte[])DatatypeConverter.parseBase64Binary((String)"6rriTRBi23WpRR/wtup+mMhUZUn/dB5nLTJRsjl95G4="), (byte[])serverSignature);
        byte[] saltedPassword = formatter.saltedPassword(password, salt, iterations);
        byte[] serverKey = formatter.serverKey(saltedPassword);
        byte[] computedProof = formatter.clientProof(saltedPassword, clientFirst, serverFirst, clientFinal);
        Assert.assertArrayEquals((byte[])clientFinal.proof(), (byte[])computedProof);
        byte[] computedSignature = formatter.serverSignature(serverKey, clientFirst, serverFirst, clientFinal);
        Assert.assertArrayEquals((byte[])serverFinal.serverSignature(), (byte[])computedSignature);
        Assert.assertEquals((long)4096L, (long)ScramMechanism.SCRAM_SHA_256.minIterations());
    }

    @Test
    public void saslName() throws Exception {
        String[] usernames = new String[]{"user1", "123", "1,2", "user=A", "user==B", "user,1", "user 1", ",", "=", ",=", "=="};
        ScramFormatter formatter = new ScramFormatter(ScramMechanism.SCRAM_SHA_256);
        for (String username : usernames) {
            String saslName = formatter.saslName(username);
            Assert.assertEquals((long)-1L, (long)saslName.indexOf(44));
            Assert.assertEquals((long)-1L, (long)saslName.replace("=2C", "").replace("=3D", "").indexOf(61));
            Assert.assertEquals((Object)username, (Object)formatter.username(saslName));
        }
    }
}

