/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.nio.ByteBuffer;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class ByteBufferOutputStreamTest {
    @Test
    public void testExpandByteBufferOnPositionIncrease() throws Exception {
        this.testExpandByteBufferOnPositionIncrease(ByteBuffer.allocate(16));
    }

    @Test
    public void testExpandDirectByteBufferOnPositionIncrease() throws Exception {
        this.testExpandByteBufferOnPositionIncrease(ByteBuffer.allocateDirect(16));
    }

    private void testExpandByteBufferOnPositionIncrease(ByteBuffer initialBuffer) throws Exception {
        ByteBufferOutputStream output = new ByteBufferOutputStream(initialBuffer);
        output.write("hello".getBytes());
        output.position(32);
        Assert.assertEquals((long)32L, (long)output.position());
        Assert.assertEquals((long)0L, (long)initialBuffer.position());
        ByteBuffer buffer = output.buffer();
        Assert.assertEquals((long)32L, (long)buffer.limit());
        buffer.position(0);
        buffer.limit(5);
        byte[] bytes = new byte[5];
        buffer.get(bytes);
        Assert.assertArrayEquals((byte[])"hello".getBytes(), (byte[])bytes);
    }

    @Test
    public void testExpandByteBufferOnWrite() throws Exception {
        this.testExpandByteBufferOnWrite(ByteBuffer.allocate(16));
    }

    @Test
    public void testExpandDirectByteBufferOnWrite() throws Exception {
        this.testExpandByteBufferOnWrite(ByteBuffer.allocateDirect(16));
    }

    private void testExpandByteBufferOnWrite(ByteBuffer initialBuffer) throws Exception {
        ByteBufferOutputStream output = new ByteBufferOutputStream(initialBuffer);
        output.write("hello".getBytes());
        output.write(new byte[27]);
        Assert.assertEquals((long)32L, (long)output.position());
        Assert.assertEquals((long)0L, (long)initialBuffer.position());
        ByteBuffer buffer = output.buffer();
        Assert.assertEquals((long)32L, (long)buffer.limit());
        buffer.position(0);
        buffer.limit(5);
        byte[] bytes = new byte[5];
        buffer.get(bytes);
        Assert.assertArrayEquals((byte[])"hello".getBytes(), (byte[])bytes);
    }

    @Test
    public void testWriteByteBuffer() {
        this.testWriteByteBuffer(ByteBuffer.allocate(16));
    }

    @Test
    public void testWriteDirectByteBuffer() {
        this.testWriteByteBuffer(ByteBuffer.allocateDirect(16));
    }

    private void testWriteByteBuffer(ByteBuffer input) {
        long value = 234239230L;
        input.putLong(value);
        input.flip();
        ByteBufferOutputStream output = new ByteBufferOutputStream(ByteBuffer.allocate(32));
        output.write(input);
        Assert.assertEquals((long)8L, (long)input.position());
        Assert.assertEquals((long)8L, (long)output.position());
        Assert.assertEquals((long)value, (long)output.buffer().getLong(0));
    }
}

