/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class ConsumerRecords {
    private final String topic;
    private final Map<Integer, List<ConsumerRecord>> recordsPerPartition;

    public ConsumerRecords(String topic, Map<Integer, List<ConsumerRecord>> records) {
        this.topic = topic;
        this.recordsPerPartition = records;
    }

    public List<ConsumerRecord> records(int ... partitions) {
        ArrayList<ConsumerRecord> recordsToReturn = new ArrayList<ConsumerRecord>();
        if (partitions.length == 0) {
            for (Map.Entry<Integer, List<ConsumerRecord>> record : this.recordsPerPartition.entrySet()) {
                recordsToReturn.addAll((Collection<ConsumerRecord>)record.getValue());
            }
        } else {
            for (int partition : partitions) {
                List<ConsumerRecord> recordsForThisPartition = this.recordsPerPartition.get(partition);
                recordsToReturn.addAll(recordsForThisPartition);
            }
        }
        return recordsToReturn;
    }

    public String topic() {
        return this.topic;
    }
}

