/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.TopicPartition;

public class MockConsumer
implements Consumer {
    private final Set<TopicPartition> subscribedPartitions = new HashSet<TopicPartition>();
    private final Set<String> subscribedTopics = new HashSet<String>();
    private final Map<TopicPartition, Long> committedOffsets = new HashMap<TopicPartition, Long>();
    private final Map<TopicPartition, Long> consumedOffsets = new HashMap<TopicPartition, Long>();

    @Override
    public void subscribe(String ... topics) {
        if (this.subscribedPartitions.size() > 0) {
            throw new IllegalStateException("Subcription to topics and partitions is mutually exclusive");
        }
        for (String topic : topics) {
            this.subscribedTopics.add(topic);
        }
    }

    @Override
    public void subscribe(TopicPartition ... partitions) {
        if (this.subscribedTopics.size() > 0) {
            throw new IllegalStateException("Subcription to topics and partitions is mutually exclusive");
        }
        for (TopicPartition partition : partitions) {
            this.subscribedPartitions.add(partition);
            this.consumedOffsets.put(partition, 0L);
        }
    }

    @Override
    public void unsubscribe(String ... topics) {
        for (String topic : topics) {
            if (!this.subscribedTopics.contains(topic)) {
                throw new IllegalStateException("Topic " + topic + " was never subscribed to. subscribe(" + topic + ") should be called prior" + " to unsubscribe(" + topic + ")");
            }
            this.subscribedTopics.remove(topic);
        }
    }

    @Override
    public void unsubscribe(TopicPartition ... partitions) {
        for (TopicPartition partition : partitions) {
            if (!this.subscribedPartitions.contains(partition)) {
                throw new IllegalStateException("Partition " + partition + " was never subscribed to. subscribe(new TopicPartition(" + partition.topic() + "," + partition.partition() + ") should be called prior" + " to unsubscribe(new TopicPartition(" + partition.topic() + "," + partition.partition() + ")");
            }
            this.subscribedPartitions.remove(partition);
            this.committedOffsets.remove(partition);
            this.consumedOffsets.remove(partition);
        }
    }

    @Override
    public Map<String, ConsumerRecords> poll(long timeout) {
        HashMap<String, ArrayList<ConsumerRecord>> records = new HashMap<String, ArrayList<ConsumerRecord>>();
        HashMap<String, ConsumerRecords> recordMetadata = new HashMap<String, ConsumerRecords>();
        for (TopicPartition topicPartition : this.subscribedPartitions) {
            long messageSequence = this.consumedOffsets.get(topicPartition);
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream outputStream = new ObjectOutputStream(byteStream);
                outputStream.writeLong(messageSequence++);
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ArrayList<ConsumerRecord> recordsForTopic = (ArrayList<ConsumerRecord>)records.get(topicPartition.topic());
            if (recordsForTopic == null) {
                recordsForTopic = new ArrayList<ConsumerRecord>();
                records.put(topicPartition.topic(), recordsForTopic);
            }
            recordsForTopic.add(new ConsumerRecord(topicPartition.topic(), topicPartition.partition(), null, byteStream.toByteArray(), messageSequence));
            this.consumedOffsets.put(topicPartition, messageSequence);
        }
        for (Map.Entry entry : records.entrySet()) {
            HashMap<Integer, List<ConsumerRecord>> recordsPerPartition = new HashMap<Integer, List<ConsumerRecord>>();
            for (ConsumerRecord record : (List)entry.getValue()) {
                ArrayList<ConsumerRecord> recordsForThisPartition = (ArrayList<ConsumerRecord>)recordsPerPartition.get(record.partition());
                if (recordsForThisPartition == null) {
                    recordsForThisPartition = new ArrayList<ConsumerRecord>();
                    recordsPerPartition.put(record.partition(), recordsForThisPartition);
                }
                recordsForThisPartition.add(record);
            }
            recordMetadata.put((String)entry.getKey(), new ConsumerRecords((String)entry.getKey(), recordsPerPartition));
        }
        return recordMetadata;
    }

    @Override
    public OffsetMetadata commit(Map<TopicPartition, Long> offsets, boolean sync) {
        if (!sync) {
            return null;
        }
        for (Map.Entry<TopicPartition, Long> partitionOffset : offsets.entrySet()) {
            this.committedOffsets.put(partitionOffset.getKey(), partitionOffset.getValue());
        }
        return new OffsetMetadata(this.committedOffsets, null);
    }

    @Override
    public OffsetMetadata commit(boolean sync) {
        if (!sync) {
            return null;
        }
        return this.commit(this.consumedOffsets, sync);
    }

    @Override
    public void seek(Map<TopicPartition, Long> offsets) {
        for (Map.Entry<TopicPartition, Long> partitionOffset : offsets.entrySet()) {
            this.consumedOffsets.put(partitionOffset.getKey(), partitionOffset.getValue());
        }
    }

    @Override
    public Map<TopicPartition, Long> committed(Collection<TopicPartition> partitions) {
        HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
        for (TopicPartition partition : partitions) {
            offsets.put(new TopicPartition(partition.topic(), partition.partition()), this.committedOffsets.get(partition));
        }
        return offsets;
    }

    @Override
    public Map<TopicPartition, Long> position(Collection<TopicPartition> partitions) {
        HashMap<TopicPartition, Long> positions = new HashMap<TopicPartition, Long>();
        for (TopicPartition partition : partitions) {
            positions.put(partition, this.consumedOffsets.get(partition));
        }
        return positions;
    }

    @Override
    public Map<TopicPartition, Long> offsetsBeforeTime(long timestamp, Collection<TopicPartition> partitions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, ? extends Metric> metrics() {
        return null;
    }

    @Override
    public void close() {
        TopicPartition[] allPartitions = new TopicPartition[this.subscribedPartitions.size()];
        this.unsubscribe(this.subscribedPartitions.toArray(allPartitions));
    }
}

