/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.utils.Utils;

public class Partitioner {
    private final AtomicInteger counter = new AtomicInteger(new Random().nextInt());

    public int partition(ProducerRecord record, Cluster cluster) {
        List<PartitionInfo> partitions = cluster.partitionsForTopic(record.topic());
        int numPartitions = partitions.size();
        if (record.partition() != null) {
            if (record.partition() < 0 || record.partition() >= numPartitions) {
                throw new IllegalArgumentException("Invalid partition given with record: " + record.partition() + " is not in the range [0..." + numPartitions + "].");
            }
            return record.partition();
        }
        if (record.key() == null) {
            for (int i = 0; i < numPartitions; ++i) {
                int partition = Utils.abs(this.counter.getAndIncrement()) % numPartitions;
                if (partitions.get(partition).leader() == null) continue;
                return partition;
            }
            return Utils.abs(this.counter.getAndIncrement()) % numPartitions;
        }
        return Utils.abs(Utils.murmur2(record.key())) % numPartitions;
    }
}

