/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import org.apache.kafka.clients.producer.internals.Metadata;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class MetadataTest {
    private long refreshBackoffMs = 100L;
    private long metadataExpireMs = 1000L;
    private Metadata metadata = new Metadata(this.refreshBackoffMs, this.metadataExpireMs);

    @Test
    public void testMetadata() throws Exception {
        long time = 0L;
        this.metadata.update(Cluster.empty(), time);
        Assert.assertFalse((String)"No update needed.", (this.metadata.timeToNextUpdate(time) == 0L ? 1 : 0) != 0);
        this.metadata.requestUpdate();
        Assert.assertFalse((String)"Still no updated needed due to backoff", (this.metadata.timeToNextUpdate(time) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Update needed now that backoff time expired", (this.metadata.timeToNextUpdate(time += this.refreshBackoffMs) == 0L ? 1 : 0) != 0);
        String topic = "my-topic";
        Thread t1 = this.asyncFetch(topic);
        Thread t2 = this.asyncFetch(topic);
        Assert.assertTrue((String)"Awaiting update", (boolean)t1.isAlive());
        Assert.assertTrue((String)"Awaiting update", (boolean)t2.isAlive());
        this.metadata.update(TestUtils.singletonCluster(topic, 1), time);
        t1.join();
        t2.join();
        Assert.assertFalse((String)"No update needed.", (this.metadata.timeToNextUpdate(time) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Update needed due to stale metadata.", (this.metadata.timeToNextUpdate(time += this.metadataExpireMs) == 0L ? 1 : 0) != 0);
    }

    private Thread asyncFetch(final String topic) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (MetadataTest.this.metadata.fetch().partitionsForTopic(topic) == null) {
                    try {
                        MetadataTest.this.metadata.awaitUpdate(MetadataTest.this.metadata.requestUpdate(), MetadataTest.this.refreshBackoffMs);
                    }
                    catch (TimeoutException timeoutException) {}
                }
            }
        };
        thread.start();
        return thread;
    }
}

