/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.junit.Assert;
import org.junit.Test;

public class MockProducerTest {
    private String topic = "topic";

    @Test
    public void testAutoCompleteMock() throws Exception {
        MockProducer producer = new MockProducer(true);
        ProducerRecord record = new ProducerRecord(this.topic, (Object)"key".getBytes(), (Object)"value".getBytes());
        Future metadata = producer.send(record);
        Assert.assertTrue((String)"Send should be immediately complete", (boolean)metadata.isDone());
        Assert.assertFalse((String)"Send should be successful", (boolean)this.isError(metadata));
        Assert.assertEquals((String)"Offset should be 0", (long)0L, (long)((RecordMetadata)metadata.get()).offset());
        Assert.assertEquals((Object)this.topic, (Object)((RecordMetadata)metadata.get()).topic());
        Assert.assertEquals((String)"We should have the record in our history", Arrays.asList(record), (Object)producer.history());
        producer.clear();
        Assert.assertEquals((String)"Clear should erase our history", (long)0L, (long)producer.history().size());
    }

    @Test
    public void testManualCompletion() throws Exception {
        MockProducer producer = new MockProducer(false);
        ProducerRecord record1 = new ProducerRecord("topic", (Object)"key1".getBytes(), (Object)"value1".getBytes());
        ProducerRecord record2 = new ProducerRecord("topic", (Object)"key2".getBytes(), (Object)"value2".getBytes());
        Future md1 = producer.send(record1);
        Assert.assertFalse((String)"Send shouldn't have completed", (boolean)md1.isDone());
        Future md2 = producer.send(record2);
        Assert.assertFalse((String)"Send shouldn't have completed", (boolean)md2.isDone());
        Assert.assertTrue((String)"Complete the first request", (boolean)producer.completeNext());
        Assert.assertFalse((String)"Requst should be successful", (boolean)this.isError(md1));
        Assert.assertFalse((String)"Second request still incomplete", (boolean)md2.isDone());
        IllegalArgumentException e = new IllegalArgumentException("blah");
        Assert.assertTrue((String)"Complete the second request with an error", (boolean)producer.errorNext((RuntimeException)e));
        try {
            md2.get();
            Assert.fail((String)"Expected error to be thrown");
        }
        catch (ExecutionException err) {
            Assert.assertEquals((Object)e, (Object)err.getCause());
        }
        Assert.assertFalse((String)"No more requests to complete", (boolean)producer.completeNext());
    }

    private boolean isError(Future<?> future) {
        try {
            future.get();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }
}

