/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.producer.internals.RecordAccumulator;
import org.apache.kafka.clients.producer.internals.RecordBatch;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;

public class RecordAccumulatorTest {
    private String topic = "test";
    private int partition1 = 0;
    private int partition2 = 1;
    private int partition3 = 2;
    private Node node1 = new Node(0, "localhost", 1111);
    private Node node2 = new Node(1, "localhost", 1112);
    private TopicPartition tp1 = new TopicPartition(this.topic, this.partition1);
    private TopicPartition tp2 = new TopicPartition(this.topic, this.partition2);
    private TopicPartition tp3 = new TopicPartition(this.topic, this.partition3);
    private PartitionInfo part1 = new PartitionInfo(this.topic, this.partition1, this.node1, null, null);
    private PartitionInfo part2 = new PartitionInfo(this.topic, this.partition2, this.node1, null, null);
    private PartitionInfo part3 = new PartitionInfo(this.topic, this.partition3, this.node2, null, null);
    private MockTime time = new MockTime();
    private byte[] key = "key".getBytes();
    private byte[] value = "value".getBytes();
    private int msgSize = 12 + Record.recordSize((byte[])this.key, (byte[])this.value);
    private Cluster cluster = new Cluster(Arrays.asList(this.node1, this.node2), Arrays.asList(this.part1, this.part2, this.part3));
    private Metrics metrics = new Metrics((Time)this.time);
    String metricGroup = "TestMetrics";
    Map<String, String> metricTags = new LinkedHashMap<String, String>();

    @Test
    public void testFull() throws Exception {
        long now = this.time.milliseconds();
        RecordAccumulator accum = new RecordAccumulator(1024, 10240L, 10L, 100L, false, this.metrics, (Time)this.time, this.metricTags);
        int appends = 1024 / this.msgSize;
        for (int i = 0; i < appends; ++i) {
            accum.append(this.tp1, this.key, this.value, CompressionType.NONE, null);
            Assert.assertEquals((String)"No partitions should be ready.", (long)0L, (long)accum.ready((Cluster)this.cluster, (long)now).readyNodes.size());
        }
        accum.append(this.tp1, this.key, this.value, CompressionType.NONE, null);
        Assert.assertEquals((String)"Our partition's leader should be ready", Collections.singleton(this.node1), (Object)accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes);
        List batches = (List)accum.drain(this.cluster, Collections.singleton(this.node1), Integer.MAX_VALUE, 0L).get(this.node1.id());
        Assert.assertEquals((long)1L, (long)batches.size());
        RecordBatch batch = (RecordBatch)batches.get(0);
        Iterator iter = batch.records.iterator();
        for (int i = 0; i < appends; ++i) {
            LogEntry entry = (LogEntry)iter.next();
            Assert.assertEquals((String)"Keys should match", (Object)ByteBuffer.wrap(this.key), (Object)entry.record().key());
            Assert.assertEquals((String)"Values should match", (Object)ByteBuffer.wrap(this.value), (Object)entry.record().value());
        }
        Assert.assertFalse((String)"No more records", (boolean)iter.hasNext());
    }

    @Test
    public void testAppendLarge() throws Exception {
        int batchSize = 512;
        RecordAccumulator accum = new RecordAccumulator(batchSize, 10240L, 0L, 100L, false, this.metrics, (Time)this.time, this.metricTags);
        accum.append(this.tp1, this.key, new byte[2 * batchSize], CompressionType.NONE, null);
        Assert.assertEquals((String)"Our partition's leader should be ready", Collections.singleton(this.node1), (Object)accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes);
    }

    @Test
    public void testLinger() throws Exception {
        long lingerMs = 10L;
        RecordAccumulator accum = new RecordAccumulator(1024, 10240L, lingerMs, 100L, false, this.metrics, (Time)this.time, this.metricTags);
        accum.append(this.tp1, this.key, this.value, CompressionType.NONE, null);
        Assert.assertEquals((String)"No partitions should be ready", (long)0L, (long)accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes.size());
        this.time.sleep(10L);
        Assert.assertEquals((String)"Our partition's leader should be ready", Collections.singleton(this.node1), (Object)accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes);
        List batches = (List)accum.drain(this.cluster, Collections.singleton(this.node1), Integer.MAX_VALUE, 0L).get(this.node1.id());
        Assert.assertEquals((long)1L, (long)batches.size());
        RecordBatch batch = (RecordBatch)batches.get(0);
        Iterator iter = batch.records.iterator();
        LogEntry entry = (LogEntry)iter.next();
        Assert.assertEquals((String)"Keys should match", (Object)ByteBuffer.wrap(this.key), (Object)entry.record().key());
        Assert.assertEquals((String)"Values should match", (Object)ByteBuffer.wrap(this.value), (Object)entry.record().value());
        Assert.assertFalse((String)"No more records", (boolean)iter.hasNext());
    }

    @Test
    public void testPartialDrain() throws Exception {
        RecordAccumulator accum = new RecordAccumulator(1024, 10240L, 10L, 100L, false, this.metrics, (Time)this.time, this.metricTags);
        int appends = 1024 / this.msgSize + 1;
        List<TopicPartition> partitions = Arrays.asList(this.tp1, this.tp2);
        for (TopicPartition tp : partitions) {
            for (int i = 0; i < appends; ++i) {
                accum.append(tp, this.key, this.value, CompressionType.NONE, null);
            }
        }
        Assert.assertEquals((String)"Partition's leader should be ready", Collections.singleton(this.node1), (Object)accum.ready((Cluster)this.cluster, (long)this.time.milliseconds()).readyNodes);
        List batches = (List)accum.drain(this.cluster, Collections.singleton(this.node1), 1024, 0L).get(this.node1.id());
        Assert.assertEquals((String)"But due to size bound only one partition should have been retrieved", (long)1L, (long)batches.size());
    }

    @Test
    public void testStressfulSituation() throws Exception {
        int numThreads = 5;
        int msgs = 10000;
        int numParts = 2;
        final RecordAccumulator accum = new RecordAccumulator(1024, 10240L, 0L, 100L, true, this.metrics, (Time)this.time, this.metricTags);
        ArrayList<1> threads = new ArrayList<1>();
        for (int i = 0; i < 5; ++i) {
            threads.add(new Thread(){

                @Override
                public void run() {
                    for (int i = 0; i < 10000; ++i) {
                        try {
                            accum.append(new TopicPartition(RecordAccumulatorTest.this.topic, i % 2), RecordAccumulatorTest.this.key, RecordAccumulatorTest.this.value, CompressionType.NONE, null);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        for (Thread thread : threads) {
            thread.start();
        }
        int read = 0;
        long l = this.time.milliseconds();
        while (read < 50000) {
            Set nodes = accum.ready((Cluster)this.cluster, (long)l).readyNodes;
            List list = (List)accum.drain(this.cluster, nodes, 5120, 0L).get(this.node1.id());
            if (list == null) continue;
            for (RecordBatch batch : list) {
                for (LogEntry entry : batch.records) {
                    ++read;
                }
                accum.deallocate(batch);
            }
        }
        for (Thread thread : threads) {
            thread.join();
        }
    }

    @Test
    public void testNextReadyCheckDelay() throws Exception {
        int i;
        long lingerMs = 10L;
        RecordAccumulator accum = new RecordAccumulator(1024, 10240L, lingerMs, 100L, false, this.metrics, (Time)this.time, this.metricTags);
        int appends = 1024 / this.msgSize;
        for (int i2 = 0; i2 < appends; ++i2) {
            accum.append(this.tp1, this.key, this.value, CompressionType.NONE, null);
        }
        RecordAccumulator.ReadyCheckResult result = accum.ready(this.cluster, this.time.milliseconds());
        Assert.assertEquals((String)"No nodes should be ready.", (long)0L, (long)result.readyNodes.size());
        Assert.assertEquals((String)"Next check time should be the linger time", (long)lingerMs, (long)result.nextReadyCheckDelayMs);
        this.time.sleep(lingerMs / 2L);
        for (i = 0; i < appends; ++i) {
            accum.append(this.tp3, this.key, this.value, CompressionType.NONE, null);
        }
        result = accum.ready(this.cluster, this.time.milliseconds());
        Assert.assertEquals((String)"No nodes should be ready.", (long)0L, (long)result.readyNodes.size());
        Assert.assertEquals((String)"Next check time should be defined by node1, half remaining linger time", (long)(lingerMs / 2L), (long)result.nextReadyCheckDelayMs);
        for (i = 0; i < appends + 1; ++i) {
            accum.append(this.tp2, this.key, this.value, CompressionType.NONE, null);
        }
        result = accum.ready(this.cluster, this.time.milliseconds());
        Assert.assertEquals((String)"Node1 should be ready", Collections.singleton(this.node1), (Object)result.readyNodes);
        Assert.assertTrue((String)"Next check time should be defined by node2, at most linger time", (result.nextReadyCheckDelayMs <= lingerMs ? 1 : 0) != 0);
    }
}

