/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.junit.Assert;
import org.junit.Test;

public class AbstractConfigTest {
    @Test
    public void testConfiguredInstances() {
        this.testValidInputs("");
        this.testValidInputs("org.apache.kafka.common.config.AbstractConfigTest$TestMetricsReporter");
        this.testValidInputs("org.apache.kafka.common.config.AbstractConfigTest$TestMetricsReporter,org.apache.kafka.common.config.AbstractConfigTest$TestMetricsReporter");
        this.testInvalidInputs(",");
        this.testInvalidInputs("org.apache.kafka.clients.producer.unknown-metrics-reporter");
        this.testInvalidInputs("test1,test2");
        this.testInvalidInputs("org.apache.kafka.common.config.AbstractConfigTest$TestMetricsReporter,");
    }

    private void testValidInputs(String configValue) {
        Properties props = new Properties();
        props.put("metric.reporters", configValue);
        TestConfig config = new TestConfig(props);
        try {
            config.getConfiguredInstances("metric.reporters", MetricsReporter.class);
        }
        catch (ConfigException e) {
            Assert.fail((String)("No exceptions are expected here, valid props are :" + props));
        }
    }

    private void testInvalidInputs(String configValue) {
        Properties props = new Properties();
        props.put("metric.reporters", configValue);
        TestConfig config = new TestConfig(props);
        try {
            config.getConfiguredInstances("metric.reporters", MetricsReporter.class);
            Assert.fail((String)("Expected a config exception due to invalid props :" + props));
        }
        catch (ConfigException e) {
            // empty catch block
        }
    }

    public static class TestMetricsReporter
    implements MetricsReporter {
        public void configure(Map<String, ?> configs) {
        }

        public void init(List<KafkaMetric> metrics) {
        }

        public void metricChange(KafkaMetric metric) {
        }

        public void close() {
        }
    }

    private static class TestConfig
    extends AbstractConfig {
        private static final ConfigDef config = new ConfigDef().define("metric.reporters", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "A list of classes to use as metrics reporters.");
        public static final String METRIC_REPORTER_CLASSES_CONFIG = "metric.reporters";
        private static final String METRIC_REPORTER_CLASSES_DOC = "A list of classes to use as metrics reporters.";

        public TestConfig(Map<? extends Object, ? extends Object> props) {
            super(config, props);
        }
    }
}

