/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.junit.Assert;
import org.junit.Test;

public class ConfigDefTest {
    @Test
    public void testBasicTypes() {
        ConfigDef def = new ConfigDef().define("a", ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)14), ConfigDef.Importance.HIGH, "docs").define("b", ConfigDef.Type.LONG, ConfigDef.Importance.HIGH, "docs").define("c", ConfigDef.Type.STRING, (Object)"hello", ConfigDef.Importance.HIGH, "docs").define("d", ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "docs").define("e", ConfigDef.Type.DOUBLE, ConfigDef.Importance.HIGH, "docs").define("f", ConfigDef.Type.CLASS, ConfigDef.Importance.HIGH, "docs").define("g", ConfigDef.Type.BOOLEAN, ConfigDef.Importance.HIGH, "docs");
        Properties props = new Properties();
        props.put("a", "1   ");
        props.put("b", (Object)2);
        props.put("d", " a , b, c");
        props.put("e", (Object)42.5);
        props.put("f", String.class.getName());
        props.put("g", "true");
        Map vals = def.parse((Map)props);
        Assert.assertEquals((Object)1, vals.get("a"));
        Assert.assertEquals((Object)2L, vals.get("b"));
        Assert.assertEquals((Object)"hello", vals.get("c"));
        Assert.assertEquals(Arrays.asList("a", "b", "c"), vals.get("d"));
        Assert.assertEquals((Object)42.5, vals.get("e"));
        Assert.assertEquals(String.class, vals.get("f"));
        Assert.assertEquals((Object)true, vals.get("g"));
    }

    @Test(expected=ConfigException.class)
    public void testInvalidDefault() {
        new ConfigDef().define("a", ConfigDef.Type.INT, (Object)"hello", ConfigDef.Importance.HIGH, "docs");
    }

    @Test(expected=ConfigException.class)
    public void testNullDefault() {
        new ConfigDef().define("a", ConfigDef.Type.INT, null, null, null, "docs");
    }

    @Test(expected=ConfigException.class)
    public void testMissingRequired() {
        new ConfigDef().define("a", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs").parse(new HashMap());
    }

    @Test(expected=ConfigException.class)
    public void testDefinedTwice() {
        new ConfigDef().define("a", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "docs").define("a", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs");
    }

    @Test
    public void testBadInputs() {
        this.testBadInputs(ConfigDef.Type.INT, "hello", null, "42.5", 42.5, Long.MAX_VALUE, Long.toString(Long.MAX_VALUE), new Object());
        this.testBadInputs(ConfigDef.Type.LONG, "hello", null, "42.5", Long.toString(Long.MAX_VALUE) + "00", new Object());
        this.testBadInputs(ConfigDef.Type.DOUBLE, "hello", null, new Object());
        this.testBadInputs(ConfigDef.Type.STRING, new Object());
        this.testBadInputs(ConfigDef.Type.LIST, 53, new Object());
    }

    private void testBadInputs(ConfigDef.Type type, Object ... values) {
        for (Object value : values) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("name", value);
            ConfigDef def = new ConfigDef().define("name", type, ConfigDef.Importance.HIGH, "docs");
            try {
                def.parse(m);
                Assert.fail((String)("Expected a config exception on bad input for value " + value));
            }
            catch (ConfigException e) {
                // empty catch block
            }
        }
    }
}

