/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Count;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Min;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.apache.kafka.common.metrics.stats.Total;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;

public class MetricsTest {
    private static double EPS = 1.0E-6;
    MockTime time = new MockTime();
    Metrics metrics = new Metrics(new MetricConfig(), Arrays.asList(new JmxReporter()), (Time)this.time);

    @Test
    public void testMetricName() {
        MetricName n1 = new MetricName("name", "group", "description", new String[]{"key1", "value1"});
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("key1", "value1");
        MetricName n2 = new MetricName("name", "group", "description", tags);
        Assert.assertEquals((String)"metric names created in two different ways should be equal", (Object)n1, (Object)n2);
        try {
            new MetricName("name", "group", "description", new String[]{"key1"});
            Assert.fail((String)"Creating MetricName with an old number of keyValue should fail");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleStats() throws Exception {
        ConstantMeasurable measurable = new ConstantMeasurable();
        this.metrics.addMetric(new MetricName("direct.measurable", "grp1", "The fraction of time an appender waits for space allocation."), (Measurable)measurable);
        Sensor s = this.metrics.sensor("test.sensor");
        s.add(new MetricName("test.avg", "grp1"), (MeasurableStat)new Avg());
        s.add(new MetricName("test.max", "grp1"), (MeasurableStat)new Max());
        s.add(new MetricName("test.min", "grp1"), (MeasurableStat)new Min());
        s.add(new MetricName("test.rate", "grp1"), (MeasurableStat)new Rate(TimeUnit.SECONDS));
        s.add(new MetricName("test.occurences", "grp1"), (MeasurableStat)new Rate(TimeUnit.SECONDS, (SampledStat)new Count()));
        s.add(new MetricName("test.count", "grp1"), (MeasurableStat)new Count());
        s.add((CompoundStat)new Percentiles(100, -100.0, 100.0, Percentiles.BucketSizing.CONSTANT, new Percentile[]{new Percentile(new MetricName("test.median", "grp1"), 50.0), new Percentile(new MetricName("test.perc99_9", "grp1"), 99.9)}));
        Sensor s2 = this.metrics.sensor("test.sensor2");
        s2.add(new MetricName("s2.total", "grp1"), (MeasurableStat)new Total());
        s2.record(5.0);
        for (int i = 0; i < 10; ++i) {
            s.record((double)i);
        }
        this.time.sleep(2000L);
        Assert.assertEquals((String)"s2 reflects the constant value", (double)5.0, (double)((KafkaMetric)this.metrics.metrics().get(new MetricName("s2.total", "grp1"))).value(), (double)EPS);
        Assert.assertEquals((String)"Avg(0...9) = 4.5", (double)4.5, (double)((KafkaMetric)this.metrics.metrics().get(new MetricName("test.avg", "grp1"))).value(), (double)EPS);
        Assert.assertEquals((String)"Max(0...9) = 9", (double)9.0, (double)((KafkaMetric)this.metrics.metrics().get(new MetricName("test.max", "grp1"))).value(), (double)EPS);
        Assert.assertEquals((String)"Min(0...9) = 0", (double)0.0, (double)((KafkaMetric)this.metrics.metrics().get(new MetricName("test.min", "grp1"))).value(), (double)EPS);
        Assert.assertEquals((String)"Rate(0...9) = 22.5", (double)22.5, (double)((KafkaMetric)this.metrics.metrics().get(new MetricName("test.rate", "grp1"))).value(), (double)EPS);
        Assert.assertEquals((String)"Occurences(0...9) = 5", (double)5.0, (double)((KafkaMetric)this.metrics.metrics().get(new MetricName("test.occurences", "grp1"))).value(), (double)EPS);
        Assert.assertEquals((String)"Count(0...9) = 10", (double)10.0, (double)((KafkaMetric)this.metrics.metrics().get(new MetricName("test.count", "grp1"))).value(), (double)EPS);
    }

    @Test
    public void testHierarchicalSensors() {
        Sensor parent1 = this.metrics.sensor("test.parent1");
        parent1.add(new MetricName("test.parent1.count", "grp1"), (MeasurableStat)new Count());
        Sensor parent2 = this.metrics.sensor("test.parent2");
        parent2.add(new MetricName("test.parent2.count", "grp1"), (MeasurableStat)new Count());
        Sensor child1 = this.metrics.sensor("test.child1", new Sensor[]{parent1, parent2});
        child1.add(new MetricName("test.child1.count", "grp1"), (MeasurableStat)new Count());
        Sensor child2 = this.metrics.sensor("test.child2", new Sensor[]{parent1});
        child2.add(new MetricName("test.child2.count", "grp1"), (MeasurableStat)new Count());
        Sensor grandchild = this.metrics.sensor("test.grandchild", new Sensor[]{child1});
        grandchild.add(new MetricName("test.grandchild.count", "grp1"), (MeasurableStat)new Count());
        parent1.record();
        parent2.record();
        child1.record();
        child2.record();
        grandchild.record();
        double p1 = ((KafkaMetric)parent1.metrics().get(0)).value();
        double p2 = ((KafkaMetric)parent2.metrics().get(0)).value();
        double c1 = ((KafkaMetric)child1.metrics().get(0)).value();
        double c2 = ((KafkaMetric)child2.metrics().get(0)).value();
        double gc = ((KafkaMetric)grandchild.metrics().get(0)).value();
        Assert.assertEquals((double)1.0, (double)gc, (double)EPS);
        Assert.assertEquals((double)(1.0 + gc), (double)((KafkaMetric)child1.metrics().get(0)).value(), (double)EPS);
        Assert.assertEquals((double)1.0, (double)c2, (double)EPS);
        Assert.assertEquals((double)(1.0 + c1), (double)p2, (double)EPS);
        Assert.assertEquals((double)(1.0 + c1 + c2), (double)p1, (double)EPS);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadSensorHiearchy() {
        Sensor p = this.metrics.sensor("parent");
        Sensor c1 = this.metrics.sensor("child1", new Sensor[]{p});
        Sensor c2 = this.metrics.sensor("child2", new Sensor[]{p});
        this.metrics.sensor("gc", new Sensor[]{c1, c2});
    }

    @Test
    public void testEventWindowing() {
        Count count = new Count();
        MetricConfig config = new MetricConfig().eventWindow(1L).samples(2);
        count.record(config, 1.0, this.time.milliseconds());
        count.record(config, 1.0, this.time.milliseconds());
        Assert.assertEquals((double)2.0, (double)count.measure(config, this.time.milliseconds()), (double)EPS);
        count.record(config, 1.0, this.time.milliseconds());
        Assert.assertEquals((double)2.0, (double)count.measure(config, this.time.milliseconds()), (double)EPS);
    }

    @Test
    public void testTimeWindowing() {
        Count count = new Count();
        MetricConfig config = new MetricConfig().timeWindow(1L, TimeUnit.MILLISECONDS).samples(2);
        count.record(config, 1.0, this.time.milliseconds());
        this.time.sleep(1L);
        count.record(config, 1.0, this.time.milliseconds());
        Assert.assertEquals((double)2.0, (double)count.measure(config, this.time.milliseconds()), (double)EPS);
        this.time.sleep(1L);
        count.record(config, 1.0, this.time.milliseconds());
        Assert.assertEquals((double)2.0, (double)count.measure(config, this.time.milliseconds()), (double)EPS);
    }

    @Test
    public void testOldDataHasNoEffect() {
        Max max = new Max();
        long windowMs = 100L;
        int samples = 2;
        MetricConfig config = new MetricConfig().timeWindow(windowMs, TimeUnit.MILLISECONDS).samples(samples);
        max.record(config, 50.0, this.time.milliseconds());
        this.time.sleep((long)samples * windowMs);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)max.measure(config, this.time.milliseconds()), (double)EPS);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDuplicateMetricName() {
        this.metrics.sensor("test").add(new MetricName("test", "grp1"), (MeasurableStat)new Avg());
        this.metrics.sensor("test2").add(new MetricName("test", "grp1"), (MeasurableStat)new Total());
    }

    @Test
    public void testQuotas() {
        Sensor sensor = this.metrics.sensor("test");
        sensor.add(new MetricName("test1.total", "grp1"), (MeasurableStat)new Total(), new MetricConfig().quota(Quota.lessThan((double)5.0)));
        sensor.add(new MetricName("test2.total", "grp1"), (MeasurableStat)new Total(), new MetricConfig().quota(Quota.moreThan((double)0.0)));
        sensor.record(5.0);
        try {
            sensor.record(1.0);
            Assert.fail((String)"Should have gotten a quota violation.");
        }
        catch (QuotaViolationException e) {
            // empty catch block
        }
        Assert.assertEquals((double)6.0, (double)((KafkaMetric)this.metrics.metrics().get(new MetricName("test1.total", "grp1"))).value(), (double)EPS);
        sensor.record(-6.0);
        try {
            sensor.record(-1.0);
            Assert.fail((String)"Should have gotten a quota violation.");
        }
        catch (QuotaViolationException quotaViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testPercentiles() {
        int i;
        int buckets = 100;
        Percentiles percs = new Percentiles(4 * buckets, 0.0, 100.0, Percentiles.BucketSizing.CONSTANT, new Percentile[]{new Percentile(new MetricName("test.p25", "grp1"), 25.0), new Percentile(new MetricName("test.p50", "grp1"), 50.0), new Percentile(new MetricName("test.p75", "grp1"), 75.0)});
        MetricConfig config = new MetricConfig().eventWindow(50L).samples(2);
        Sensor sensor = this.metrics.sensor("test", config, new Sensor[0]);
        sensor.add((CompoundStat)percs);
        Metric p25 = (Metric)this.metrics.metrics().get(new MetricName("test.p25", "grp1"));
        Metric p50 = (Metric)this.metrics.metrics().get(new MetricName("test.p50", "grp1"));
        Metric p75 = (Metric)this.metrics.metrics().get(new MetricName("test.p75", "grp1"));
        for (i = 0; i < buckets; ++i) {
            sensor.record((double)i);
        }
        Assert.assertEquals((double)25.0, (double)p25.value(), (double)1.0);
        Assert.assertEquals((double)50.0, (double)p50.value(), (double)1.0);
        Assert.assertEquals((double)75.0, (double)p75.value(), (double)1.0);
        for (i = 0; i < buckets; ++i) {
            sensor.record(0.0);
        }
        Assert.assertEquals((double)0.0, (double)p25.value(), (double)1.0);
        Assert.assertEquals((double)0.0, (double)p50.value(), (double)1.0);
        Assert.assertEquals((double)0.0, (double)p75.value(), (double)1.0);
    }

    public static class ConstantMeasurable
    implements Measurable {
        public double value = 0.0;

        public double measure(MetricConfig config, long now) {
            return this.value;
        }
    }
}

