/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.ConsumerMetadataRequest;
import org.apache.kafka.common.requests.ConsumerMetadataResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.junit.Assert;
import org.junit.Test;

public class RequestResponseTest {
    @Test
    public void testSerialization() throws Exception {
        List<AbstractRequestResponse> requestList = Arrays.asList(this.createRequestHeader(), this.createResponseHeader(), this.createConsumerMetadataRequest(), this.createConsumerMetadataResponse(), this.createFetchRequest(), this.createFetchResponse(), this.createHeartBeatRequest(), this.createHeartBeatResponse(), this.createJoinGroupRequest(), this.createJoinGroupResponse(), this.createListOffsetRequest(), this.createListOffsetResponse(), this.createMetadataRequest(), this.createMetadataResponse(), this.createOffsetCommitRequest(), this.createOffsetCommitResponse(), this.createOffsetFetchRequest(), this.createOffsetFetchResponse(), this.createProduceRequest(), this.createProduceResponse());
        for (AbstractRequestResponse req : requestList) {
            ByteBuffer buffer = ByteBuffer.allocate(req.sizeOf());
            req.writeTo(buffer);
            buffer.rewind();
            Method deserializer = req.getClass().getDeclaredMethod("parse", ByteBuffer.class);
            AbstractRequestResponse deserialized = (AbstractRequestResponse)deserializer.invoke(null, buffer);
            Assert.assertEquals((String)("The original and deserialized of " + req.getClass().getSimpleName() + " should be the same."), (Object)req, (Object)deserialized);
            Assert.assertEquals((String)("The original and deserialized of " + req.getClass().getSimpleName() + " should have the same hashcode."), (long)req.hashCode(), (long)deserialized.hashCode());
        }
    }

    private AbstractRequestResponse createRequestHeader() {
        return new RequestHeader(10, 1, "", 10);
    }

    private AbstractRequestResponse createResponseHeader() {
        return new ResponseHeader(10);
    }

    private AbstractRequestResponse createConsumerMetadataRequest() {
        return new ConsumerMetadataRequest("test-group");
    }

    private AbstractRequestResponse createConsumerMetadataResponse() {
        return new ConsumerMetadataResponse(1, new Node(10, "host1", 2014));
    }

    private AbstractRequestResponse createFetchRequest() {
        HashMap<TopicPartition, FetchRequest.PartitionData> fetchData = new HashMap<TopicPartition, FetchRequest.PartitionData>();
        fetchData.put(new TopicPartition("test1", 0), new FetchRequest.PartitionData(100L, 1000000));
        fetchData.put(new TopicPartition("test2", 0), new FetchRequest.PartitionData(200L, 1000000));
        return new FetchRequest(-1, 100, 100000, fetchData);
    }

    private AbstractRequestResponse createFetchResponse() {
        HashMap<TopicPartition, FetchResponse.PartitionData> responseData = new HashMap<TopicPartition, FetchResponse.PartitionData>();
        responseData.put(new TopicPartition("test", 0), new FetchResponse.PartitionData(0, 1000000L, ByteBuffer.allocate(10)));
        return new FetchResponse(responseData);
    }

    private AbstractRequestResponse createHeartBeatRequest() {
        return new HeartbeatRequest("group1", 1, "consumer1");
    }

    private AbstractRequestResponse createHeartBeatResponse() {
        return new HeartbeatResponse(0);
    }

    private AbstractRequestResponse createJoinGroupRequest() {
        return new JoinGroupRequest("group1", 30000, Arrays.asList("topic1"), "consumer1", "strategy1");
    }

    private AbstractRequestResponse createJoinGroupResponse() {
        return new JoinGroupResponse(0, 1, "consumer1", Arrays.asList(new TopicPartition("test11", 1), new TopicPartition("test2", 1)));
    }

    private AbstractRequestResponse createListOffsetRequest() {
        HashMap<TopicPartition, ListOffsetRequest.PartitionData> offsetData = new HashMap<TopicPartition, ListOffsetRequest.PartitionData>();
        offsetData.put(new TopicPartition("test", 0), new ListOffsetRequest.PartitionData(1000000L, 10));
        return new ListOffsetRequest(-1, offsetData);
    }

    private AbstractRequestResponse createListOffsetResponse() {
        HashMap<TopicPartition, ListOffsetResponse.PartitionData> responseData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
        responseData.put(new TopicPartition("test", 0), new ListOffsetResponse.PartitionData(0, Arrays.asList(100L)));
        return new ListOffsetResponse(responseData);
    }

    private AbstractRequestResponse createMetadataRequest() {
        return new MetadataRequest(Arrays.asList("topic1"));
    }

    private AbstractRequestResponse createMetadataResponse() {
        Node node = new Node(1, "host1", 1001);
        Node[] replicas = new Node[]{node};
        Node[] isr = new Node[]{node};
        Cluster cluster = new Cluster(Arrays.asList(node), Arrays.asList(new PartitionInfo("topic1", 1, node, replicas, isr)));
        return new MetadataResponse(cluster);
    }

    private AbstractRequestResponse createOffsetCommitRequest() {
        HashMap<TopicPartition, OffsetCommitRequest.PartitionData> commitData = new HashMap<TopicPartition, OffsetCommitRequest.PartitionData>();
        commitData.put(new TopicPartition("test", 0), new OffsetCommitRequest.PartitionData(100L, 1000000L, ""));
        return new OffsetCommitRequest("group1", 100, "consumer1", commitData);
    }

    private AbstractRequestResponse createOffsetCommitResponse() {
        HashMap<TopicPartition, Short> responseData = new HashMap<TopicPartition, Short>();
        responseData.put(new TopicPartition("test", 0), (short)0);
        return new OffsetCommitResponse(responseData);
    }

    private AbstractRequestResponse createOffsetFetchRequest() {
        return new OffsetFetchRequest("group1", Arrays.asList(new TopicPartition("test11", 1)));
    }

    private AbstractRequestResponse createOffsetFetchResponse() {
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> responseData = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        responseData.put(new TopicPartition("test", 0), new OffsetFetchResponse.PartitionData(100L, "", 0));
        return new OffsetFetchResponse(responseData);
    }

    private AbstractRequestResponse createProduceRequest() {
        HashMap<TopicPartition, ByteBuffer> produceData = new HashMap<TopicPartition, ByteBuffer>();
        produceData.put(new TopicPartition("test", 0), ByteBuffer.allocate(10));
        return new ProduceRequest(0, 5000, produceData);
    }

    private AbstractRequestResponse createProduceResponse() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        responseData.put(new TopicPartition("test", 0), new ProduceResponse.PartitionResponse(0, 10000L));
        return new ProduceResponse(responseData);
    }
}

