/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.Arrays;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.ClientUtils;
import org.junit.Test;

public class ClientUtilsTest {
    @Test
    public void testParseAndValidateAddresses() {
        this.check("127.0.0.1:8000");
        this.check("mydomain.com:8080");
        this.check("[::1]:8000");
        this.check("[2001:db8:85a3:8d3:1319:8a2e:370:7348]:1234", "mydomain.com:10000");
    }

    @Test(expected=ConfigException.class)
    public void testNoPort() {
        this.check("127.0.0.1");
    }

    private void check(String ... url) {
        ClientUtils.parseAndValidateAddresses(Arrays.asList(url));
    }
}

