/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class UtilsTest {
    @Test
    public void testGetHost() {
        Assert.assertEquals((Object)"127.0.0.1", (Object)Utils.getHost((String)"127.0.0.1:8000"));
        Assert.assertEquals((Object)"mydomain.com", (Object)Utils.getHost((String)"mydomain.com:8080"));
        Assert.assertEquals((Object)"::1", (Object)Utils.getHost((String)"[::1]:1234"));
        Assert.assertEquals((Object)"2001:db8:85a3:8d3:1319:8a2e:370:7348", (Object)Utils.getHost((String)"[2001:db8:85a3:8d3:1319:8a2e:370:7348]:5678"));
    }

    @Test
    public void testGetPort() {
        Assert.assertEquals((long)8000L, (long)Utils.getPort((String)"127.0.0.1:8000").intValue());
        Assert.assertEquals((long)8080L, (long)Utils.getPort((String)"mydomain.com:8080").intValue());
        Assert.assertEquals((long)1234L, (long)Utils.getPort((String)"[::1]:1234").intValue());
        Assert.assertEquals((long)5678L, (long)Utils.getPort((String)"[2001:db8:85a3:8d3:1319:8a2e:370:7348]:5678").intValue());
    }

    @Test
    public void testFormatAddress() {
        Assert.assertEquals((Object)"127.0.0.1:8000", (Object)Utils.formatAddress((String)"127.0.0.1", (Integer)8000));
        Assert.assertEquals((Object)"mydomain.com:8080", (Object)Utils.formatAddress((String)"mydomain.com", (Integer)8080));
        Assert.assertEquals((Object)"[::1]:1234", (Object)Utils.formatAddress((String)"::1", (Integer)1234));
        Assert.assertEquals((Object)"[2001:db8:85a3:8d3:1319:8a2e:370:7348]:5678", (Object)Utils.formatAddress((String)"2001:db8:85a3:8d3:1319:8a2e:370:7348", (Integer)5678));
    }
}

