/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.utils.Time;

public class MockSelector
implements Selectable {
    private final Time time;
    private final List<NetworkSend> completedSends = new ArrayList<NetworkSend>();
    private final List<NetworkReceive> completedReceives = new ArrayList<NetworkReceive>();
    private final List<Integer> disconnected = new ArrayList<Integer>();
    private final List<Integer> connected = new ArrayList<Integer>();

    public MockSelector(Time time) {
        this.time = time;
    }

    public void connect(int id, InetSocketAddress address, int sendBufferSize, int receiveBufferSize) throws IOException {
        this.connected.add(id);
    }

    public void disconnect(int id) {
        this.disconnected.add(id);
    }

    public void wakeup() {
    }

    public void close() {
    }

    public void clear() {
        this.completedSends.clear();
        this.completedReceives.clear();
        this.disconnected.clear();
        this.connected.clear();
    }

    public void poll(long timeout, List<NetworkSend> sends) throws IOException {
        this.completedSends.addAll(sends);
        this.time.sleep(timeout);
    }

    public List<NetworkSend> completedSends() {
        return this.completedSends;
    }

    public void completeSend(NetworkSend send) {
        this.completedSends.add(send);
    }

    public List<NetworkReceive> completedReceives() {
        return this.completedReceives;
    }

    public void completeReceive(NetworkReceive receive) {
        this.completedReceives.add(receive);
    }

    public List<Integer> disconnected() {
        return this.disconnected;
    }

    public List<Integer> connected() {
        return this.connected;
    }
}

