/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;

public class TestUtils {
    public static File IO_TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    public static String LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static String DIGITS = "0123456789";
    public static String LETTERS_AND_DIGITS = LETTERS + DIGITS;
    public static final Random seededRandom = new Random(192348092834L);
    public static final Random random = new Random();

    public static Cluster singletonCluster(String topic, int partitions) {
        return TestUtils.clusterWith(1, topic, partitions);
    }

    public static Cluster clusterWith(int nodes, String topic, int partitions) {
        Node[] ns = new Node[nodes];
        for (int i = 0; i < nodes; ++i) {
            ns[i] = new Node(0, "localhost", 1969);
        }
        ArrayList<PartitionInfo> parts = new ArrayList<PartitionInfo>();
        for (int i = 0; i < partitions; ++i) {
            parts.add(new PartitionInfo(topic, i, ns[i % ns.length], ns, ns));
        }
        return new Cluster(Arrays.asList(ns), parts);
    }

    public static int[] choosePorts(int count) {
        try {
            int i;
            ServerSocket[] sockets = new ServerSocket[count];
            int[] ports = new int[count];
            for (i = 0; i < count; ++i) {
                sockets[i] = new ServerSocket(0);
                ports[i] = sockets[i].getLocalPort();
            }
            for (i = 0; i < count; ++i) {
                sockets[i].close();
            }
            return ports;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int choosePort() {
        return TestUtils.choosePorts(1)[0];
    }

    public static byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        seededRandom.nextBytes(bytes);
        return bytes;
    }

    public static String randomString(int len) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            b.append(LETTERS_AND_DIGITS.charAt(seededRandom.nextInt(LETTERS_AND_DIGITS.length())));
        }
        return b.toString();
    }
}

