/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;

public class RoundRobinAssignorTest {
    private RoundRobinAssignor assignor = new RoundRobinAssignor();

    @Test
    public void testOneConsumerNoTopic() {
        String consumerId = "consumer";
        HashMap partitionsPerTopic = new HashMap();
        Map assignment = this.assignor.assign(partitionsPerTopic, Collections.singletonMap(consumerId, Collections.emptyList()));
        Assert.assertEquals(Collections.singleton(consumerId), assignment.keySet());
        Assert.assertTrue((boolean)((List)assignment.get(consumerId)).isEmpty());
    }

    @Test
    public void testOneConsumerNonexistentTopic() {
        String topic = "topic";
        String consumerId = "consumer";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic, 0);
        Map assignment = this.assignor.assign(partitionsPerTopic, Collections.singletonMap(consumerId, Arrays.asList(topic)));
        Assert.assertEquals(Collections.singleton(consumerId), assignment.keySet());
        Assert.assertTrue((boolean)((List)assignment.get(consumerId)).isEmpty());
    }

    @Test
    public void testOneConsumerOneTopic() {
        String topic = "topic";
        String consumerId = "consumer";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic, 3);
        Map assignment = this.assignor.assign(partitionsPerTopic, Collections.singletonMap(consumerId, Arrays.asList(topic)));
        Assert.assertEquals(Arrays.asList(new TopicPartition(topic, 0), new TopicPartition(topic, 1), new TopicPartition(topic, 2)), assignment.get(consumerId));
    }

    @Test
    public void testOnlyAssignsPartitionsFromSubscribedTopics() {
        String topic = "topic";
        String otherTopic = "other";
        String consumerId = "consumer";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic, 3);
        partitionsPerTopic.put(otherTopic, 3);
        Map assignment = this.assignor.assign(partitionsPerTopic, Collections.singletonMap(consumerId, Arrays.asList(topic)));
        Assert.assertEquals(Arrays.asList(new TopicPartition(topic, 0), new TopicPartition(topic, 1), new TopicPartition(topic, 2)), assignment.get(consumerId));
    }

    @Test
    public void testOneConsumerMultipleTopics() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        String consumerId = "consumer";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic1, 1);
        partitionsPerTopic.put(topic2, 2);
        Map assignment = this.assignor.assign(partitionsPerTopic, Collections.singletonMap(consumerId, Arrays.asList(topic1, topic2)));
        Assert.assertEquals(Arrays.asList(new TopicPartition(topic1, 0), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)), assignment.get(consumerId));
    }

    @Test
    public void testTwoConsumersOneTopicOnePartition() {
        String topic = "topic";
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic, 1);
        HashMap<String, List<String>> consumers = new HashMap<String, List<String>>();
        consumers.put(consumer1, Arrays.asList(topic));
        consumers.put(consumer2, Arrays.asList(topic));
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        Assert.assertEquals(Arrays.asList(new TopicPartition(topic, 0)), assignment.get(consumer1));
        Assert.assertEquals(Collections.emptyList(), assignment.get(consumer2));
    }

    @Test
    public void testTwoConsumersOneTopicTwoPartitions() {
        String topic = "topic";
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic, 2);
        HashMap<String, List<String>> consumers = new HashMap<String, List<String>>();
        consumers.put(consumer1, Arrays.asList(topic));
        consumers.put(consumer2, Arrays.asList(topic));
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        Assert.assertEquals(Arrays.asList(new TopicPartition(topic, 0)), assignment.get(consumer1));
        Assert.assertEquals(Arrays.asList(new TopicPartition(topic, 1)), assignment.get(consumer2));
    }

    @Test
    public void testMultipleConsumersMixedTopics() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        String consumer3 = "consumer3";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic1, 3);
        partitionsPerTopic.put(topic2, 2);
        HashMap<String, List<String>> consumers = new HashMap<String, List<String>>();
        consumers.put(consumer1, Arrays.asList(topic1));
        consumers.put(consumer2, Arrays.asList(topic1, topic2));
        consumers.put(consumer3, Arrays.asList(topic1));
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        Assert.assertEquals(Arrays.asList(new TopicPartition(topic1, 0)), assignment.get(consumer1));
        Assert.assertEquals(Arrays.asList(new TopicPartition(topic1, 1), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)), assignment.get(consumer2));
        Assert.assertEquals(Arrays.asList(new TopicPartition(topic1, 2)), assignment.get(consumer3));
    }

    @Test
    public void testTwoConsumersTwoTopicsSixPartitions() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic1, 3);
        partitionsPerTopic.put(topic2, 3);
        HashMap<String, List<String>> consumers = new HashMap<String, List<String>>();
        consumers.put(consumer1, Arrays.asList(topic1, topic2));
        consumers.put(consumer2, Arrays.asList(topic1, topic2));
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        Assert.assertEquals(Arrays.asList(new TopicPartition(topic1, 0), new TopicPartition(topic1, 2), new TopicPartition(topic2, 1)), assignment.get(consumer1));
        Assert.assertEquals(Arrays.asList(new TopicPartition(topic1, 1), new TopicPartition(topic2, 0), new TopicPartition(topic2, 2)), assignment.get(consumer2));
    }

    public static List<String> topics(String ... topics) {
        return Arrays.asList(topics);
    }

    public static TopicPartition tp(String topic, int partition) {
        return new TopicPartition(topic, partition);
    }
}

