/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.DelayedTask;
import org.apache.kafka.clients.consumer.internals.RequestFuture;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class ConsumerNetworkClientTest {
    private String topicName = "test";
    private MockTime time = new MockTime();
    private MockClient client = new MockClient(this.time);
    private Cluster cluster = TestUtils.singletonCluster(this.topicName, 1);
    private Node node = (Node)this.cluster.nodes().get(0);
    private Metadata metadata = new Metadata(0L, Long.MAX_VALUE);
    private ConsumerNetworkClient consumerClient = new ConsumerNetworkClient((KafkaClient)this.client, this.metadata, (Time)this.time, 100L);

    @Test
    public void send() {
        this.client.prepareResponse(this.heartbeatResponse(Errors.NONE.code()));
        RequestFuture future = this.consumerClient.send(this.node, ApiKeys.METADATA, (AbstractRequest)this.heartbeatRequest());
        Assert.assertEquals((long)1L, (long)this.consumerClient.pendingRequestCount());
        Assert.assertEquals((long)1L, (long)this.consumerClient.pendingRequestCount(this.node));
        Assert.assertFalse((boolean)future.isDone());
        this.consumerClient.poll(future);
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.succeeded());
        ClientResponse clientResponse = (ClientResponse)future.value();
        HeartbeatResponse response = new HeartbeatResponse(clientResponse.responseBody());
        Assert.assertEquals((long)Errors.NONE.code(), (long)response.errorCode());
    }

    @Test
    public void multiSend() {
        this.client.prepareResponse(this.heartbeatResponse(Errors.NONE.code()));
        this.client.prepareResponse(this.heartbeatResponse(Errors.NONE.code()));
        RequestFuture future1 = this.consumerClient.send(this.node, ApiKeys.METADATA, (AbstractRequest)this.heartbeatRequest());
        RequestFuture future2 = this.consumerClient.send(this.node, ApiKeys.METADATA, (AbstractRequest)this.heartbeatRequest());
        Assert.assertEquals((long)2L, (long)this.consumerClient.pendingRequestCount());
        Assert.assertEquals((long)2L, (long)this.consumerClient.pendingRequestCount(this.node));
        this.consumerClient.awaitPendingRequests(this.node);
        Assert.assertTrue((boolean)future1.succeeded());
        Assert.assertTrue((boolean)future2.succeeded());
    }

    @Test
    public void schedule() {
        TestDelayedTask task = new TestDelayedTask();
        this.consumerClient.schedule((DelayedTask)task, this.time.milliseconds());
        this.consumerClient.poll(0L);
        Assert.assertEquals((long)1L, (long)task.executions);
        this.consumerClient.schedule((DelayedTask)task, this.time.milliseconds() + 100L);
        this.consumerClient.poll(0L);
        Assert.assertEquals((long)1L, (long)task.executions);
        this.time.sleep(100L);
        this.consumerClient.poll(0L);
        Assert.assertEquals((long)2L, (long)task.executions);
    }

    @Test
    public void wakeup() {
        RequestFuture future = this.consumerClient.send(this.node, ApiKeys.METADATA, (AbstractRequest)this.heartbeatRequest());
        this.consumerClient.wakeup();
        try {
            this.consumerClient.poll(0L);
            Assert.fail();
        }
        catch (WakeupException wakeupException) {
            // empty catch block
        }
        this.client.respond(this.heartbeatResponse(Errors.NONE.code()));
        this.consumerClient.poll(future);
        Assert.assertTrue((boolean)future.isDone());
    }

    private HeartbeatRequest heartbeatRequest() {
        return new HeartbeatRequest("group", 1, "memberId");
    }

    private Struct heartbeatResponse(short error) {
        HeartbeatResponse response = new HeartbeatResponse(error);
        return response.toStruct();
    }

    private static class TestDelayedTask
    implements DelayedTask {
        int executions = 0;

        private TestDelayedTask() {
        }

        public void run(long now) {
            ++this.executions;
        }
    }
}

