/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.junit.Assert;
import org.junit.Test;

public class DefaultPartitionerTest {
    private byte[] keyBytes = "key".getBytes();
    private Partitioner partitioner = new DefaultPartitioner();
    private Node node0 = new Node(0, "localhost", 99);
    private Node node1 = new Node(1, "localhost", 100);
    private Node node2 = new Node(2, "localhost", 101);
    private Node[] nodes = new Node[]{this.node0, this.node1, this.node2};
    private String topic = "test";
    private List<PartitionInfo> partitions = Arrays.asList(new PartitionInfo(this.topic, 1, null, this.nodes, this.nodes), new PartitionInfo(this.topic, 2, this.node1, this.nodes, this.nodes), new PartitionInfo(this.topic, 0, this.node0, this.nodes, this.nodes));
    private Cluster cluster = new Cluster(Arrays.asList(this.node0, this.node1, this.node2), this.partitions, Collections.emptySet());

    @Test
    public void testKeyPartitionIsStable() {
        int partition = this.partitioner.partition("test", null, this.keyBytes, null, null, this.cluster);
        Assert.assertEquals((String)"Same key should yield same partition", (long)partition, (long)this.partitioner.partition("test", null, this.keyBytes, null, null, this.cluster));
    }

    @Test
    public void testRoundRobinWithUnavailablePartitions() {
        int countForPart0 = 0;
        int countForPart2 = 0;
        for (int i = 1; i <= 100; ++i) {
            int part = this.partitioner.partition("test", null, null, null, null, this.cluster);
            Assert.assertTrue((String)"We should never choose a leader-less node in round robin", (part == 0 || part == 2 ? 1 : 0) != 0);
            if (part == 0) {
                ++countForPart0;
                continue;
            }
            ++countForPart2;
        }
        Assert.assertEquals((String)"The distribution between two available partitions should be even", (long)countForPart0, (long)countForPart2);
    }
}

