/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.junit.Assert;
import org.junit.Test;

public class AbstractConfigTest {
    @Test
    public void testConfiguredInstances() {
        this.testValidInputs("");
        this.testValidInputs("org.apache.kafka.common.metrics.FakeMetricsReporter");
        this.testValidInputs("org.apache.kafka.common.metrics.FakeMetricsReporter, org.apache.kafka.common.metrics.FakeMetricsReporter");
        this.testInvalidInputs(",");
        this.testInvalidInputs("org.apache.kafka.clients.producer.unknown-metrics-reporter");
        this.testInvalidInputs("test1,test2");
        this.testInvalidInputs("org.apache.kafka.common.metrics.FakeMetricsReporter,");
    }

    @Test
    public void testOriginalsWithPrefix() {
        Properties props = new Properties();
        props.put("foo.bar", "abc");
        props.put("setting", "def");
        TestConfig config = new TestConfig(props);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("bar", "abc");
        Assert.assertEquals(expected, (Object)config.originalsWithPrefix("foo."));
    }

    private void testValidInputs(String configValue) {
        Properties props = new Properties();
        props.put("metric.reporters", configValue);
        TestConfig config = new TestConfig(props);
        try {
            config.getConfiguredInstances("metric.reporters", MetricsReporter.class);
        }
        catch (ConfigException e) {
            Assert.fail((String)("No exceptions are expected here, valid props are :" + props));
        }
    }

    private void testInvalidInputs(String configValue) {
        Properties props = new Properties();
        props.put("metric.reporters", configValue);
        TestConfig config = new TestConfig(props);
        try {
            config.getConfiguredInstances("metric.reporters", MetricsReporter.class);
            Assert.fail((String)("Expected a config exception due to invalid props :" + props));
        }
        catch (KafkaException kafkaException) {
            // empty catch block
        }
    }

    private static class TestConfig
    extends AbstractConfig {
        private static final ConfigDef CONFIG = new ConfigDef().define("metric.reporters", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "A list of classes to use as metrics reporters.");
        public static final String METRIC_REPORTER_CLASSES_CONFIG = "metric.reporters";
        private static final String METRIC_REPORTER_CLASSES_DOC = "A list of classes to use as metrics reporters.";

        public TestConfig(Map<?, ?> props) {
            super(CONFIG, props);
        }
    }
}

