/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.types.Password;
import org.junit.Assert;
import org.junit.Test;

public class ConfigDefTest {
    @Test
    public void testBasicTypes() {
        ConfigDef def = new ConfigDef().define("a", ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)14), ConfigDef.Importance.HIGH, "docs").define("b", ConfigDef.Type.LONG, ConfigDef.Importance.HIGH, "docs").define("c", ConfigDef.Type.STRING, (Object)"hello", ConfigDef.Importance.HIGH, "docs").define("d", ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "docs").define("e", ConfigDef.Type.DOUBLE, ConfigDef.Importance.HIGH, "docs").define("f", ConfigDef.Type.CLASS, ConfigDef.Importance.HIGH, "docs").define("g", ConfigDef.Type.BOOLEAN, ConfigDef.Importance.HIGH, "docs").define("h", ConfigDef.Type.BOOLEAN, ConfigDef.Importance.HIGH, "docs").define("i", ConfigDef.Type.BOOLEAN, ConfigDef.Importance.HIGH, "docs").define("j", ConfigDef.Type.PASSWORD, ConfigDef.Importance.HIGH, "docs");
        Properties props = new Properties();
        props.put("a", "1   ");
        props.put("b", (Object)2);
        props.put("d", " a , b, c");
        props.put("e", (Object)42.5);
        props.put("f", String.class.getName());
        props.put("g", "true");
        props.put("h", "FalSE");
        props.put("i", "TRUE");
        props.put("j", "password");
        Map vals = def.parse((Map)props);
        Assert.assertEquals((Object)1, vals.get("a"));
        Assert.assertEquals((Object)2L, vals.get("b"));
        Assert.assertEquals((Object)"hello", vals.get("c"));
        Assert.assertEquals(Arrays.asList("a", "b", "c"), vals.get("d"));
        Assert.assertEquals((Object)42.5, vals.get("e"));
        Assert.assertEquals(String.class, vals.get("f"));
        Assert.assertEquals((Object)true, vals.get("g"));
        Assert.assertEquals((Object)false, vals.get("h"));
        Assert.assertEquals((Object)true, vals.get("i"));
        Assert.assertEquals((Object)new Password("password"), vals.get("j"));
        Assert.assertEquals((Object)"[hidden]", (Object)vals.get("j").toString());
    }

    @Test(expected=ConfigException.class)
    public void testInvalidDefault() {
        new ConfigDef().define("a", ConfigDef.Type.INT, (Object)"hello", ConfigDef.Importance.HIGH, "docs");
    }

    @Test
    public void testNullDefault() {
        ConfigDef def = new ConfigDef().define("a", ConfigDef.Type.INT, null, null, null, "docs");
        Map vals = def.parse((Map)new Properties());
        Assert.assertEquals(null, vals.get("a"));
    }

    @Test(expected=ConfigException.class)
    public void testMissingRequired() {
        new ConfigDef().define("a", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs").parse(new HashMap());
    }

    @Test(expected=ConfigException.class)
    public void testDefinedTwice() {
        new ConfigDef().define("a", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "docs").define("a", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "docs");
    }

    @Test
    public void testBadInputs() {
        this.testBadInputs(ConfigDef.Type.INT, "hello", "42.5", 42.5, Long.MAX_VALUE, Long.toString(Long.MAX_VALUE), new Object());
        this.testBadInputs(ConfigDef.Type.LONG, "hello", "42.5", Long.toString(Long.MAX_VALUE) + "00", new Object());
        this.testBadInputs(ConfigDef.Type.DOUBLE, "hello", new Object());
        this.testBadInputs(ConfigDef.Type.STRING, new Object());
        this.testBadInputs(ConfigDef.Type.LIST, 53, new Object());
        this.testBadInputs(ConfigDef.Type.BOOLEAN, "hello", "truee", "fals");
    }

    private void testBadInputs(ConfigDef.Type type, Object ... values) {
        for (Object value : values) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("name", value);
            ConfigDef def = new ConfigDef().define("name", type, ConfigDef.Importance.HIGH, "docs");
            try {
                def.parse(m);
                Assert.fail((String)("Expected a config exception on bad input for value " + value));
            }
            catch (ConfigException configException) {
                // empty catch block
            }
        }
    }

    @Test(expected=ConfigException.class)
    public void testInvalidDefaultRange() {
        new ConfigDef().define("name", ConfigDef.Type.INT, (Object)-1, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)10), ConfigDef.Importance.HIGH, "docs");
    }

    @Test(expected=ConfigException.class)
    public void testInvalidDefaultString() {
        new ConfigDef().define("name", ConfigDef.Type.STRING, (Object)"bad", (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{"valid", "values"}), ConfigDef.Importance.HIGH, "docs");
    }

    @Test
    public void testValidators() {
        this.testValidators(ConfigDef.Type.INT, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)10), 5, new Object[]{1, 5, 9}, new Object[]{-1, 11});
        this.testValidators(ConfigDef.Type.STRING, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{"good", "values", "default"}), "default", new Object[]{"good", "values", "default"}, new Object[]{"bad", "inputs"});
    }

    @Test
    public void testSslPasswords() {
        ConfigDef def = new ConfigDef();
        SslConfigs.addClientSslSupport((ConfigDef)def);
        Properties props = new Properties();
        props.put("ssl.key.password", "key_password");
        props.put("ssl.keystore.password", "keystore_password");
        props.put("ssl.truststore.password", "truststore_password");
        Map vals = def.parse((Map)props);
        Assert.assertEquals((Object)new Password("key_password"), vals.get("ssl.key.password"));
        Assert.assertEquals((Object)"[hidden]", (Object)vals.get("ssl.key.password").toString());
        Assert.assertEquals((Object)new Password("keystore_password"), vals.get("ssl.keystore.password"));
        Assert.assertEquals((Object)"[hidden]", (Object)vals.get("ssl.keystore.password").toString());
        Assert.assertEquals((Object)new Password("truststore_password"), vals.get("ssl.truststore.password"));
        Assert.assertEquals((Object)"[hidden]", (Object)vals.get("ssl.truststore.password").toString());
    }

    private void testValidators(ConfigDef.Type type, ConfigDef.Validator validator, Object defaultVal, Object[] okValues, Object[] badValues) {
        HashMap<String, Object> m;
        ConfigDef def = new ConfigDef().define("name", type, defaultVal, validator, ConfigDef.Importance.HIGH, "docs");
        for (Object value : okValues) {
            m = new HashMap<String, Object>();
            m.put("name", value);
            def.parse(m);
        }
        for (Object value : badValues) {
            m = new HashMap();
            m.put("name", value);
            try {
                def.parse(m);
                Assert.fail((String)("Expected a config exception due to invalid value " + value));
            }
            catch (ConfigException configException) {
                // empty catch block
            }
        }
    }
}

