/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MemoryRecordsTest {
    private CompressionType compression;

    public MemoryRecordsTest(CompressionType compression) {
        this.compression = compression;
    }

    @Test
    public void testIterator() {
        MemoryRecords recs1 = MemoryRecords.emptyRecords((ByteBuffer)ByteBuffer.allocate(1024), (CompressionType)this.compression);
        MemoryRecords recs2 = MemoryRecords.emptyRecords((ByteBuffer)ByteBuffer.allocate(1024), (CompressionType)this.compression);
        List<Record> list = Arrays.asList(new Record("a".getBytes(), "1".getBytes()), new Record("b".getBytes(), "2".getBytes()), new Record("c".getBytes(), "3".getBytes()));
        for (int i = 0; i < list.size(); ++i) {
            Record r = list.get(i);
            recs1.append((long)i, r);
            recs2.append((long)i, Utils.toArray((ByteBuffer)r.key()), Utils.toArray((ByteBuffer)r.value()));
        }
        recs1.close();
        recs2.close();
        for (int iteration = 0; iteration < 2; ++iteration) {
            for (MemoryRecords recs : Arrays.asList(recs1, recs2)) {
                Iterator iter = recs.iterator();
                for (int i = 0; i < list.size(); ++i) {
                    Assert.assertTrue((boolean)iter.hasNext());
                    LogEntry entry = (LogEntry)iter.next();
                    Assert.assertEquals((long)i, (long)entry.offset());
                    Assert.assertEquals((Object)list.get(i), (Object)entry.record());
                    entry.record().ensureValid();
                }
                Assert.assertFalse((boolean)iter.hasNext());
            }
        }
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (CompressionType type : CompressionType.values()) {
            values.add(new Object[]{type});
        }
        return values;
    }
}

