/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.InvalidRecordException;
import org.apache.kafka.common.record.Record;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RecordTest {
    private ByteBuffer key;
    private ByteBuffer value;
    private CompressionType compression;
    private Record record;

    public RecordTest(byte[] key, byte[] value, CompressionType compression) {
        this.key = key == null ? null : ByteBuffer.wrap(key);
        this.value = value == null ? null : ByteBuffer.wrap(value);
        this.compression = compression;
        this.record = new Record(key, value, compression);
    }

    @Test
    public void testFields() {
        Assert.assertEquals((Object)this.compression, (Object)this.record.compressionType());
        Assert.assertEquals((Object)(this.key != null ? 1 : 0), (Object)this.record.hasKey());
        Assert.assertEquals((Object)this.key, (Object)this.record.key());
        if (this.key != null) {
            Assert.assertEquals((long)this.key.limit(), (long)this.record.keySize());
        }
        Assert.assertEquals((long)0L, (long)this.record.magic());
        Assert.assertEquals((Object)this.value, (Object)this.record.value());
        if (this.value != null) {
            Assert.assertEquals((long)this.value.limit(), (long)this.record.valueSize());
        }
    }

    @Test
    public void testChecksum() {
        Assert.assertEquals((long)this.record.checksum(), (long)this.record.computeChecksum());
        Assert.assertEquals((long)this.record.checksum(), (long)Record.computeChecksum((byte[])(this.key == null ? null : this.key.array()), (byte[])(this.value == null ? null : this.value.array()), (CompressionType)this.compression, (int)0, (int)-1));
        Assert.assertTrue((boolean)this.record.isValid());
        for (int i = 4; i < this.record.size(); ++i) {
            Record copy = this.copyOf(this.record);
            copy.buffer().put(i, (byte)69);
            Assert.assertFalse((boolean)copy.isValid());
            try {
                copy.ensureValid();
                Assert.fail((String)"Should fail the above test.");
                continue;
            }
            catch (InvalidRecordException invalidRecordException) {
                // empty catch block
            }
        }
    }

    private Record copyOf(Record record) {
        ByteBuffer buffer = ByteBuffer.allocate(record.size());
        record.buffer().put(buffer);
        buffer.rewind();
        record.buffer().rewind();
        return new Record(buffer);
    }

    @Test
    public void testEquality() {
        Assert.assertEquals((Object)this.record, (Object)this.copyOf(this.record));
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        byte[] payload = new byte[1000];
        Arrays.fill(payload, (byte)1);
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (byte[] key : Arrays.asList(null, "".getBytes(), "key".getBytes(), payload)) {
            for (byte[] value : Arrays.asList(null, "".getBytes(), "value".getBytes(), payload)) {
                for (CompressionType compression : CompressionType.values()) {
                    values.add(new Object[]{key, value, compression});
                }
            }
        }
        return values;
    }
}

