/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.Compressor;
import org.apache.kafka.common.record.InvalidRecordException;
import org.apache.kafka.common.utils.Crc32;
import org.apache.kafka.common.utils.Utils;

public final class Record {
    public static final int CRC_OFFSET = 0;
    public static final int CRC_LENGTH = 4;
    public static final int MAGIC_OFFSET = 4;
    public static final int MAGIC_LENGTH = 1;
    public static final int ATTRIBUTES_OFFSET = 5;
    public static final int ATTRIBUTE_LENGTH = 1;
    public static final int KEY_SIZE_OFFSET = 6;
    public static final int KEY_SIZE_LENGTH = 4;
    public static final int KEY_OFFSET = 10;
    public static final int VALUE_SIZE_LENGTH = 4;
    public static final int HEADER_SIZE = 6;
    public static final int RECORD_OVERHEAD = 14;
    public static final byte CURRENT_MAGIC_VALUE = 0;
    public static final int COMPRESSION_CODEC_MASK = 7;
    public static final int NO_COMPRESSION = 0;
    private final ByteBuffer buffer;

    public Record(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public Record(byte[] key, byte[] value, CompressionType type, int valueOffset, int valueSize) {
        this(ByteBuffer.allocate(Record.recordSize(key == null ? 0 : key.length, value == null ? 0 : (valueSize >= 0 ? valueSize : value.length - valueOffset))));
        Record.write(this.buffer, key, value, type, valueOffset, valueSize);
        this.buffer.rewind();
    }

    public Record(byte[] key, byte[] value, CompressionType type) {
        this(key, value, type, 0, -1);
    }

    public Record(byte[] value, CompressionType type) {
        this(null, value, type);
    }

    public Record(byte[] key, byte[] value) {
        this(key, value, CompressionType.NONE);
    }

    public Record(byte[] value) {
        this(null, value, CompressionType.NONE);
    }

    public static void write(ByteBuffer buffer, byte[] key, byte[] value, CompressionType type, int valueOffset, int valueSize) {
        Compressor compressor = new Compressor(buffer, CompressionType.NONE, buffer.capacity());
        compressor.putRecord(key, value, type, valueOffset, valueSize);
    }

    public static void write(Compressor compressor, long crc, byte attributes, byte[] key, byte[] value, int valueOffset, int valueSize) {
        compressor.putInt((int)(crc & 0xFFFFFFFFL));
        compressor.putByte((byte)0);
        compressor.putByte(attributes);
        if (key == null) {
            compressor.putInt(-1);
        } else {
            compressor.putInt(key.length);
            compressor.put(key, 0, key.length);
        }
        if (value == null) {
            compressor.putInt(-1);
        } else {
            int size = valueSize >= 0 ? valueSize : value.length - valueOffset;
            compressor.putInt(size);
            compressor.put(value, valueOffset, size);
        }
    }

    public static int recordSize(byte[] key, byte[] value) {
        return Record.recordSize(key == null ? 0 : key.length, value == null ? 0 : value.length);
    }

    public static int recordSize(int keySize, int valueSize) {
        return 10 + keySize + 4 + valueSize;
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public static byte computeAttributes(CompressionType type) {
        byte attributes = 0;
        if (type.id > 0) {
            attributes = (byte)(attributes | 7 & type.id);
        }
        return attributes;
    }

    public static long computeChecksum(ByteBuffer buffer, int position, int size) {
        Crc32 crc = new Crc32();
        crc.update(buffer.array(), buffer.arrayOffset() + position, size);
        return crc.getValue();
    }

    public static long computeChecksum(byte[] key, byte[] value, CompressionType type, int valueOffset, int valueSize) {
        Crc32 crc = new Crc32();
        crc.update(0);
        int attributes = 0;
        if (type.id > 0) {
            attributes = (byte)(attributes | 7 & type.id);
        }
        crc.update(attributes);
        if (key == null) {
            crc.updateInt(-1);
        } else {
            crc.updateInt(key.length);
            crc.update(key, 0, key.length);
        }
        if (value == null) {
            crc.updateInt(-1);
        } else {
            int size = valueSize >= 0 ? valueSize : value.length - valueOffset;
            crc.updateInt(size);
            crc.update(value, valueOffset, size);
        }
        return crc.getValue();
    }

    public long computeChecksum() {
        return Record.computeChecksum(this.buffer, 4, this.buffer.limit() - 4);
    }

    public long checksum() {
        return Utils.readUnsignedInt(this.buffer, 0);
    }

    public boolean isValid() {
        return this.checksum() == this.computeChecksum();
    }

    public void ensureValid() {
        if (!this.isValid()) {
            throw new InvalidRecordException("Record is corrupt (stored crc = " + this.checksum() + ", computed crc = " + this.computeChecksum() + ")");
        }
    }

    public int size() {
        return this.buffer.limit();
    }

    public int keySize() {
        return this.buffer.getInt(6);
    }

    public boolean hasKey() {
        return this.keySize() >= 0;
    }

    private int valueSizeOffset() {
        return 10 + Math.max(0, this.keySize());
    }

    public int valueSize() {
        return this.buffer.getInt(this.valueSizeOffset());
    }

    public byte magic() {
        return this.buffer.get(4);
    }

    public byte attributes() {
        return this.buffer.get(5);
    }

    public CompressionType compressionType() {
        return CompressionType.forId(this.buffer.get(5) & 7);
    }

    public ByteBuffer value() {
        return this.sliceDelimited(this.valueSizeOffset());
    }

    public ByteBuffer key() {
        return this.sliceDelimited(6);
    }

    private ByteBuffer sliceDelimited(int start) {
        int size = this.buffer.getInt(start);
        if (size < 0) {
            return null;
        }
        ByteBuffer b = this.buffer.duplicate();
        b.position(start + 4);
        b = b.slice();
        b.limit(size);
        b.rewind();
        return b;
    }

    public String toString() {
        return String.format("Record(magic = %d, attributes = %d, compression = %s, crc = %d, key = %d bytes, value = %d bytes)", new Object[]{this.magic(), this.attributes(), this.compressionType(), this.checksum(), this.key() == null ? 0 : this.key().limit(), this.value() == null ? 0 : this.value().limit()});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(Record.class)) {
            return false;
        }
        Record record = (Record)other;
        return this.buffer.equals(record.buffer);
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }
}

